package com.xebialabs.xlrelease.domain.versioning.ascode.validation;

import java.util.Objects;

public class FolderInfo {
    private final String id;
    private final String relativePath;
    private final String absolutePath;

    public FolderInfo(String id, String relativePath, String absolutePath) {
        this.id = id;
        this.relativePath = relativePath;
        this.absolutePath = absolutePath;
    }

    public String getId() {
        return id;
    }

    public String getRelativePath() {
        return relativePath;
    }

    public String getAbsolutePath() {
        return absolutePath;
    }

    @Override
    public boolean equals(final Object o) {
        if (o == null || getClass() != o.getClass()) return false;
        final FolderInfo that = (FolderInfo) o;
        return Objects.equals(id, that.id) && Objects.equals(relativePath, that.relativePath) && Objects.equals(absolutePath, that.absolutePath);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, relativePath, absolutePath);
    }
}
