package com.xebialabs.xlrelease.domain.versioning.ascode.validation;

import java.util.Objects;

import com.xebialabs.xlrelease.domain.versioning.ascode.CiInfo;

public class MissingPassword implements ValidationMessage {
    private final CiInfo ci;
    private final String property;
    private final String placeholder;

    public MissingPassword(CiInfo ci, String property, String placeholder) {
        this.ci = ci;
        this.property = property;
        this.placeholder = placeholder;
    }

    public String getPlaceholder() {
        return placeholder;
    }

    @Override
    public CiInfo getCi() {
        return ci;
    }

    @Override
    public String getProperty() {
        return property;
    }

    @Override
    public String getMessage() {
        return "Password missing (placeholder '" + placeholder + "' empty)";
    }

    @Override
    public String getMessageType() {
        return "MISSING_PASSWORD";
    }

    @Override
    public String getMessageLevel() {
        return ValidationMessage.LEVEL_WARN;
    }

    @Override
    public boolean equals(final Object o) {
        if (o == null || getClass() != o.getClass()) return false;
        final MissingPassword that = (MissingPassword) o;
        return Objects.equals(ci, that.ci) && Objects.equals(property, that.property) && Objects.equals(placeholder, that.placeholder);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ci, property, placeholder);
    }
}
