package com.xebialabs.xlrelease.domain.versioning.ascode.validation;

import java.util.Objects;

import com.xebialabs.xlrelease.domain.versioning.ascode.CiInfo;

public class NonVersionedRef implements ValidationMessage {
    private final CiInfo ci;
    private final String property;
    private final CiInfo ref;

    public NonVersionedRef(CiInfo ci, String property, CiInfo ref) {
        this.ci = ci;
        this.property = property;
        this.ref = ref;
    }

    public CiInfo getRef() {
        return ref;
    }

    @Override
    public CiInfo getCi() {
        return ci;
    }

    @Override
    public String getProperty() {
        return property;
    }

    @Override
    public String getMessage() {
        return "Contains a reference to an external/non-versioned CI";
    }

    @Override
    public String getMessageType() {
        return "NON_VERSIONED_REFERENCE";
    }

    @Override
    public String getMessageLevel() {
        return ValidationMessage.LEVEL_WARN;
    }

    @Override
    public boolean equals(final Object o) {
        if (o == null || getClass() != o.getClass()) return false;
        final NonVersionedRef that = (NonVersionedRef) o;
        return Objects.equals(ci, that.ci) && Objects.equals(property, that.property) && Objects.equals(ref, that.ref);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ci, property, ref);
    }
}
