package com.xebialabs.xlrelease.domain.versioning.ascode.validation;

import com.xebialabs.xlrelease.domain.versioning.ascode.CiInfo;

public interface ValidationMessage {
    CiInfo getCi();

    String getProperty();

    String getMessage();

    String getMessageType();

    String getMessageLevel();

    String LEVEL_ERROR = "ERROR";
    String LEVEL_WARN = "WARNING";

    static ValidationMessage updateCiId(ValidationMessage msg, String id) {
        if (msg instanceof HardcodedPassword hp) {
            return new HardcodedPassword(hp.getCi().withCiId(id), hp.getProperty());
        } else if (msg instanceof MissingPassword mp) {
            return new MissingPassword(mp.getCi().withCiId(id), mp.getProperty(), mp.getPlaceholder());
        } else if (msg instanceof NonVersionedRef nv) {
            return new NonVersionedRef(nv.getCi().withCiId(id), nv.getProperty(), nv.getRef());
        }
        throw new IllegalArgumentException("Unknown ValidationMessage type: " + msg.getClass());
    }
}
