package com.xebialabs.xlrelease.domain.versioning.ascode.validation;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

@PublicApiRef
public class ValidationReport {

    private List<ValidationReportMessage> warnings = new ArrayList<>();
    private List<ValidationReportMessage> errors = new ArrayList<>();

    public List<ValidationReportMessage> getWarnings() {
        return warnings;
    }

    public void setWarnings(List<ValidationReportMessage> warnings) {
        this.warnings = warnings;
    }

    public List<ValidationReportMessage> getErrors() {
        return errors;
    }

    public void setErrors(List<ValidationReportMessage> errors) {
        this.errors = errors;
    }

    public static ValidationReport messagesToReport(List<ValidationMessage> messages) {
        ValidationReport report = new ValidationReport();
        report.getWarnings().addAll(filterAndConvert(ValidationMessage.LEVEL_WARN, messages));
        report.getErrors().addAll(filterAndConvert(ValidationMessage.LEVEL_ERROR, messages));
        return report;
    }

    public static ValidationReport createWarningReport(List<ValidationReportMessage> messages) {
        ValidationReport report = new ValidationReport();
        report.getWarnings().addAll(messages);
        return report;
    }

    private static List<ExternalDependencyReportMessage> filterAndConvert(String level, List<ValidationMessage> messages) {
        List<ExternalDependencyReportMessage> filteredMessageList = new ArrayList<>();
        for (ValidationMessage vm : messages) {
            if (level.equals(vm.getMessageLevel())) {
                filteredMessageList.add(ValidationReportMessageUtil.validationMessageToReportMessage(vm));
            }
        }
        return filteredMessageList;
    }
}
