package com.xebialabs.xlrelease.risk.domain;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.ReleaseExtension;

@Metadata(versioned = false, description = "Assessment generated by risk assessor")
@PublicApiRef
@ShowOnlyPublicApiMembers
public class RiskAssessment extends ReleaseExtension {

    public static final String RISK_ASSESSMENT_PREFIX = "RiskAssessment";

    @Property(description = "The Id of the Risk assessor that generated this assessment.")
    private String riskAssessorId;

    @Property(asContainment = true, description = "The risk this assessment is contained in.")
    private Risk risk;

    @Property(defaultValue = "0", description = "The score of this assessment.")
    private Integer score = 0;

    @Property(description = "Summary message of this assessment.")
    private String headline;

    @Property(description = "Messages that explain the score.")
    private List<String> messages = new ArrayList<>();

    @Property(required = false, description = "Custom icon url that overrides icon from standard assessor icon set.")
    private String icon;

    @PublicApiMember
    public String getRiskAssessorId() {
        return riskAssessorId;
    }

    public void setRiskAssessorId(final String riskAssessorId) {
        this.riskAssessorId = riskAssessorId;
    }

    @PublicApiMember
    public Risk getRisk() {
        return risk;
    }

    public void setRisk(final Risk risk) {
        this.risk = risk;
    }

    @PublicApiMember
    public Integer getScore() {
        return score;
    }

    public void setScore(final Integer score) {
        this.score = score;
    }

    @PublicApiMember
    public String getHeadline() {
        return headline;
    }

    public void setHeadline(final String headline) {
        this.headline = headline;
    }

    @PublicApiMember
    public List<String> getMessages() {
        return messages;
    }

    public void setMessages(final List<String> messages) {
        this.messages = messages;
    }

    @PublicApiMember
    public String getIcon() {
        return icon;
    }

    public void setIcon(final String icon) {
        this.icon = icon;
    }
}
