package com.xebialabs.xlrelease.utils;

import java.util.List;

import com.xebialabs.xlrelease.domain.variables.Variable;

import static com.google.common.base.Strings.nullToEmpty;
import static com.google.common.collect.Lists.newArrayList;

public class VariableContainerUtils {

    public static List<Variable> getVariables(final List<Variable> variables) {
        List<Variable> sorted = newArrayList(variables);
        sorted.sort((left, right) -> {
            String keyLeft = nullToEmpty(left == null ? null : left.getKey());
            String keyRight = nullToEmpty(right == null ? null : right.getKey());
            return keyLeft.compareToIgnoreCase(keyRight);
        });
        return sorted;
    }

    public static void setVariableContainerDefaults(List<Variable> variables) {
        for (Variable v : variables) {
            setVariableContainerDefaults(v);
        }
    }

    public static void setVariableContainerDefaults(Variable variable) {
        variable.setRequiresValue(false);
        variable.setShowOnReleaseStart(false);
    }
}
