/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.variable;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.io.Serializable;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class VariableHelper$ {
    public static VariableHelper$ MODULE$;
    private final String VARIABLE_PATTERN;
    private final Pattern VARIABLE_NAME_PATTERN;
    private final Pattern ONLY_ONE_VARIABLE_NAME_PATTERN;
    private final Pattern CI_PROPERTY_VARIABLE_NAME_PATTERN;
    private final Pattern GLOBAL_VARIABLE_NAME_PATTERN;

    static {
        new VariableHelper$();
    }

    private String VARIABLE_PATTERN() {
        return this.VARIABLE_PATTERN;
    }

    private Pattern VARIABLE_NAME_PATTERN() {
        return this.VARIABLE_NAME_PATTERN;
    }

    private Pattern ONLY_ONE_VARIABLE_NAME_PATTERN() {
        return this.ONLY_ONE_VARIABLE_NAME_PATTERN;
    }

    private Pattern CI_PROPERTY_VARIABLE_NAME_PATTERN() {
        return this.CI_PROPERTY_VARIABLE_NAME_PATTERN;
    }

    private Pattern GLOBAL_VARIABLE_NAME_PATTERN() {
        return this.GLOBAL_VARIABLE_NAME_PATTERN;
    }

    public String replaceAll(String raw, java.util.Map<String, String> replacements) {
        return (String)Option$.MODULE$.apply((Object)raw).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(replacements.entrySet()).asScala()).foldLeft(x$1, (Function2 & Serializable & scala.Serializable)(s, entry) -> s.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue()))).orNull(Predef$.MODULE$.$conforms());
    }

    public String replaceAll(String raw, java.util.Map<String, String> replacements, java.util.Set<String> unresolvedVariables, boolean freezeEvenIfUnresolved) {
        return (String)Option$.MODULE$.apply((Object)this.replaceAll(raw, (java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(replacements).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)VariableHelper$.$anonfun$replaceAll$3(x$2)))).asJava())).map((Function1 & Serializable & scala.Serializable)replaced -> {
            java.util.Set<String> remainingVariables = MODULE$.collectVariables(replaced);
            unresolvedVariables.addAll(remainingVariables);
            return freezeEvenIfUnresolved ? (String)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(remainingVariables).asScala()).foldLeft(replaced, (Function2 & Serializable & scala.Serializable)(s, remainingVariable) -> MODULE$.freezeUnresolvedVariable((String)s, (String)remainingVariable)) : replaced;
        }).orNull(Predef$.MODULE$.$conforms());
    }

    public Object replaceAll(Object raw, java.util.Map<String, String> replacements, java.util.Set<String> unresolvedVariables, boolean freezeEvenIfUnresolved) {
        return Option$.MODULE$.apply(raw).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Object object2 = x0$1;
            if (object2 instanceof String) {
                String string = (String)object2;
                object = this.replaceInValue$1(string, replacements, unresolvedVariables, freezeEvenIfUnresolved);
            } else if (object2 instanceof java.util.List) {
                java.util.List list = (java.util.List)object2;
                object = JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).map((Function1 & Serializable & scala.Serializable)value -> this.replaceInValue$1((String)value, replacements, unresolvedVariables, freezeEvenIfUnresolved), Buffer$.MODULE$.canBuildFrom())).toList()).asJava();
            } else if (object2 instanceof java.util.Set) {
                java.util.Set set = (java.util.Set)object2;
                object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(set).asScala()).map((Function1 & Serializable & scala.Serializable)value -> this.replaceInValue$1((String)value, replacements, unresolvedVariables, freezeEvenIfUnresolved), Set$.MODULE$.canBuildFrom())).toSet()).asJava();
            } else if (object2 instanceof java.util.Map) {
                java.util.Map map = (java.util.Map)object2;
                object = JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.replaceInValue$1((String)t._1(), replacements, unresolvedVariables, freezeEvenIfUnresolved)), (Object)this.replaceInValue$1((String)t._2(), replacements, unresolvedVariables, freezeEvenIfUnresolved)), Map$.MODULE$.canBuildFrom())).asJava();
            } else {
                object = object2;
            }
            return object;
        }).orNull(Predef$.MODULE$.$conforms());
    }

    public String safeReplace(String input, String key, String replacement) {
        return input != null ? input.replace(key, replacement) : input;
    }

    public boolean isCiPropertyVariable(String variableName) {
        return this.CI_PROPERTY_VARIABLE_NAME_PATTERN().matcher(this.withoutVariableSyntax(variableName)).find();
    }

    public boolean isGlobalVariable(String variableName) {
        return this.GLOBAL_VARIABLE_NAME_PATTERN().matcher(this.withoutVariableSyntax(variableName)).find();
    }

    public java.util.Set<String> collectVariables(Object input) {
        return (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Option$.MODULE$.apply(input).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            scala.collection.immutable.Set set;
            Object object = x0$2;
            if (object instanceof String) {
                String string = (String)object;
                set = MODULE$.collectVariablesFromValue(string);
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                set = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(collection).asScala()).flatMap((Function1 & Serializable & scala.Serializable)value -> MODULE$.collectVariablesFromValue(value), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet();
            } else if (object instanceof java.util.Map) {
                java.util.Map map = (java.util.Map)object;
                set = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    Tuple2 tuple2 = x0$3;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Object k = tuple2._1();
                    Object v = tuple2._2();
                    scala.collection.immutable.Set set = (scala.collection.immutable.Set)MODULE$.collectVariablesFromValue(k).$plus$plus(MODULE$.collectVariablesFromValue(v));
                    return set;
                }, Iterable$.MODULE$.canBuildFrom())).toSet();
            } else {
                set = Predef$.MODULE$.Set().empty();
            }
            return set;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())).asJava();
    }

    private scala.collection.immutable.Set<String> collectVariablesFromValue(Object value) {
        scala.collection.mutable.Set result = Set$.MODULE$.empty();
        Object object = value;
        if (object instanceof String) {
            String string = (String)object;
            Matcher matcher = this.VARIABLE_NAME_PATTERN().matcher(string);
            while (matcher.find()) {
                result.add((Object)matcher.group());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return result.toSet();
    }

    public boolean containsVariables(String input) {
        return input != null && this.VARIABLE_NAME_PATTERN().matcher(input).find();
    }

    public String formatVariableIfNeeded(String variableName) {
        return !Strings.isNullOrEmpty((String)variableName) && !this.containsOnlyVariable(variableName) ? this.withVariableSyntax(variableName) : variableName;
    }

    public boolean containsOnlyVariable(String input) {
        return !Strings.isNullOrEmpty((String)input) && this.ONLY_ONE_VARIABLE_NAME_PATTERN().matcher(input).find();
    }

    public String withVariableSyntax(String variableName) {
        return "${" + variableName + "}";
    }

    public String withoutVariableSyntax(String variableKey) {
        String string;
        if (this.containsOnlyVariable(variableKey)) {
            Matcher matcher = this.ONLY_ONE_VARIABLE_NAME_PATTERN().matcher(variableKey);
            matcher.find();
            string = matcher.group(1);
        } else {
            string = variableKey;
        }
        return string;
    }

    public void checkVariable(Variable variable) {
        Preconditions.checkNotNull((Object)variable);
        variable.checkValidity();
    }

    public void checkVariables(java.util.List<Variable> variables) {
        Preconditions.checkNotNull(variables);
        variables.forEach(variable -> MODULE$.checkVariable((Variable)variable));
        Buffer keys = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(variables).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getKey(), Buffer$.MODULE$.canBuildFrom());
        scala.collection.mutable.Set uniqueKeys = Set$.MODULE$.empty();
        keys.foreach((Function1 & Serializable & scala.Serializable)key -> {
            VariableHelper$.$anonfun$checkVariables$3(uniqueKeys, key);
            return BoxedUnit.UNIT;
        });
    }

    public java.util.Map<String, String> getStringVariableValues(java.util.List<Variable> vars) {
        return this.getVariableValuesAsStrings((List<Variable>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(vars).asScala()).toList(), false);
    }

    public java.util.Map<String, String> getPasswordStringVariableValues(java.util.List<Variable> vars) {
        return this.getVariableValuesAsStrings((List<Variable>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(vars).asScala()).toList(), true);
    }

    private java.util.Map<String, String> getVariableValuesAsStrings(List<Variable> variables, boolean passwords) {
        return (java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)((List)variables.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)VariableHelper$.$anonfun$getVariableValuesAsStrings$1(passwords, x$4)))).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> Option$.MODULE$.option2Iterable(MODULE$.VariableExtensions((Variable)x$5).asKeyValue()), List$.MODULE$.canBuildFrom()))).asJava();
    }

    /*
     * WARNING - void declaration
     */
    public java.util.Map<String, Variable> indexByKey(java.util.List<Variable> variables) {
        void var2_2;
        LinkedHashMap m = new LinkedHashMap();
        Option$.MODULE$.apply(variables).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.forEach(v -> m.put((Object)v.getKey(), v));
            return BoxedUnit.UNIT;
        });
        return (java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((Map)var2_2).asJava();
    }

    public void checkVariableIdsAreTheSame(String requestVariableId, String bodyVariableId) {
        String string = bodyVariableId;
        String string2 = requestVariableId;
        Checks.checkArgument((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0, (String)"Request to update variable [%s] contains an object with different ID: [%s]", (Object[])new Object[]{requestVariableId, bodyVariableId});
    }

    public boolean isGlobalVariableId(String id) {
        return id.startsWith("Configuration/variables/global/") || id.startsWith("/Configuration/variables/global/");
    }

    public java.util.List<Variable> fillVariableValues(java.util.List<Variable> target, java.util.List<Variable> source) {
        java.util.Map<String, Variable> sourceVariables = this.indexByKey(source);
        target.forEach(targetVariable -> {
            String key = targetVariable.getKey();
            if (sourceVariables.containsKey(key)) {
                Variable sourceVariable = (Variable)sourceVariables.get(key);
                if (targetVariable.getType().equals((Object)sourceVariable.getType())) {
                    targetVariable.setUntypedValue(sourceVariable.getValue());
                } else {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot set value of type [", "] into "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourceVariable.getType()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"variable ", " of type [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MODULE$.withVariableSyntax(sourceVariable.getKey()), targetVariable.getType()})));
                }
            }
        });
        return target;
    }

    public String freezeUnresolvedVariable(String input, String variableName) {
        String string;
        if (this.containsVariables(variableName)) {
            String dollarLessName = variableName.substring(1);
            string = input.replace(variableName, "$~" + dollarLessName);
        } else {
            string = input;
        }
        return string;
    }

    private VariableHelper.VariableExtensions VariableExtensions(Variable variable) {
        return new VariableHelper.VariableExtensions(variable);
    }

    public static final /* synthetic */ boolean $anonfun$replaceAll$3(Tuple2 x$2) {
        return x$2._2() != null;
    }

    private final String replaceInValue$1(String value, java.util.Map replacements$2, java.util.Set unresolvedVariables$2, boolean freezeEvenIfUnresolved$2) {
        return this.replaceAll(value, (java.util.Map<String, String>)replacements$2, (java.util.Set<String>)unresolvedVariables$2, freezeEvenIfUnresolved$2);
    }

    public static final /* synthetic */ void $anonfun$checkVariables$3(scala.collection.mutable.Set uniqueKeys$1, String key) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((boolean)uniqueKeys$1.add((Object)key), (String)"The variables list contains duplicate keys: '%s'", (Object[])new Object[]{key});
    }

    public static final /* synthetic */ boolean $anonfun$getVariableValuesAsStrings$1(boolean passwords$1, Variable x$4) {
        return x$4.isPassword() == passwords$1;
    }

    private VariableHelper$() {
        MODULE$ = this;
        this.VARIABLE_PATTERN = "\\$\\{[^}]+\\}";
        this.VARIABLE_NAME_PATTERN = Pattern.compile(this.VARIABLE_PATTERN());
        this.ONLY_ONE_VARIABLE_NAME_PATTERN = Pattern.compile("^\\$\\{([^}]+)\\}$");
        this.CI_PROPERTY_VARIABLE_NAME_PATTERN = Pattern.compile("^release\\..*$", 2);
        this.GLOBAL_VARIABLE_NAME_PATTERN = Pattern.compile("^global\\..*$", 2);
    }
}

