/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.internal.InternalMetadata;
import com.xebialabs.xlrelease.domain.CiWithInternalMetadata;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.LinkedHashMap;
import java.util.Map;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(versioned=false)
public class Dependency
extends BaseConfigurationItem
implements CiWithInternalMetadata {
    public static final String TYPE_DEPENDENCY = "xlrelease." + Dependency.class.getSimpleName();
    public static final String PROPERTY_TARGET = "target";
    @Property(asContainment=true, description="The source gate task from the dependency.")
    private GateTask gateTask;
    @Property(required=false, description="The target of the dependency (release, phase, or task).")
    private PlanItem target;
    @Property(required=false, description="The target ID of the dependency (when it is filled, the `target` will be empty).")
    private String targetId;
    @Property(required=false, description="The target title once it is archived.")
    private String archivedTargetTitle;
    @Property(required=false, description="The target ID once it is archived.")
    private String archivedTargetId;
    @Property(required=false, description="Shows if the plan item was `COMPLETED` or `ABORTED`.")
    private boolean archivedAsResolved;
    private Map<String, InternalMetadata> $metadata = new LinkedHashMap<String, InternalMetadata>();

    @PublicApiMember
    public GateTask getGateTask() {
        return this.gateTask;
    }

    @PublicApiMember
    public void setGateTask(GateTask gateTask) {
        this.gateTask = gateTask;
    }

    public <T extends PlanItem> T getTarget() {
        return (T)this.target;
    }

    public void setTarget(PlanItem target) {
        if (null != target && null != target.getId()) {
            this.targetId = target.getId();
        }
        this.target = target;
    }

    public String getTargetId() {
        if (null == this.targetId && null != this.target) {
            this.targetId = this.target.getId();
        }
        return this.targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    @PublicApiMember
    public String getArchivedTargetId() {
        return this.archivedTargetId;
    }

    @PublicApiMember
    public String getArchivedTargetTitle() {
        return this.archivedTargetTitle;
    }

    @PublicApiMember
    public boolean isArchived() {
        return this.archivedTargetId != null || this.archivedTargetTitle != null;
    }

    @PublicApiMember
    public boolean isDone() {
        if (this.isArchived()) {
            return this.archivedAsResolved;
        }
        if (!this.hasResolvedTarget()) {
            return false;
        }
        return ((PlanItem)this.getTarget()).isDone();
    }

    @PublicApiMember
    public boolean isAborted() {
        if (this.isArchived()) {
            return !this.archivedAsResolved;
        }
        if (!this.hasResolvedTarget()) {
            return false;
        }
        return ((PlanItem)this.getTarget()).isAborted();
    }

    @PublicApiMember
    public String getTargetDisplayPath() {
        if (this.isArchived()) {
            return this.getArchivedTargetTitle();
        }
        if (this.hasResolvedTarget()) {
            return ((PlanItem)this.getTarget()).getDisplayPath();
        }
        return this.getTargetId();
    }

    @PublicApiMember
    public String getTargetTitle() {
        if (this.isArchived()) {
            return this.getArchivedTargetTitle();
        }
        if (this.hasResolvedTarget()) {
            return ((PlanItem)this.getTarget()).getTitle();
        }
        return this.getTargetId();
    }

    public void archive() {
        if (this.hasResolvedTarget()) {
            this.archivedTargetId = this.target.getId();
            this.archivedAsResolved = this.target.isDone();
            this.archivedTargetTitle = Dependency.createArchivedTargetTitle(this.target);
            this.target = null;
        } else {
            this.archivedTargetId = this.targetId;
            this.archivedAsResolved = false;
            this.archivedTargetTitle = this.targetId;
            this.targetId = null;
        }
    }

    public boolean isArchivedAsResolved() {
        return this.archivedAsResolved;
    }

    public static String createArchivedTargetTitle(PlanItem planItem) {
        if (planItem instanceof Release) {
            return planItem.getTitle();
        }
        if (planItem instanceof Phase) {
            return String.format("%s / %s", planItem.getRelease().getTitle(), planItem.getTitle());
        }
        if (planItem instanceof Task) {
            return String.format("%s / %s / %s", planItem.getRelease().getTitle(), ((Task)planItem).getPhase().getTitle(), planItem.getTitle());
        }
        return null;
    }

    public boolean hasResolvedTarget() {
        return this.target != null;
    }

    public boolean hasVariableTarget() {
        return VariableHelper.containsVariables(this.targetId);
    }

    public boolean hasValidArchiveTargetId() {
        return !Ids.isNullId(this.archivedTargetId) && this.isValidAllowedPlanItemId();
    }

    private boolean isValidAllowedPlanItemId() {
        return Ids.isReleaseId(this.archivedTargetId) || Ids.isPhaseId(this.archivedTargetId) || Ids.isTaskId(this.archivedTargetId);
    }

    @Override
    public Map<String, InternalMetadata> get$metadata() {
        return this.$metadata;
    }
}

