/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.builder;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.BaseScriptTaskBuilder;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.PythonScript;
import java.util.Map;

public class CustomScriptTaskBuilder
extends BaseScriptTaskBuilder<CustomScriptTask, CustomScriptTaskBuilder> {
    private String type;
    private String scriptDefinitionType;
    private boolean keepPreviousOutputPropertiesOnRetry;
    private Map<String, Object> inputParameters = Maps.newHashMap();
    private Map<String, Object> outputProperties = Maps.newHashMap();
    private String statusLine;

    public CustomScriptTaskBuilder(String scriptDefinitionType) {
        this.scriptDefinitionType = scriptDefinitionType;
    }

    public CustomScriptTaskBuilder(String scriptDefinitionType, String type) {
        this.scriptDefinitionType = scriptDefinitionType;
        this.type = type;
    }

    public CustomScriptTaskBuilder withInputParameters(Map<String, Object> inputParameters) {
        this.inputParameters = inputParameters;
        return this;
    }

    public CustomScriptTaskBuilder withOutputProperties(Map<String, Object> outputProperties) {
        this.outputProperties = outputProperties;
        return this;
    }

    public CustomScriptTaskBuilder withStatusLine(String statusLine) {
        this.statusLine = statusLine;
        return this;
    }

    public CustomScriptTaskBuilder withKeepPreviousOutputPropertiesOnRetry(boolean keepPreviousOutputPropertiesOnRetry) {
        this.keepPreviousOutputPropertiesOnRetry = keepPreviousOutputPropertiesOnRetry;
        return this;
    }

    @Override
    public CustomScriptTask build() {
        CustomScriptTask task = (CustomScriptTask)Type.valueOf(CustomScriptTask.class).getDescriptor().newInstance(null);
        this.setFields(task);
        PythonScript pythonScript = this.type == null ? (PythonScript)Type.valueOf((String)this.scriptDefinitionType).getDescriptor().newInstance(task.getId() + "/" + "PythonScript") : (PythonScript)Type.valueOf((String)this.type).getDescriptor().newInstance(task.getId() + "/" + "PythonScript");
        task.setPythonScript(pythonScript);
        pythonScript.setCustomScriptTask(task);
        for (Map.Entry<String, Object> entry : this.inputParameters.entrySet()) {
            pythonScript.setProperty(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.outputProperties.entrySet()) {
            pythonScript.setProperty(entry.getKey(), entry.getValue());
        }
        task.setStatusLine(this.statusLine);
        task.setKeepPreviousOutputPropertiesOnRetry(this.keepPreviousOutputPropertiesOnRetry);
        return task;
    }
}

