package com.xebialabs.xlrelease.serialization.json.repository

sealed trait ResolveOptions {
  def hasDecorators: Boolean

  def withDecorators: ResolveOptions

  def withoutDecorators: ResolveOptions
}

object ResolveOptions {
  private case class ResolveOptionsImpl(hasDecorators: Boolean) extends ResolveOptions {
    override def withDecorators: ResolveOptions = this.copy(hasDecorators = true)

    override def withoutDecorators: ResolveOptions = this.copy(hasDecorators = false)
  }

  lazy val WITH_DECORATORS: ResolveOptions = ResolveOptionsImpl(true)
  lazy val WITHOUT_DECORATORS: ResolveOptions = ResolveOptionsImpl(false)
}
