package com.xebialabs.xlrelease.serialization.json.repository

sealed trait ResolveOptions {
  def hasDecorators: Boolean

  def shouldResolveReferences: Boolean

  def withDecorators: ResolveOptions

  def withoutDecorators: ResolveOptions

  def withoutReferences: ResolveOptions

  def withReferences: ResolveOptions
}

object ResolveOptions {
  private case class ResolveOptionsImpl(hasDecorators: Boolean, shouldResolveReferences: Boolean = true) extends ResolveOptions {
    override def withDecorators: ResolveOptions = this.copy(hasDecorators = true)

    override def withoutDecorators: ResolveOptions = this.copy(hasDecorators = false)

    override def withoutReferences: ResolveOptions = this.copy(shouldResolveReferences = false)

    override def withReferences: ResolveOptions = this.copy(shouldResolveReferences = true)
  }

  lazy val WITH_DECORATORS: ResolveOptions = ResolveOptionsImpl(true).withReferences
  lazy val WITHOUT_DECORATORS: ResolveOptions = ResolveOptionsImpl(false).withoutReferences
}
