/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.serialization.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.google.common.base.Strings;
import com.xebialabs.deployit.util.PasswordEncrypter;
import java.io.IOException;

public class PasswordDeserializer
extends JsonDeserializer<String> {
    public String deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String value = (String)jsonParser.readValueAs(String.class);
        if (this.isValueEncrypted(value)) {
            throw new IllegalArgumentException("Could not accept encrypted password");
        }
        return value;
    }

    private boolean isValueEncrypted(String value) {
        return !Strings.isNullOrEmpty((String)value) && PasswordEncrypter.getInstance().isEncodedAndDecryptable(value);
    }
}

