package com.xebialabs.xlrelease.serialization.json.jackson;

import java.io.IOException;
import java.util.List;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

import static com.google.common.collect.Lists.newArrayList;

public class DomainIdsDeserializer extends JsonDeserializer<List<String>> implements DomainIdSerialization {
    @Override
    public List<String> deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        List viewIds = jsonParser.readValueAs(List.class);
        List<String> internalIds = newArrayList();
        for (Object viewId : viewIds) {
            internalIds.add(toInternalId((String) viewId));
        }
        return internalIds;
    }
}
