package com.xebialabs.xlrelease.support.pekko.spring

import org.apache.pekko.actor.{Actor, IndirectActorProducer}
import org.springframework.context.ApplicationContext


class SpringActorProducer(private val applicationContext: ApplicationContext,
                          private val actorBeanName: String
                         ) extends IndirectActorProducer {

  override def produce(): Actor = applicationContext.getBean(actorBeanName).asInstanceOf[Actor]

  override def actorClass: Class[_ <: Actor] = classOf[Actor]
}


class TypedSpringActorProducer(private val applicationContext: ApplicationContext,
                               private val actorClazz: Class[_ <: Actor],
                               private val args: AnyRef*
                              ) extends IndirectActorProducer {

  override def produce(): Actor = {
    if (args.isEmpty) {
      applicationContext.getBean(actorClazz)
    } else {
      applicationContext.getBean(actorClazz, args: _*)
    }
  }

  override def actorClass: Class[_ <: Actor] = actorClazz
}

