package com.xebialabs.xlrelease.support.pekko.spring

import org.apache.pekko.actor.{Actor, Props}
import org.springframework.context.ApplicationContext


// This class will be exposed as a Spring bean, and it has to be properly initialized by Spring before it's first use.
// Since ActorSystem is created (and re-created) AFTER Spring has already registered this bean it is safe to use from WITHIN Pekko actors.
private class SpringAwareActorFactory(applicationContext: ApplicationContext) extends ActorFactory {

  def props(actorBeanName: String): Props = {
    check()
    // untyped
    Props.create(classOf[SpringActorProducer], applicationContext, actorBeanName)
  }

  def props(actorClass: Class[_ <: Actor]): Props = {
    check()
    Props.create(classOf[TypedSpringActorProducer], applicationContext, actorClass)
  }

  private def check(): Unit = {
    if (applicationContext == null) {
      throw new IllegalStateException("Application context must be set before actor Props are created")
    }
  }

}

