package com.xebialabs.xlrelease.support.pekko.spring

import org.springframework.context.ApplicationContext

import java.util
import scala.reflect.ClassTag

trait ScalaSpringSupport {
  def getApplicationContext(): ApplicationContext

  def springBean[T: ClassTag]: T = getApplicationContext().getBean(implicitly[ClassTag[T]].runtimeClass).asInstanceOf[T]

  def springBean[T: ClassTag](name: String): T = getApplicationContext().getBean(name).asInstanceOf[T]

  def springBeans[T: ClassTag]: util.Map[String, T] = getApplicationContext().getBeansOfType(implicitly[ClassTag[T]].runtimeClass.asInstanceOf[Class[T]])
}
