package com.xebialabs.xlrelease.support.pekko.spring

import grizzled.slf4j.Logging
import org.apache.pekko.actor.{Actor, ActorRef, ActorRefFactory, Props}
import org.springframework.context.ApplicationContext

trait ActorFactory extends Logging {
  def props(actorBeanName: String): Props

  def props(actorClass: Class[_ <: Actor]): Props

  def childActorOf(actorClass: Class[_ <: Actor], name: String = null, dispatcher: String = null)
                  (implicit actorFactory: ActorRefFactory): ActorRef = {
    if (actorFactory == null) {
      throw new IllegalStateException("Actor system has not created extension yet")
    }
    val actorProps = if (dispatcher == null) {
      props(actorClass)
    } else {
      props(actorClass).withDispatcher(dispatcher)
    }
    try {
      if (null == name) {
        actorFactory.actorOf(actorProps)
      } else {
        actorFactory.actorOf(actorProps, name)
      }
    } catch {
      case e: Exception =>
        logger.error(s"Failed to create actor of class ${actorClass.getName} with name $name", e)
        throw e
    }
  }
}

object ActorFactory {
  def apply(applicationContext: ApplicationContext): ActorFactory = {
    new SpringAwareActorFactory(applicationContext)
  }
}
