package com.xebialabs.xlrelease.planner

import org.joda.time.{DateTime, Duration}

object Plans {
  sealed trait Planned {
    def item: PlannerReleaseItem
    def start: DateTime
    def normal(end: DateTime): Computed = Plans.Normal(item, start, end)
    def circular: Computed = Plans.Circular(item, start)
    def container(end: DateTime, children: List[Computed]): Computed = Plans.Container(item, start, end, children)

    def getItem(): PlannerReleaseItem = item
  }

  sealed trait Computed extends Planned {
    def end: DateTime
    def duration: Duration = new Duration(start, end)
  }

  case class Base(item: PlannerReleaseItem, start: DateTime) extends Planned
  case class Circular(item: PlannerReleaseItem, start: DateTime) extends Computed {
    def end = start
    override val duration = Duration.ZERO
  }

  case class Normal(item: PlannerReleaseItem, start: DateTime, end: DateTime) extends Computed
  case class Container(item: PlannerReleaseItem, start: DateTime, end: DateTime, children: List[Computed]) extends Computed
}
