package com.xebialabs.xlrelease.planner

import org.joda.time.DateTime

case class PlannerDependency(id: String, done: Boolean, archived: Boolean, target: Option[PlannerReleaseItem]) {
  def isDependencyUnresolved: Boolean = !done && !archived && target.isDefined

  def ownEndDate: Option[DateTime] = target.flatMap(target => target.endDate.orElse(target.dueDate))
}

