package com.xebialabs.xlrelease.runner.domain

import com.fasterxml.jackson.annotation.JsonSubTypes.Type
import com.fasterxml.jackson.annotation.{JsonSubTypes, JsonTypeInfo}
import com.xebialabs.xlrelease.support.akka.SerializableMsg

import scala.beans.BeanProperty

@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "_type", visible = true)
@JsonSubTypes(Array(
  new Type(value = classOf[ContainerJobData], name = "ContainerJobData"),
  new Type(value = classOf[SomeJobData], name = "SomeJobData"),
))
sealed trait JobData extends SerializableMsg {
  def getJobIdentifier(): Option[JobId]
}

case class ContainerJobData(@BeanProperty jobId: JobId,
                            @BeanProperty executionId: String,
                            @BeanProperty taskId: String,
                            @BeanProperty taskImg: String,
                            @BeanProperty abortTimeout: Int,
                            @BeanProperty maxRetryAttempts: Int,
                            @BeanProperty retryDelay: Int,
                            @BeanProperty inputContext: ContextData,
                            @BeanProperty registryUrl: String) extends JobData {
  override def toString: String = {
    s"ContainerJobData(jobId = $jobId, executionId = $executionId, taskId = $taskId, taskImg = $taskImg, abortTimeout = $abortTimeout, maxRetryAttempts = $maxRetryAttempts, retryDelay = $retryDelay)"
  }

  override def getJobIdentifier(): Option[JobId] = Option(jobId)
}

case class SomeJobData(@BeanProperty jobId: JobId) extends JobData {
  override def getJobIdentifier(): Option[JobId] = Option(jobId)
}
