package com.xebialabs.xlrelease.runner.repository

import com.xebialabs.xlrelease.runner.domain.RunnerId

trait RunnerTokenRepository {

  def exists(runnerId: RunnerId): Boolean

  def findByToken(tokenHash: String): Option[RunnerId]

  def create(runnerId: RunnerId, tokenHash: String): Unit

  def update(runnerId: RunnerId, tokenHash: String): Unit

  def delete(runnerId: RunnerId): Unit

}
