package com.xebialabs.xlrelease.runner.api.internal


import com.xebialabs.xlrelease.runner.api.internal.RunnerRegistrationResource.{RegisterRequest, RegisterResponse}
import com.xebialabs.xlrelease.runner.domain.ContextData

import javax.ws.rs.core.MediaType
import javax.ws.rs.{Consumes, POST, Path, Produces}

@Path("/runners-registration")
@Consumes(Array(MediaType.APPLICATION_JSON))
@Produces(Array(MediaType.APPLICATION_JSON))
trait RunnerRegistrationResource {
  @POST
  @Path("/register")
  def register(req: RegisterRequest): RegisterResponse
}

object RunnerRegistrationResource {
  case class RegisterRequest(uuid: String, name: String, version: String, capabilities: Set[String], publicKey: String)

  case class RegisterResponse(runnerId: String, isEnabled: Boolean, capacity: Int, encryptJobData: Boolean, runnerToken: ContextData)
}
