package com.xebialabs.xlrelease.runner.domain

import com.fasterxml.jackson.annotation.JsonSubTypes.Type
import com.fasterxml.jackson.annotation.{JsonSubTypes, JsonTypeInfo}
import com.xebialabs.xlrelease.support.akka.SerializableMsg


@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "_type", visible = true)
@JsonSubTypes(Array(
  new Type(value = classOf[TaskJobSuccess], name = "TaskJobSuccess"),
  new Type(value = classOf[TaskJobFailure], name = "TaskJobFailure"),
))
sealed trait JobResult extends SerializableMsg {
  def jobId: JobId

  def runnerId: RunnerId
}

sealed trait TaskJobResult extends JobResult {
  def taskId: String

  def output: ContextData
}

case class TaskJobSuccess(taskId: String, jobId: JobId, runnerId: RunnerId, containerStatusCode: Int, output: ContextData) extends TaskJobResult

case class TaskJobFailure(taskId: String, jobId: JobId, runnerId: RunnerId, output: ContextData, errorMessage: String) extends TaskJobResult
