package com.xebialabs.xlrelease.runner.domain

import com.fasterxml.jackson.annotation.JsonSubTypes.Type
import com.fasterxml.jackson.annotation.{JsonSubTypes, JsonTypeInfo}
import com.xebialabs.xlrelease.support.serialization.SerializableMsg

@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "_type", visible = true)
@JsonSubTypes(Array(
  new Type(value = classOf[PlainContextData], name = "PlainContextData"),
  new Type(value = classOf[EncryptedContextData], name = "EncryptedContextData"),
))
sealed trait ContextData extends SerializableMsg {
  def data: String
}

case class PlainContextData(data: String) extends ContextData

case class EncryptedContextData(data: String, sessionKey: String) extends ContextData
