package com.xebialabs.xlrelease.runner.domain

import com.fasterxml.jackson.annotation.JsonSubTypes.Type
import com.fasterxml.jackson.annotation.{JsonSubTypes, JsonTypeInfo}
import com.xebialabs.xlrelease.support.serialization.SerializableMsg


@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "_type", visible = true)
@JsonSubTypes(Array(
  new Type(value = classOf[ScriptJobSuccess], name = "ScriptJobSuccess"),
  new Type(value = classOf[ScriptJobFailure], name = "ScriptJobFailure"),
  new Type(value = classOf[TaskJobSuccess], name = "TaskJobSuccess"),
  new Type(value = classOf[TaskJobFailure], name = "TaskJobFailure"),
))
sealed trait JobResult extends SerializableMsg {
  def getJobIdentifier: String
  def runnerId: RunnerId
}

sealed trait TaskJobResult extends JobResult {
  def jobId: JobId

  def taskId: String

  def output: ContextData

  override def getJobIdentifier: String = Option(jobId).map(_.toString).orNull
}

case class TaskJobSuccess(taskId: String, jobId: JobId, runnerId: RunnerId, containerStatusCode: Int, output: ContextData) extends TaskJobResult

case class TaskJobFailure(taskId: String, jobId: JobId, runnerId: RunnerId, output: ContextData, errorMessage: String) extends TaskJobResult

sealed trait ScriptJobResult extends JobResult {
  def executionId: String
  def output: ContextData
  override def getJobIdentifier: String = executionId
}

case class ScriptJobSuccess(executionId: String, runnerId: RunnerId, containerStatusCode: Int, output: ContextData) extends ScriptJobResult

case class ScriptJobFailure(executionId: String, runnerId: RunnerId, output: ContextData, errorMessage: String) extends ScriptJobResult
