package com.xebialabs.xlrelease.runner.service

import com.xebialabs.xlrelease.runner.domain.{JobData, JobDirective, JobId, JobResult, RunnerId}
import com.xebialabs.xlrelease.storage.domain.LogEntry

trait RunnerJobService {
  def reserveJob(runnerId: RunnerId): Option[JobData]

  def confirmJob(runnerId: RunnerId, jobId: JobId): Boolean

  def finishJob(jobResult: JobResult): Unit

  def log(logEntry: LogEntry): Unit

  def executeDirectives(directives: Seq[JobDirective]): Unit
}
