package com.xebialabs.xlrelease.runner.domain

import com.fasterxml.jackson.annotation.JsonSubTypes.Type
import com.fasterxml.jackson.annotation.{JsonSubTypes, JsonTypeInfo}
import com.xebialabs.xlrelease.support.serialization.SerializableMsg

// runner commands
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "_type", visible = true)
@JsonSubTypes(Array(
  new Type(value = classOf[Abort], name = "Abort"),
  new Type(value = classOf[ConfigureRunner], name = "ConfigureRunner"),
  new Type(value = classOf[EnableRunner], name = "EnableRunner"),
  new Type(value = classOf[DisableRunner], name = "DisableRunner"),
  new Type(value = classOf[DeleteRunner], name = "DeleteRunner"),
  new Type(value = classOf[Ping], name = "Ping"),
  new Type(value = classOf[ExecuteScript], name = "ExecuteScript"),
))
sealed trait RunnerControlCommand extends SerializableMsg {
  def commandConfirmationRequired: Boolean
}

case class Abort(jobId: JobId) extends RunnerControlCommand {
  override def commandConfirmationRequired: Boolean = true
}

case class EnableRunner(runnerCapacity: Integer, evictionTime: Integer, encryptJobData: Boolean) extends RunnerControlCommand {
  override def commandConfirmationRequired: Boolean = true
}

case class DisableRunner() extends RunnerControlCommand {
  override def commandConfirmationRequired: Boolean = true
}

case class DeleteRunner() extends RunnerControlCommand {
  override def commandConfirmationRequired: Boolean = false
}

case class Ping() extends RunnerControlCommand {
  override def commandConfirmationRequired: Boolean = false
}

case class ExecuteScript(jobData: ContainerScriptJobData) extends RunnerControlCommand {
  override def commandConfirmationRequired: Boolean = true
}

case class ConfigureRunner(imageUrlMapping: Map[String, String], registryPullSecrets: Map[String, String], baseUrls: Set[String]) extends RunnerControlCommand {
  override def commandConfirmationRequired: Boolean = true
}
