/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.xebialabs.xlrelease.script.Jsr223EngineFactory;
import com.xebialabs.xlrelease.script.ScriptExecutor;
import com.xebialabs.xlrelease.script.ScriptPermissionsProvider;
import com.xebialabs.xlrelease.script.XlrScript;
import com.xebialabs.xlrelease.script.XlrScriptContext;
import com.xebialabs.xlrelease.script.jython.SandboxAwarePackageManager;
import com.xebialabs.xlrelease.script.security.RuntimePermission;
import com.xebialabs.xlrelease.script.security.ScriptCodeSource;
import com.xebialabs.xlrelease.script.security.ScriptPermissions;
import java.io.File;
import java.io.FilePermission;
import java.lang.reflect.ReflectPermission;
import java.net.NetPermission;
import java.nio.file.Paths;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.security.UnresolvedPermission;
import java.util.Enumeration;
import java.util.PropertyPermission;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.security.auth.AuthPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class Jsr223ScriptExecutor
implements ScriptExecutor {
    protected final Logger logger = LoggerFactory.getLogger((String)"com.xebialabs.xlrelease.script.Jsr223ScriptExecutor");
    private final boolean sandboxEnabled;
    private final String workDir;
    protected ScriptEngine unrestrictedEngine;
    protected ScriptEngine restrictedEngine;
    protected ScriptPermissionsProvider scriptPermissionsProvider;

    protected Jsr223ScriptExecutor(Jsr223EngineFactory engineFactory, ScriptPermissionsProvider scriptPermissionsProvider, boolean sandboxEnabled, String workDir) {
        this.unrestrictedEngine = engineFactory.getScriptEngine(false);
        this.restrictedEngine = engineFactory.getScriptEngine(true);
        this.scriptPermissionsProvider = scriptPermissionsProvider;
        this.sandboxEnabled = sandboxEnabled;
        this.workDir = workDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object evalScript(XlrScriptContext xlrScriptContext) throws Exception {
        Object result = null;
        try {
            boolean checkPolicyPermissions = xlrScriptContext.shouldCheckPolicyPermissions();
            AccessControlContext acc = checkPolicyPermissions ? this.getAccessControlContext() : null;
            ScriptEngine engine = this.configureSandboxAndGetEngine(checkPolicyPermissions);
            for (XlrScript script : xlrScriptContext.getScripts()) {
                try {
                    result = this.evaluate(engine, xlrScriptContext, script, script.checkPermissions() ? acc : null);
                }
                catch (ScriptException ex) {
                    this.logger.warn("Exception while executing script {} '{}'", new Object[]{xlrScriptContext.getExecutionId(), script.name(), ex});
                    throw ex;
                }
                catch (Exception ex) {
                    this.logger.warn("Failed script {} '{}'", new Object[]{xlrScriptContext.getExecutionId(), script.name(), ex});
                    throw new ScriptException(ex);
                    return result;
                }
            }
        }
        finally {
            SandboxAwarePackageManager.setSandboxed(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object evaluate(ScriptEngine engine, XlrScriptContext xlrScriptContext, XlrScript script, AccessControlContext acc) throws Exception {
        Object originalBindingsToWrap = xlrScriptContext.getAttribute("_contextBindingsToWrap", 100);
        Object originalBindingsToUnWrap = xlrScriptContext.getAttribute("_contextBindingsToUnWrap", 100);
        try {
            if (!script.wrap()) {
                xlrScriptContext.removeAttribute("_contextBindingsToWrap", 100);
                xlrScriptContext.removeAttribute("_contextBindingsToUnWrap", 100);
            }
            this.logger.trace("Evaluating script {}: {}", (Object)xlrScriptContext.getExecutionId(), (Object)script.name());
            String scriptContent = script.scriptSource().scriptContent();
            Object result = this.evalScriptPrivileged(engine, scriptContent, xlrScriptContext, acc);
            this.logger.trace("Evaluated script {}", (Object)xlrScriptContext.getExecutionId());
            Object object = result;
            return object;
        }
        finally {
            xlrScriptContext.setAttribute("_contextBindingsToWrap", originalBindingsToWrap, 100);
            xlrScriptContext.setAttribute("_contextBindingsToUnWrap", originalBindingsToUnWrap, 100);
        }
    }

    protected abstract Object evalScriptPrivileged(ScriptEngine var1, String var2, ScriptContext var3, AccessControlContext var4) throws Exception;

    protected Object doPrivileged(ScriptEngine engine, String script, ScriptContext scriptContext, AccessControlContext accessControlContext) throws Exception {
        try {
            this.logger.trace("Content of the script is: {}{}", (Object)System.getProperty("line.separator"), (Object)script);
            PrivilegedExceptionAction<Object> action = () -> engine.eval(this.intern(script), scriptContext);
            return AccessController.doPrivileged(action, accessControlContext);
        }
        catch (PrivilegedActionException exceptionWrapper) {
            this.logger.debug("PrivilegedActionException: ", (Throwable)exceptionWrapper);
            throw exceptionWrapper.getException();
        }
    }

    protected Boolean isScriptSandboxEnabled() {
        return this.sandboxEnabled;
    }

    protected String getWorkDir() {
        return this.workDir;
    }

    protected AccessControlContext getAccessControlContext() {
        if (this.sandboxEnabled) {
            ProtectionDomain domain = new ProtectionDomain(new ScriptCodeSource(), this.extendsMinimalPermissionsWith(this.scriptPermissionsProvider.getScriptPermissions()));
            return new AccessControlContext(new ProtectionDomain[]{domain});
        }
        return null;
    }

    private Permissions extendsMinimalPermissionsWith(PermissionCollection permissions) {
        Permissions minimalPermissions = this.createMinimalPermissions();
        this.addSandboxPermissions(minimalPermissions);
        this.addInternalAccessPermissions(minimalPermissions);
        this.addJythonLibrariesReadPermissions(minimalPermissions);
        this.addGroovyLibrariesReadPermissions(minimalPermissions);
        this.addJsonModule(minimalPermissions);
        this.addJsonSmartLibraryPermissions(minimalPermissions);
        this.addOvertherePermissions(minimalPermissions);
        this.addWorkDirPermissions(minimalPermissions);
        this.addJavaHomeSecurityLibPermissions(minimalPermissions);
        this.addCiUtilsPermissions(minimalPermissions);
        if (permissions != null) {
            Enumeration<Permission> permissionEnumeration = permissions.elements();
            while (permissionEnumeration.hasMoreElements()) {
                Permission permission = this.resolvePermissionIfNecessary(permissionEnumeration.nextElement());
                minimalPermissions.add(permission);
            }
        }
        return minimalPermissions;
    }

    protected Permissions createMinimalPermissions() {
        Permissions minimalPermissions = new Permissions();
        minimalPermissions.add(new PropertyPermission("user.dir", "read"));
        minimalPermissions.add(new PropertyPermission("line.separator", "read"));
        minimalPermissions.add(new PropertyPermission("file.encoding", "read"));
        minimalPermissions.add(new java.lang.RuntimePermission("createClassLoader"));
        minimalPermissions.add(new java.lang.RuntimePermission("getProtectionDomain"));
        minimalPermissions.add(new java.lang.RuntimePermission("getClassLoader"));
        minimalPermissions.add(new SecurityPermission("insertProvider.BC"));
        minimalPermissions.add(new java.lang.RuntimePermission("accessClassInPackage.sun.util.calendar"));
        return minimalPermissions;
    }

    private void addAPIPermissions(Permissions minimalPermissions) {
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.api"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.api.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.builder"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.builder.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.deployit.security.Permissions"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.domain"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.domain.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.dsl"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.dsl.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.deployit.plugin.api"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.deployit.plugin.api.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.risk.api"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.risk.api.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.risk.domain"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.risk.domain.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.risk.configuration"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.risk.configuration.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.repository.PhaseVersion"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.views.ImportResult"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.plugins.dashboard.domain"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.plugins.dashboard.domain.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("javax.ws.*"));
    }

    protected void addJavaPrimitivesPermissions(Permissions minimalPermissions) {
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.ArithmeticException"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.ArrayIndexOutOfBoundsException"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Boolean"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Byte"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Character"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.CharSequence"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Cloneable"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Comparable"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Double"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Enum"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Error"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Exception"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Float"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.FunctionalInterface"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.IllegalAccessException"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.IllegalArgumentException"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.IllegalStateException"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.IndexOutOfBoundsException"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Integer"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.InterruptedException"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Iterable"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Long"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Math"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.NullPointerException"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Number"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.NumberFormatException"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Object"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Runnable"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.RuntimeException"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Short"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.String"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.StringBuffer"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.StringBuilder"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.SecurityException"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.System"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Throwable"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Void"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.text"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.text.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.time"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.time.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.net"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.net.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.math"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.math.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.util"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.util.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.sql"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.sql.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.ref"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.ref.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.io"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.io.*"));
    }

    private void addSandboxPermissions(Permissions minimalPermissions) {
        this.addAPIPermissions(minimalPermissions);
        this.addJavaPrimitivesPermissions(minimalPermissions);
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("groovy.lang.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("org.codehaus.groovy.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("scala.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("org.slf4j.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("ch.qos.logback.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("default.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.plugin"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.plugin.webhook"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.plugin.webhook.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xhaus"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xhaus.jyson"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xhaus.jyson.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("org.springframework.data"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("org.springframework.data.domain.Sort"));
        minimalPermissions.add(new java.lang.RuntimePermission("defineClass"));
    }

    protected void addInternalAccessPermissions(Permissions minimalPermissions) {
        minimalPermissions.add(new AuthPermission("modifyPrincipals"));
        minimalPermissions.add(new AuthPermission("modifyPublicCredentials"));
        minimalPermissions.add(new java.lang.RuntimePermission("accessDeclaredMembers"));
        minimalPermissions.add(new java.lang.RuntimePermission("accessUserInformation"));
        minimalPermissions.add(new java.lang.RuntimePermission("accessClassInPackage.sun.security.util"));
        minimalPermissions.add(new java.lang.RuntimePermission("accessClassInPackage.sun.security.x509"));
        minimalPermissions.add(new ReflectPermission("suppressAccessChecks"));
        minimalPermissions.add(new java.lang.RuntimePermission("accessClassInPackage.sun.reflect"));
    }

    private void addOvertherePermissions(Permissions minimalPermissions) {
        minimalPermissions.add(new NetPermission("specifyStreamHandler"));
        minimalPermissions.add(new PropertyPermission("jcifs.properties", "read"));
    }

    protected void addJythonLibrariesReadPermissions(Permissions minimalPermissions) {
        this.addReadPermissionOnJar("jython-standalone", minimalPermissions);
        minimalPermissions.add(new PropertyPermission("os.name", "read"));
        minimalPermissions.add(new PropertyPermission("os.arch", "read"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("org.python.modules._hashlib"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("org.python.modules.time.Time"));
    }

    protected void addGroovyLibrariesReadPermissions(Permissions minimalPermissions) {
        this.addReadPermissionOnJar("groovy", minimalPermissions);
    }

    protected void addJsonModule(Permissions permissions) {
        permissions.add(ScriptPermissions.grantedClassAccess("json"));
        permissions.add(ScriptPermissions.grantedClassAccess("json.scanner"));
        permissions.add(ScriptPermissions.grantedClassAccess("_json.make_scanner"));
        permissions.add(ScriptPermissions.grantedClassAccess("_json.make_encoder"));
        permissions.add(ScriptPermissions.grantedClassAccess("_json.scanstring"));
        permissions.add(ScriptPermissions.grantedClassAccess("_json.encode_basestring_ascii"));
        permissions.add(ScriptPermissions.grantedClassAccess("encodings"));
        permissions.add(ScriptPermissions.grantedClassAccess("encodings.hex"));
        permissions.add(ScriptPermissions.grantedClassAccess("encodings.hex_codec.*"));
        permissions.add(ScriptPermissions.grantedClassAccess("org.python.modules.binascii"));
        permissions.add(ScriptPermissions.grantedClassAccess("org.python.modules._json._json"));
        permissions.add(ScriptPermissions.grantedClassAccess("org.python.modules.struct"));
        permissions.add(ScriptPermissions.grantedClassAccess("org.python.modules.struct.*"));
        permissions.add(new PropertyPermission("sun.arch.data.model", "read"));
        permissions.add(new PropertyPermission("guava.concurrent.generate_cancellation_cause", "read"));
    }

    protected void addCiUtilsPermissions(Permissions permissions) {
        permissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.deployit.plugin.api.reflect"));
        permissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.deployit.plugin.api.reflect.Type"));
    }

    protected void addJsonSmartLibraryPermissions(Permissions minimalPermissions) {
        this.addReadPermissionOnJar("json-smart", minimalPermissions);
        minimalPermissions.add(new PropertyPermission("JSON_SMART_SIMPLE", "read"));
    }

    private void addWorkDirPermissions(Permissions minimalPermissions) {
        String userDir = System.getProperty("user.dir");
        String workdirPath = Paths.get(userDir, this.getWorkDir()).toString();
        minimalPermissions.add(new FilePermission(workdirPath + File.separator + "-", "delete"));
    }

    protected void addJavaHomeSecurityLibPermissions(Permissions minimalPermissions) {
        String javaHome = System.getProperty("java.home");
        String javaHomePath = Paths.get(javaHome, new String[0]).toString();
        String libSecurityPath = Stream.of(javaHomePath, "lib", "security", "-").collect(Collectors.joining(File.separator));
        minimalPermissions.add(new FilePermission(libSecurityPath, "read"));
    }

    protected void addReadPermissionOnJar(String jarName, Permissions minimalPermissions) {
        String classPath = System.getProperty("java.class.path");
        String classPathSeparator = System.getProperty("path.separator");
        Pattern pattern = Pattern.compile("([^" + classPathSeparator + "]*" + jarName + "[^" + classPathSeparator + "]*)");
        Matcher matcher = pattern.matcher(classPath);
        while (matcher.find()) {
            String group = matcher.group();
            minimalPermissions.add(new FilePermission(group, "read"));
            this.logger.debug("Minimal permission added on: {}", (Object)group);
        }
    }

    protected Permission resolvePermissionIfNecessary(Permission permission) {
        if (permission instanceof UnresolvedPermission) {
            UnresolvedPermission unresolvedPermission = (UnresolvedPermission)permission;
            if (RuntimePermission.class.getName().equals(unresolvedPermission.getUnresolvedType())) {
                return new RuntimePermission(unresolvedPermission.getUnresolvedName(), unresolvedPermission.getUnresolvedActions());
            }
        }
        return permission;
    }

    protected ScriptEngine configureSandboxAndGetEngine(boolean checkPolicyPermissions) {
        SandboxAwarePackageManager.setSandboxed(this.isRestricted(checkPolicyPermissions));
        if (this.isRestricted(checkPolicyPermissions)) {
            return this.restrictedEngine;
        }
        return this.unrestrictedEngine;
    }

    protected boolean isRestricted(boolean checkPolicyPermissions) {
        return checkPolicyPermissions && this.isScriptSandboxEnabled() != false && System.getSecurityManager() != null;
    }

    private String intern(String script) {
        if (StringUtils.hasLength((String)script)) {
            return script.intern();
        }
        return "";
    }
}

