package com.xebialabs.xlrelease.script.jython

import com.github.benmanes.caffeine.cache.Cache
import com.xebialabs.xlrelease.support.cache.caffeine.CaffeineCacheBuilder
import com.xebialabs.xlrelease.support.cache.config.CacheSettings
import org.python.jsr223.PyScriptEngine

import java.io.Reader
import javax.script._

class XlrJythonEngine(pyScriptEngine: PyScriptEngine, val engineName: String, val cacheSettings: CacheSettings) extends ScriptEngine with CaffeineCacheBuilder {
  protected val classCache: Cache[String, CompiledScript] = {
    buildCache("xlr-jython-engine-cache", engineName, cacheSettings)
  }

  override def eval(script: String, context: ScriptContext): AnyRef = {
    // in theory we could use scala.util.hashing.MurmurHash3 but we also have to compute compiled script from a key
    // so let's do what groovy does
    val compiledScript = classCache.get(script, cacheKey => pyScriptEngine.compile(cacheKey))
    compiledScript.eval(context)
  }

  override def eval(reader: Reader, context: ScriptContext): AnyRef = ???

  override def eval(script: String): AnyRef = ???

  override def eval(reader: Reader): AnyRef = ???

  override def eval(script: String, n: Bindings): AnyRef = ???

  override def eval(reader: Reader, n: Bindings): AnyRef = ???

  override def put(key: String, value: Any): Unit = ???

  override def get(key: String): AnyRef = ???

  override def getBindings(scope: Int): Bindings = ???

  override def setBindings(bindings: Bindings, scope: Int): Unit = ???

  override def createBindings(): Bindings = ???

  override def getContext: ScriptContext = ???

  override def setContext(context: ScriptContext): Unit = ???

  override def getFactory: ScriptEngineFactory = ???

}
