/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.xebialabs.xlrelease.script.ScriptTimeoutContext;
import com.xebialabs.xlrelease.script.XlrScript;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.script.ScriptContext;
import javax.script.SimpleScriptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlrScriptContext
extends SimpleScriptContext
implements AutoCloseable {
    private static final Logger scriptLogger = LoggerFactory.getLogger((String)"xlrelease.script");
    public static final String CONTEXT_BINDINGS_TO_UNWRAP = "_contextBindingsToUnWrap";
    public static final String CONTEXT_BINDINGS_TO_WRAP = "_contextBindingsToWrap";
    public static final String ATTRIBUTE_RELEASE_VARIABLES = "_releaseVariables";
    public static final String ATTRIBUTE_GLOBAL_VARIABLES = "_globalVariables";
    public static final String ATTRIBUTE_FOLDER_VARIABLES = "_folderVariables";
    public static final String ATTR_EXECUTION_OUTPUT_WRITER = "_executionOutputWriter";
    public static final String ATTR_VERSION = "_version";
    public static final String ATTR_RELEASE = "release";
    public static final String ATTR_PHASE = "phase";
    public static final String ATTR_TASK = "task";
    public static final String ATTR_VALUE_PROVIDER = "_valueProvider";
    public static final String ATTR_VALUE_PROVIDER_RESULT = "result";
    public static final String CONFIGURATION_ID_PROPERTY_NAME = "id";
    private final String executionId;
    private String scriptPathForLog;
    private final List<XlrScript> scripts = new ArrayList<XlrScript>();
    private final ScriptTimeoutContext scriptTimeoutContext;

    public XlrScriptContext() {
        this(UUID.randomUUID().toString());
    }

    public XlrScriptContext(String executionId) {
        this.executionId = executionId;
        this.scriptTimeoutContext = ScriptTimeoutContext.noTimeoutContext();
    }

    public XlrScriptContext(String executionId, ScriptTimeoutContext scriptTimeoutContext) {
        this.executionId = executionId;
        this.scriptTimeoutContext = scriptTimeoutContext;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public void addScriptLogger() {
        this.setAttribute("logger", scriptLogger, 100);
    }

    public void setScriptPathForLog(String scriptPathForLog) {
        this.scriptPathForLog = scriptPathForLog;
    }

    public String getScriptPathForLog() {
        return this.scriptPathForLog;
    }

    public Collection<Object> getValueProviderResult() {
        return (Collection)this.getAttribute(ATTR_VALUE_PROVIDER_RESULT, 100);
    }

    @Override
    public void close() throws Exception {
    }

    public List<XlrScript> getScripts() {
        return this.scripts;
    }

    public void addScript(XlrScript script) {
        this.scripts.add(script);
    }

    public boolean shouldCheckPolicyPermissions() {
        return this.scripts.stream().anyMatch(XlrScript::checkPermissions);
    }

    public void merge(ScriptContext other, int scope) {
        this.getBindings(scope).putAll(other.getBindings(scope));
    }

    void beforeExecute() {
        this.scriptTimeoutContext.registerTimeout();
    }

    void afterExecute() {
        this.scriptTimeoutContext.cleanupTimeout();
    }

    boolean isTimedOut() {
        return this.scriptTimeoutContext.isTimedOut();
    }

    String getTimeoutMessage() {
        return this.scriptTimeoutContext.getTimeoutMessage();
    }
}

