package com.xebialabs.xlrelease.spring.configuration

import com.xebialabs.xlrelease.script.ScriptPermissionsProvider
import com.xebialabs.xlrelease.script.jython._
import org.springframework.context.annotation.{Bean, Configuration}


@Configuration
class JythonScriptExecutorConfiguration(scriptingConfiguration: ScriptingConfiguration) {

  @Bean
  def scriptPermissionsProvider(): ScriptPermissionsProvider = new ScriptPermissionsProvider(scriptingConfiguration.policyAutoRefresh)

  @Bean
  def jythonScriptValidator(): JythonANTLRScriptValidator = {
    new JythonANTLRScriptValidator(scriptingConfiguration.sandboxConfiguration)
  }

  @Bean
  def jythonScriptExecutor(): JythonScriptExecutor =
    new JythonScriptExecutor(
      JythonEngineInstance(scriptingConfiguration.cacheSettings),
      scriptPermissionsProvider(),
      jythonScriptValidator(),
      scriptingConfiguration.sandboxEnabled,
      scriptingConfiguration.workDir
    )
}