package com.xebialabs.xlrelease.security.sql.db

import com.xebialabs.deployit.booter.local.utils.Strings.isEmpty
import com.xebialabs.xlrelease.domain.id.CiUid

import java.util.UUID

object Ids {
  val GLOBAL_SECURITY_ALIAS = "global"

  val GLOBAL_SCOPE_CI_ID: CiUid = -1L

  def generate(): String = UUID.randomUUID().toString

  def isGlobalId(id: Option[String]): Boolean = id match {
    case Some(ciId) if ciId != GLOBAL_SECURITY_ALIAS && !isEmpty(ciId) => false
    case _ => true
  }

  def toDbId(id: Option[String]): CiUid =
    id.collect {
      case ciId if ciId != GLOBAL_SECURITY_ALIAS && !isEmpty(ciId) => CiUid(ciId.toLong)
    }.getOrElse(GLOBAL_SCOPE_CI_ID)

  def fromDbId(id: CiUid): String = if (id == GLOBAL_SCOPE_CI_ID) GLOBAL_SECURITY_ALIAS else id.toString

}
