/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql.persistence;

import com.xebialabs.xlrelease.domain.utils.FolderId;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.Token$;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow$Root$;
import com.xebialabs.xlrelease.security.sql.db.SecuritySchema;
import java.io.Serializable;
import java.util.UUID;
import org.springframework.jdbc.core.RowMapper;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;

public final class FindDescendantsQueryBuilder$ {
    public static final FindDescendantsQueryBuilder$ MODULE$ = new FindDescendantsQueryBuilder$();
    private static final String selectDescendants = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(169).append("\n       | SELECT DISTINCT\n       |   d.").append(Schema.VIEW$.MODULE$.FOLDER_ID()).append(",\n       |   d.").append(Schema.VIEW$.MODULE$.FOLDER_PATH()).append(",\n       |   d.").append(Schema.VIEW$.MODULE$.DESCENDANT_UID()).append(",\n       |   d.").append(Schema.VIEW$.MODULE$.SECURITY_UID()).append(",\n       |   d.").append(Schema.VIEW$.MODULE$.TOKEN()).append(",\n       |   d.").append(Schema.VIEW$.MODULE$.NAME()).append(",\n       |   p.").append(Schema.PATHS$.MODULE$.ANCESTOR_UID()).append(",\n       |   d.").append(Schema.VIEW$.MODULE$.DEPTH()).append("\n       | FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" f\n       ").toString()));
    private static final String descendantsOf = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(69).append("\n       | JOIN ").append(Schema.VIEW$.MODULE$.TABLE()).append(" d\n       |    ON ( d.").append(Schema.VIEW$.MODULE$.ANCESTOR_UID()).append(" = f.").append(Schema.FOLDERS$.MODULE$.CI_UID()).append(" AND d.").append(Schema.PATHS$.MODULE$.DEPTH()).append(" <= :depth )\n       ").toString()));
    private static final String parentOf = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(137).append("\n       | JOIN ").append(Schema.PATHS$.MODULE$.TABLE()).append(" p\n       |    ON  ( p.").append(Schema.PATHS$.MODULE$.DESCENDANT_UID()).append(" = d.").append(Schema.VIEW$.MODULE$.DESCENDANT_UID()).append("\n       |          AND (     p.").append(Schema.PATHS$.MODULE$.DEPTH()).append(" = 1\n       |               OR ( p.").append(Schema.PATHS$.MODULE$.DEPTH()).append(" = 0 AND p.").append(Schema.PATHS$.MODULE$.ANCESTOR_UID()).append(" = ").append(FolderRow$Root$.MODULE$.uid()).append(" ) ) )\n       ").toString()));
    private static final String folderIdCondition = new StringBuilder(14).append("f.").append(Schema.FOLDERS$.MODULE$.FOLDER_ID()).append(" = :folderId").toString();
    private static final String folderUidCondition = new StringBuilder(11).append("f.").append(Schema.FOLDERS$.MODULE$.CI_UID()).append(" = :ciUid").toString();
    private static final String findAncestorByIdAndPermission = MODULE$.findAncestorWithPermission(MODULE$.folderIdCondition());
    private static final String findAncestorById = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(24).append("\n       | WHERE ").append(MODULE$.folderIdCondition()).append("\n       ").toString()));
    private static final String findAncestorByUidAndPermission = MODULE$.findAncestorWithPermission(MODULE$.folderUidCondition());
    private static final String findAncestorByUid = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(24).append("\n       | WHERE ").append(MODULE$.folderUidCondition()).append("\n       ").toString()));
    private static final String grouped = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(137).append("\n       | GROUP BY\n       |  d.").append(Schema.VIEW$.MODULE$.DESCENDANT_UID()).append(",\n       |  p.").append(Schema.PATHS$.MODULE$.ANCESTOR_UID()).append(",\n       |  d.").append(Schema.VIEW$.MODULE$.SECURITY_UID()).append(",\n       |  d.").append(Schema.VIEW$.MODULE$.TOKEN()).append(",\n       |  d.").append(Schema.VIEW$.MODULE$.FOLDER_PATH()).append(",\n       |  d.").append(Schema.VIEW$.MODULE$.FOLDER_ID()).append(",\n       |  d.").append(Schema.VIEW$.MODULE$.NAME()).append(",\n       |  d.").append(Schema.VIEW$.MODULE$.DEPTH()).append("\n       ").toString()));
    private static final String topDownOrder = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(100).append("\n       | ORDER BY\n       |   d.").append(Schema.VIEW$.MODULE$.DEPTH()).append(" ASC,\n       |   d.").append(Schema.VIEW$.MODULE$.NAME()).append(" ASC,\n       |   p.").append(Schema.PATHS$.MODULE$.ANCESTOR_UID()).append(" ASC,\n       |   d.").append(Schema.VIEW$.MODULE$.DESCENDANT_UID()).append(" ASC\n      ").toString()));
    private static final RowMapper<FolderRow> toFolderData = Utils$.MODULE$.rowMapper((Function1 & Serializable)rs -> {
        int uid = rs.getInt(Schema.VIEW$.MODULE$.DESCENDANT_UID());
        return BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)uid), (Object)FolderRow$Root$.MODULE$.uid()) ? FolderRow$Root$.MODULE$ : new FolderRow.FolderEntry(Predef$.MODULE$.int2Integer(uid), (UUID)Token$.MODULE$.fromString(rs.getString(Schema.VIEW$.MODULE$.TOKEN())).get(), Predef$.MODULE$.int2Integer(rs.getInt(Schema.VIEW$.MODULE$.SECURITY_UID())), new FolderId(rs.getString(Schema.VIEW$.MODULE$.FOLDER_PATH())).$div(rs.getString(Schema.VIEW$.MODULE$.FOLDER_ID())), rs.getString(Schema.VIEW$.MODULE$.NAME()), Predef$.MODULE$.int2Integer(rs.getInt(Schema.PATHS$.MODULE$.ANCESTOR_UID())), rs.getInt(Schema.VIEW$.MODULE$.DEPTH()));
    });

    private String selectDescendants() {
        return selectDescendants;
    }

    private String descendantsOf() {
        return descendantsOf;
    }

    private String parentOf() {
        return parentOf;
    }

    private String findAncestorWithPermission(String folderCondition) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(652).append("\n       | LEFT JOIN ").append(SecuritySchema.ROLES$.MODULE$.TABLE()).append(" roles ON d.").append(Schema.FOLDERS$.MODULE$.SECURITY_UID()).append(" = roles.").append(SecuritySchema.ROLES$.MODULE$.ciId()).append("\n       | LEFT JOIN ").append(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.TABLE()).append(" permissions\n       |  ON roles.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" = permissions.").append(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.roleId()).append("\n       | LEFT JOIN ").append(SecuritySchema.ROLE_ROLES$.MODULE$.TABLE()).append(" teamRoles\n       |  ON roles.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" = teamRoles.").append(SecuritySchema.ROLE_ROLES$.MODULE$.roleId()).append("\n       | LEFT JOIN ").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE()).append(" rolePrincipals\n       |  ON teamRoles.").append(SecuritySchema.ROLE_ROLES$.MODULE$.memberRoleId()).append(" = rolePrincipals.").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.roleId()).append("\n       | LEFT JOIN ").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE()).append(" teamPrincipals\n       |  ON roles.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" = teamPrincipals.").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.roleId()).append("\n       | WHERE\n       |  ").append(folderCondition).append("\n       |  AND (\n       |    f.").append(Schema.FOLDERS$.MODULE$.FOLDER_ID()).append(" = d.").append(Schema.FOLDERS$.MODULE$.FOLDER_ID()).append("\n       |    OR (\n       |      permissions.").append(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.permissionName()).append(" = :permissionName\n       |      AND (\n       |        LOWER(rolePrincipals.").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.principalName()).append(") IN (:principalNames)\n       |        OR\n       |        LOWER(teamPrincipals.").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.principalName()).append(") IN (:principalNames)\n       |      )\n       |    )\n       |  )\n     ").toString()));
    }

    private String folderIdCondition() {
        return folderIdCondition;
    }

    private String folderUidCondition() {
        return folderUidCondition;
    }

    private String findAncestorByIdAndPermission() {
        return findAncestorByIdAndPermission;
    }

    private String findAncestorById() {
        return findAncestorById;
    }

    private String findAncestorByUidAndPermission() {
        return findAncestorByUidAndPermission;
    }

    private String findAncestorByUid() {
        return findAncestorByUid;
    }

    private String grouped() {
        return grouped;
    }

    private String topDownOrder() {
        return topDownOrder;
    }

    public RowMapper<FolderRow> toFolderData() {
        return toFolderData;
    }

    public String findByUid() {
        return StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(this.selectDescendants()), this.descendantsOf())), this.parentOf())), this.findAncestorByUid())), this.grouped())), this.topDownOrder());
    }

    public String findByUidHavingPermission() {
        return StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(this.selectDescendants()), this.descendantsOf())), this.parentOf())), this.findAncestorByUidAndPermission())), this.grouped())), this.topDownOrder());
    }

    public String findById() {
        return StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(this.selectDescendants()), this.descendantsOf())), this.parentOf())), this.findAncestorById())), this.grouped())), this.topDownOrder());
    }

    public String findByIdHavingPermission() {
        return StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(this.selectDescendants()), this.descendantsOf())), this.parentOf())), this.findAncestorByIdAndPermission())), this.grouped())), this.topDownOrder());
    }

    private FindDescendantsQueryBuilder$() {
    }
}

