/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.CiWithUid;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.Page$;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.SqlReleaseRepositoryHelper;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence$CommentRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.security.SecuredCi;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.utils.Diff$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Marker;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\r\u0005g\u0001\u0002\u001a4\u0001yB\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I!\u001a\u0005\tW\u0002\u0011)\u0019!C\tY\"A\u0001\u000f\u0001B\u0001B\u0003%Q\u000e\u0003\u0005r\u0001\t\u0015\r\u0011\"\u0005s\u0011!1\bA!A!\u0002\u0013\u0019\b\u0002C<\u0001\u0005\u000b\u0007I\u0011\u0003=\t\u0011q\u0004!\u0011!Q\u0001\neD\u0001\" \u0001\u0003\u0006\u0004%\tB \u0005\n\u0003\u000b\u0001!\u0011!Q\u0001\n}D!\"a\u0002\u0001\u0005\u000b\u0007I\u0011CA\u0005\u0011)\t\t\u0002\u0001B\u0001B\u0003%\u00111\u0002\u0005\u000b\u0003'\u0001!Q1A\u0005\u0002\u0005U\u0001BCA\u0012\u0001\t\u0005\t\u0015!\u0003\u0002\u0018!Q\u0011Q\u0005\u0001\u0003\u0006\u0004%\t!a\n\t\u0015\u0005=\u0002A!A!\u0002\u0013\tI\u0003\u0003\u0006\u00022\u0001\u0011\t\u0011)A\u0005\u0003gA!\"!\u000f\u0001\u0005\u000b\u0007I1AA\u001e\u0011)\tY\u0007\u0001B\u0001B\u0003%\u0011Q\b\u0005\b\u0003[\u0002A\u0011AA8\u0011\u001d\tI\t\u0001C!\u0003\u0017Cq!a3\u0001\t\u0003\ni\rC\u0004\u0002f\u0002!\t%a:\t\u000f\u0005\u0015\b\u0001\"\u0011\u0002n\"9!\u0011\u0002\u0001\u0005B\t-\u0001b\u0002B#\u0001\u0011\u0005#q\t\u0005\b\u0005\u001f\u0002A\u0011\u0001B)\u0011\u001d\u0011)\b\u0001C!\u0005oBqA!#\u0001\t\u0003\u0011Y\tC\u0004\u0003\u001a\u0002!\tEa'\t\u000f\t=\u0006\u0001\"\u0011\u00032\"9!q\u0017\u0001\u0005\n\te\u0006b\u0002Ba\u0001\u0011\u0005#1\u0019\u0005\b\u0005\u0017\u0004A\u0011\tBg\u0011\u001d\u0011I\u000e\u0001C!\u00057DqA!@\u0001\t\u0003\u0012y\u0010C\u0004\u0004\u0006\u0001!\tea\u0002\t\u000f\rE\u0001\u0001\"\u0011\u0004\u0014!91Q\u0004\u0001\u0005B\r}\u0001bBB\u0017\u0001\u0011\u00053q\u0006\u0005\b\u0007o\u0001A\u0011IB\u001d\u0011\u001d\u0019\t\u0005\u0001C!\u0007\u0007Bqa!\u0011\u0001\t\u0003\u001aI\u0005C\u0004\u0004V\u0001!\tea\u0016\t\u000f\r}\u0003\u0001\"\u0011\u0004b!91\u0011\u000f\u0001\u0005\n\rM\u0004bBBD\u0001\u0011%1\u0011\u0012\u0005\b\u0007\u001f\u0003A\u0011IBI\u0011\u001d\u00199\u000b\u0001C!\u0007SCqaa,\u0001\t\u0003\u001a\tL\u0001\u000bTc2\u0014V\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\u0006\u0003iU\n1a]9m\u0015\t1t'\u0001\u0006sKB|7/\u001b;pefT!\u0001O\u001d\u0002\u0013ad'/\u001a7fCN,'B\u0001\u001e<\u0003%AXMY5bY\u0006\u00147OC\u0001=\u0003\r\u0019w.\\\u0002\u0001'!\u0001q(R%T7z\u000b\u0007C\u0001!D\u001b\u0005\t%\"\u0001\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\u000b%AB!osJ+g\r\u0005\u0002G\u000f6\tQ'\u0003\u0002Ik\t\t\"+\u001a7fCN,'+\u001a9pg&$xN]=\u0011\u0007)[U*D\u00014\u0013\ta5GA\u000bJ]R,'oY3qi\u0016$'+\u001a9pg&$xN]=\u0011\u00059\u000bV\"A(\u000b\u0005A;\u0014A\u00023p[\u0006Lg.\u0003\u0002S\u001f\n9!+\u001a7fCN,\u0007C\u0001+Z\u001b\u0005)&B\u0001,X\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005A\u0016\u0001C4sSjTH.\u001a3\n\u0005i+&a\u0002'pO\u001eLgn\u001a\t\u0003\u0015rK!!X\u001a\u0003-\u0011+7/\u001a:jC2L'0\u0019;j_:\u001cV\u000f\u001d9peR\u0004\"AS0\n\u0005\u0001\u001c$AH\"p]\u001aLw-\u001e:bi&|gNU3gKJ,gnY3t'V\u0004\bo\u001c:u!\tQ%-\u0003\u0002dg\tQ2+\u001d7SK2,\u0017m]3SKB|7/\u001b;pefDU\r\u001c9fe\u0006\u0011\"/\u001a7fCN,\u0007+\u001a:tSN$XM\\2f!\t1\u0017.D\u0001h\u0015\tA7'A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,\u0017B\u00016h\u0005I\u0011V\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0002\u001fQ\f7o\u001b)feNL7\u000f^3oG\u0016,\u0012!\u001c\t\u0003M:L!a\\4\u0003\u001fQ\u000b7o\u001b)feNL7\u000f^3oG\u0016\f\u0001\u0003^1tWB+'o]5ti\u0016t7-\u001a\u0011\u0002+\u0011,\u0007/\u001a8eK:\u001c\u0017\u0010U3sg&\u001cH/\u001a8dKV\t1\u000f\u0005\u0002gi&\u0011Qo\u001a\u0002\u0016\t\u0016\u0004XM\u001c3f]\u000eL\b+\u001a:tSN$XM\\2f\u0003Y!W\r]3oI\u0016t7-\u001f)feNL7\u000f^3oG\u0016\u0004\u0013AE2p[6,g\u000e\u001e)feNL7\u000f^3oG\u0016,\u0012!\u001f\t\u0003MjL!a_4\u0003%\r{W.\\3oiB+'o]5ti\u0016t7-Z\u0001\u0014G>lW.\u001a8u!\u0016\u00148/[:uK:\u001cW\rI\u0001\u000fi\u0016\fWNU3q_NLGo\u001c:z+\u0005y\bc\u0001$\u0002\u0002%\u0019\u00111A\u001b\u0003\u001dQ+\u0017-\u001c*fa>\u001c\u0018\u000e^8ss\u0006yA/Z1n%\u0016\u0004xn]5u_JL\b%A\u000esK2,\u0017m]3FqR,gn]5p]N\u0014V\r]8tSR|'/_\u000b\u0003\u0003\u0017\u00012ARA\u0007\u0013\r\ty!\u000e\u0002\u001c%\u0016dW-Y:f\u000bb$XM\\:j_:\u001c(+\u001a9pg&$xN]=\u00029I,G.Z1tK\u0016CH/\u001a8tS>t7OU3q_NLGo\u001c:zA\u0005A2m\u001c8gS\u001e,(/\u0019;j_:\u0004VM]:jgR,gnY3\u0016\u0005\u0005]\u0001\u0003BA\r\u0003?i!!a\u0007\u000b\u0007\u0005uq-A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0005\u0003C\tYBA\u0011D_:4\u0017nZ;sCRLwN\u001c*fM\u0016\u0014XM\\2f!\u0016\u00148/[:uK:\u001cW-A\rd_:4\u0017nZ;sCRLwN\u001c)feNL7\u000f^3oG\u0016\u0004\u0013!\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;feV\u0011\u0011\u0011\u0006\t\u0004\u0015\u0006-\u0012bAA\u0017g\t!2+\u001d7SKB|7/\u001b;pef\fE-\u00199uKJ\f!C]3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3sA\u0005Ib-Y2fiJ+\u0007o\\:ji>\u0014\u0018\u0010R5ta\u0006$8\r[3s!\r1\u0015QG\u0005\u0004\u0003o)$!\u0007$bG\u0016$(+\u001a9pg&$xN]=ESN\u0004\u0018\r^2iKJ\f!b]9m\t&\fG.Z2u+\t\ti\u0004\u0005\u0003\u0002@\u0005\u0015d\u0002BA!\u0003?rA!a\u0011\u0002\\9!\u0011QIA,\u001d\u0011\t9%!\u0016\u000f\t\u0005%\u00131\u000b\b\u0005\u0003\u0017\n\t&\u0004\u0002\u0002N)\u0019\u0011qJ\u001f\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0014B\u0001\u001e<\u0013\tA\u0014(C\u0002\u0002Z]\n!\u0001\u001a2\n\u0007Q\niFC\u0002\u0002Z]JA!!\u0019\u0002d\u0005Q1+\u001d7Ck&dG-\u001a:\u000b\u0007Q\ni&\u0003\u0003\u0002h\u0005%$a\u0002#jC2,7\r\u001e\u0006\u0005\u0003C\n\u0019'A\u0006tc2$\u0015.\u00197fGR\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u000b\u0002r\u0005]\u0014\u0011PA>\u0003{\ny(!!\u0002\u0004\u0006\u0015\u0015q\u0011\u000b\u0005\u0003g\n)\b\u0005\u0002K\u0001!9\u0011\u0011H\nA\u0004\u0005u\u0002\"\u00023\u0014\u0001\u0004)\u0007\"B6\u0014\u0001\u0004i\u0007\"B9\u0014\u0001\u0004\u0019\b\"B<\u0014\u0001\u0004I\b\"B?\u0014\u0001\u0004y\bbBA\u0004'\u0001\u0007\u00111\u0002\u0005\b\u0003'\u0019\u0002\u0019AA\f\u0011\u001d\t)c\u0005a\u0001\u0003SAq!!\r\u0014\u0001\u0004\t\u0019$\u0001\u0004fq&\u001cHo\u001d\u000b\u0005\u0003\u001b\u000b\u0019\nE\u0002A\u0003\u001fK1!!%B\u0005\u001d\u0011un\u001c7fC:Dq!!&\u0015\u0001\u0004\t9*\u0001\u0002jIB!\u0011\u0011TAQ\u001d\u0011\tY*!(\u0011\u0007\u0005-\u0013)C\u0002\u0002 \u0006\u000ba\u0001\u0015:fI\u00164\u0017\u0002BAR\u0003K\u0013aa\u0015;sS:<'bAAP\u0003\"\u001aA#!+\u0011\t\u0005-\u0016\u0011W\u0007\u0003\u0003[SA!a,\u0002d\u0005YAO]1og\u0006\u001cG/[8o\u0013\u0011\t\u0019,!,\u0003\u0015%\u001b(+Z1e\u001f:d\u0017\u0010K\u0002\u0015\u0003o\u0003B!!/\u0002H6\u0011\u00111\u0018\u0006\u0005\u0003{\u000by,\u0001\u0006b]:|G/\u0019;j_:TA!!1\u0002D\u00069Q.\u001a;sS\u000e\u001c(bAAcw\u0005A1m\u001c3bQ\u0006dW-\u0003\u0003\u0002J\u0006m&!\u0002+j[\u0016$\u0017AB2sK\u0006$X\rF\u0003N\u0003\u001f\f\u0019\u000e\u0003\u0004\u0002RV\u0001\r!T\u0001\be\u0016dW-Y:f\u0011\u001d\t).\u0006a\u0001\u0003/\fQC]3mK\u0006\u001cXm\u0011:fCRLwN\\*pkJ\u001cW\r\u0005\u0003\u0002Z\u0006}WBAAn\u0015\r\tinT\u0001\u0007KZ,g\u000e^:\n\t\u0005\u0005\u00181\u001c\u0002\u0016%\u0016dW-Y:f\u0007J,\u0017\r^5p]N{WO]2fQ\r)\u0012qW\u0001\tM&tGMQ=JIR\u0019Q*!;\t\u000f\u0005Ue\u00031\u0001\u0002\u0018\"\u001aa#a.\u0015\u000b5\u000by/!=\t\u000f\u0005Uu\u00031\u0001\u0002\u0018\"9\u00111_\fA\u0002\u0005U\u0018A\u0004:fg>dg/Z(qi&|gn\u001d\t\u0005\u0003o\u0014\u0019!\u0004\u0002\u0002z*\u0019a'a?\u000b\t\u0005u\u0018q`\u0001\u0005UN|gNC\u0002\u0003\u0002]\nQb]3sS\u0006d\u0017N_1uS>t\u0017\u0002\u0002B\u0003\u0003s\u0014aBU3t_24Xm\u00149uS>t7\u000fK\u0002\u0018\u0003o\u000bqBZ5oI&#7OQ=Ti\u0006$Xo\u001d\u000b\u0005\u0005\u001b\u0011y\u0002\u0005\u0004\u0003\u0010\te\u0011q\u0013\b\u0005\u0005#\u0011)B\u0004\u0003\u0002L\tM\u0011\"\u0001\"\n\u0007\t]\u0011)A\u0004qC\u000e\\\u0017mZ3\n\t\tm!Q\u0004\u0002\u0004'\u0016\f(b\u0001B\f\u0003\"9!\u0011\u0005\rA\u0002\t\r\u0012\u0001C:uCR,8/Z:\u0011\u000b\u0001\u0013)C!\u000b\n\u0007\t\u001d\u0012I\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002BAa\u000b\u000325\u0011!Q\u0006\u0006\u0004\u0005_y\u0015AB:uCR,8/\u0003\u0003\u00034\t5\"!\u0004*fY\u0016\f7/Z*uCR,8\u000fK\u0002\u0019\u0003SC3\u0001GA\\Q\rA\"1\b\t\u0005\u0005{\u0011\t%\u0004\u0002\u0003@)\u0019\u0011QX!\n\t\t\r#q\b\u0002\bm\u0006\u0014\u0018M]4t\u0003M1\u0017N\u001c3Cs\u000e\u000bG.\u001a8eCJ$vn[3o)\ri%\u0011\n\u0005\b\u0005\u0017J\u0002\u0019AAL\u00035\u0019\u0017\r\\3oI\u0006\u0014Hk\\6f]\"\u001a\u0011$a.\u00021\u0019Lg\u000eZ!sG\"Lg/\u00192mKJ+G.Z1tK&#7\u000f\u0006\u0004\u0003\u000e\tM#q\r\u0005\b\u0005+R\u0002\u0019\u0001B,\u0003\u0011!\u0017\r^3\u0011\t\te#1M\u0007\u0003\u00057RAA!\u0018\u0003`\u0005!Q\u000f^5m\u0015\t\u0011\t'\u0001\u0003kCZ\f\u0017\u0002\u0002B3\u00057\u0012A\u0001R1uK\"9!\u0011\u000e\u000eA\u0002\t-\u0014\u0001\u00039bO\u0016\u001c\u0016N_3\u0011\u0007\u0001\u0013i'C\u0002\u0003p\u0005\u00131!\u00138uQ\rQ\u0012\u0011\u0016\u0015\u00045\u0005]\u0016AD:fiB\u0013X-\u0011:dQ&4X\r\u001a\u000b\u0007\u0005s\u0012yHa!\u0011\u0007\u0001\u0013Y(C\u0002\u0003~\u0005\u0013A!\u00168ji\"9!\u0011Q\u000eA\u0002\u0005]\u0015!\u0003:fY\u0016\f7/Z%e\u0011\u001d\u0011)i\u0007a\u0001\u0003\u001b\u000b1\u0002\u001d:f\u0003J\u001c\u0007.\u001b<fI\"\u001a1$a.\u00023\u0019Lg\u000e\u001a)sK\u0006\u00138\r[5wC\ndWMU3mK\u0006\u001cXm\u001d\u000b\u0007\u0005\u001b\u0013yIa%\u0011\u000b\t=!\u0011D'\t\u000f\tEE\u00041\u0001\u0003l\u0005!\u0001/Y4f\u0011\u001d\u0011I\u0007\ba\u0001\u0005WB3\u0001HAUQ\ra\u0012qW\u0001\u0007g\u0016\f'o\u00195\u0015\t\tu%1\u0015\t\u0006\u00053\u0012y*T\u0005\u0005\u0005C\u0013YF\u0001\u0003MSN$\bb\u0002BS;\u0001\u0007!qU\u0001\rg\u0016\f'o\u00195QCJ\fWn\u001d\t\u0004\r\n%\u0016b\u0001BVk\t)\"+\u001a7fCN,7+Z1sG\"\u0014\u0015\u0010U1sC6\u001c\bfA\u000f\u00028\u00061A-\u001a7fi\u0016$BA!\u001f\u00034\"9\u0011Q\u0013\u0010A\u0002\u0005]\u0005f\u0001\u0010\u00028\u00069B-\u001a7fi\u0016\u0014V\r\\3bg\u0016\u0014VMZ3sK:\u001cWm\u001d\u000b\u0007\u0005s\u0012YL!0\t\u000f\u0005Uu\u00041\u0001\u0002\u0018\"9!qX\u0010A\u0002\t-\u0014A\u0003:fY\u0016\f7/Z+jI\u0006iA-\u001a7fi\u0016<\u0016\u000e\u001e5VS\u0012$bA!\u001f\u0003F\n\u001d\u0007bBAKA\u0001\u0007\u0011q\u0013\u0005\b\u0005\u007f\u0003\u0003\u0019\u0001B6Q\r\u0001\u0013qW\u0001\u0005[>4X\r\u0006\u0004\u0003z\t='1\u001b\u0005\b\u0005#\f\u0003\u0019AAL\u0003)y'/[4j]\u0006d\u0017\n\u001a\u0005\b\u0005+\f\u0003\u0019AAL\u0003\u0015qWm^%eQ\r\t\u0013qW\u0001\u0007O\u0016$X+\u001b3\u0015\t\tu'1 \t\u0006\u0001\n}'1]\u0005\u0004\u0005C\f%AB(qi&|g\u000e\u0005\u0003\u0003f\nUh\u0002\u0002Bt\u0005gtAA!;\u0003r:!!1\u001eBx\u001d\u0011\t)E!<\n\u0005Y:\u0014B\u0001\u001b6\u0013\tA7'C\u0002\u0003\u0018\u001dLAAa>\u0003z\n)1)[+jI*\u0019!qC4\t\u000f\u0005U%\u00051\u0001\u0002\u0018\u0006Iq-\u001a;Ti\u0006$Xo\u001d\u000b\u0005\u0005S\u0019\t\u0001C\u0004\u0002\u0016\u000e\u0002\r!a&)\u0007\r\n9,A\u0006hKR\u001cF/\u0019;vg\u0016\u001cH\u0003BB\u0005\u0007\u0017\u0001bAa\u0004\u0003\u001a\t%\u0002bBB\u0007I\u0001\u0007!QB\u0001\u0004S\u0012\u001c\bf\u0001\u0013\u00028\u0006iq-\u001a;SSN\\7kY8sKN$Ba!\u0006\u0004\u0018A1!q\u0002B\r\u0005WBqa!\u0004&\u0001\u0004\u0011i\u0001K\u0002&\u0003SC3!JA\\\u00035\u0019X\r\u001e*jg.\u001c6m\u001c:fgRA!\u0011PB\u0011\u0007G\u00199\u0003C\u0004\u0003\u0002\u001a\u0002\r!a&\t\u000f\r\u0015b\u00051\u0001\u0003l\u0005)1oY8sK\"91\u0011\u0006\u0014A\u0002\t-\u0014A\u0003;pi\u0006d7kY8sK\"\u001aa%a.\u0002\u0015%\u001cH+Z7qY\u0006$X\r\u0006\u0003\u0002\u000e\u000eE\u0002b\u0002BAO\u0001\u0007\u0011q\u0013\u0015\u0004O\u0005%\u0006fA\u0014\u00028\u0006Aq-\u001a;USRdW\r\u0006\u0003\u0002\u0018\u000em\u0002bBAKQ\u0001\u0007\u0011q\u0013\u0015\u0004Q\u0005%\u0006f\u0001\u0015\u00028\u00061Q\u000f\u001d3bi\u0016$2!TB#\u0011\u0019\t\t.\u000ba\u0001\u001b\"\u001a\u0011&a.\u0015\u000b5\u001bYea\u0014\t\r\r5#\u00061\u0001N\u0003!y'/[4j]\u0006d\u0007BBB)U\u0001\u0007Q*A\u0004va\u0012\fG/\u001a3)\u0007)\n9,A\u0004sKBd\u0017mY3\u0015\u000b5\u001bIfa\u0017\t\r\r53\u00061\u0001N\u0011\u0019\u0019\tf\u000ba\u0001\u001b\"\u001a1&a.\u0002\u0015\u001d,G/\u00117m)\u0006<7\u000f\u0006\u0003\u0004d\r%\u0004C\u0002B-\u0007K\n9*\u0003\u0003\u0004h\tm#aA*fi\"911\u000e\u0017A\u0002\t-\u0014a\u00037j[&$h*^7cKJD3\u0001LAUQ\ra\u0013qW\u0001\u000bO\u0016$(+\u001a7fCN,G#B'\u0004v\r\u0015\u0005b\u0002BA[\u0001\u00071q\u000f\t\u0005\u0007s\u001ayH\u0004\u0003\u0003h\u000em\u0014bAB?O\u0006!1)[%e\u0013\u0011\u0019\tia!\u0003\t\rK\u0017\n\u001a\u0006\u0004\u0007{:\u0007bBAz[\u0001\u0007\u0011Q_\u0001#G\",7m[%t\u001d>$(+\u001a4fe\u0016t7-\u001a3Cs\u0012+\u0007/\u001a8eK:\u001c\u0017.Z:\u0015\t\te41\u0012\u0005\b\u0007\u001bs\u0003\u0019AB<\u0003]\u0001H.\u00198Ji\u0016l\u0017\nZ(s\u0013R\u001c8\t[5mIJ,g.A\bgS:$7kQ'ECR\f')_%e)\u0011\u0019\u0019j!)\u0011\u000b\u0001\u0013yn!&\u0011\t\r]5QT\u0007\u0003\u00073SAaa'\u0003`\u0005!A.\u00198h\u0013\u0011\u0019yj!'\u0003\u000f%sG/Z4fe\"9\u0011QS\u0018A\u0002\u0005]\u0005fA\u0018\u0002*\"\u001aq&a.\u0002+\u0019Lg\u000eZ(wKJ$W/\u001a*fY\u0016\f7/Z%egR\u0011!Q\u0002\u0015\u0004a\u0005%\u0006f\u0001\u0019\u00028\u0006qq-\u001a;SK2,\u0017m]3Kg>tG\u0003BAL\u0007gCqA!!2\u0001\u0004\t9\nK\u00022\u0003SC3!MA\\Q\r\u000111\u0018\t\u0005\u0003W\u001bi,\u0003\u0003\u0004@\u00065&aD%t)J\fgn]1di&|g.\u00197")
public class SqlReleaseRepository
implements ReleaseRepository,
InterceptedRepository<Release>,
Logging,
DeserializationSupport,
ConfigurationReferencesSupport,
SqlReleaseRepositoryHelper {
    private final ReleasePersistence releasePersistence;
    private final TaskPersistence taskPersistence;
    private final DependencyPersistence dependencyPersistence;
    private final CommentPersistence commentPersistence;
    private final TeamRepository teamRepository;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private final ConfigurationReferencePersistence configurationPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final SqlBuilder.Dialect sqlDialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private scala.collection.immutable.Seq<PersistenceInterceptor<Release>> persistenceInterceptors;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public void replaceTasks(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceTasks$(this, original, updated);
    }

    @Override
    public void replaceReleaseExtensions(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceReleaseExtensions$(this, original, updated);
    }

    @Override
    public void replaceReleaseTeams(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceReleaseTeams$(this, original, updated);
    }

    @Override
    public void updateCommentsOnTasks(Task originalTask, Task updatedTask) {
        SqlReleaseRepositoryHelper.updateCommentsOnTasks$(this, originalTask, updatedTask);
    }

    @Override
    public void insertDependency(Integer gateTaskUid, Dependency dependency) {
        SqlReleaseRepositoryHelper.insertDependency$(this, gateTaskUid, dependency);
    }

    @Override
    public void updateConfigurationRefs(CiWithUid entity) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, entity);
    }

    @Override
    public void deleteConfigurationRefs(Integer uid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, uid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.deserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData, resolveOptions);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public void registerPersistenceInterceptor(PersistenceInterceptor<Release> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlReleaseRepository sqlReleaseRepository = this;
        synchronized (sqlReleaseRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public scala.collection.immutable.Seq<PersistenceInterceptor<Release>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(scala.collection.immutable.Seq<PersistenceInterceptor<Release>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public scala.collection.immutable.Seq<String> findIdsByStatus(ReleaseStatus ... statuses) {
        return this.findIdsByStatus((scala.collection.immutable.Seq<ReleaseStatus>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])statuses));
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public CommentPersistence commentPersistence() {
        return this.commentPersistence;
    }

    public TeamRepository teamRepository() {
        return this.teamRepository;
    }

    public ReleaseExtensionsRepository releaseExtensionsRepository() {
        return this.releaseExtensionsRepository;
    }

    @Override
    public ConfigurationReferencePersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String id) {
        return this.releasePersistence.existsRelease(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id)));
    }

    @Timed
    public Release create(Release release, ReleaseCreationSource releaseCreationSource) {
        if (this.releasePersistence.existsRelease(release.getId())) {
            throw new ItemAlreadyExistsException("A release with ID [%s] already exists", new Object[]{release.getId()});
        }
        this.interceptCreate((ConfigurationItem)release);
        this.releasePersistence.insert(release);
        CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().foreach((Function1 & Serializable)task -> {
            SqlReleaseRepository.$anonfun$create$1(this, release, task);
            return BoxedUnit.UNIT;
        });
        release.getExtensions().forEach(extension -> this.releaseExtensionsRepository().create(extension));
        this.updateConfigurationRefs((CiWithUid)release);
        this.facetRepositoryDispatcher.liveRepository().createFromTasks(CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().toSeq(), this.facetRepositoryDispatcher.liveRepository().createFromTasks$default$2());
        return release;
    }

    @Timed
    public Release findById(String id) {
        return this.getRelease(id, new ResolveOptionsBuilder().withEverything().build());
    }

    @Timed
    public Release findById(String id, ResolveOptions resolveOptions) {
        return this.getRelease(id, resolveOptions);
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findIdsByStatus(scala.collection.immutable.Seq<ReleaseStatus> statuses) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses(statuses).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).toSeq();
    }

    @Timed
    public Release findByCalendarToken(String calendarToken) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withCalendarToken(calendarToken).build();
        scala.collection.immutable.Seq<ReleaseRow> releases = this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams);
        return (Release)releases.headOption().map((Function1 & Serializable)x$1 -> this.deserializeRelease((ReleaseRow)x$1, new ResolveOptionsBuilder().withEverything().build())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findArchivableReleaseIds(Date date, int pageSize) {
        ReleasesSqlBuilder qual$1 = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED})))).withEndDateBefore(date).withPage(new Page(0L, (long)pageSize, Predef$.MODULE$.int2Integer(0), Page$.MODULE$.apply$default$4()));
        boolean x$1 = qual$1.withPreArchived$default$1();
        Tuple2 sqlWithParams = qual$1.withPreArchived(x$1).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).toSeq();
    }

    @Timed
    public void setPreArchived(String releaseId, boolean preArchived) {
        this.releasePersistence.setPreArchived(releaseId, preArchived);
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<Release> findPreArchivableReleases(int page, int pageSize) {
        scala.collection.immutable.Seq inactive = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED}));
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)inactive).withPreArchived(false).limitAndOffset(pageSize, page * pageSize).build();
        return (scala.collection.immutable.Seq)((IterableOps)((IterableOps)((IterableOps)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable)x$2 -> this.tryDeserializeRelease((ReleaseRow)x$2, new ResolveOptionsBuilder().withEverything().build()))).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isTutorial()))).map((Function1 & Serializable)release -> this.releaseExtensionsRepository().decorate(release))).map((Function1 & Serializable)release -> this.commentPersistence().decorate((Release)release));
    }

    @Timed
    public List<Release> search(ReleaseSearchByParams searchParams) {
        ReleaseSearchByParams releaseSearchByParams = searchParams;
        if (releaseSearchByParams == null) {
            throw new MatchError((Object)releaseSearchByParams);
        }
        Page page = releaseSearchByParams.page();
        Either folderId2 = releaseSearchByParams.folderId();
        ReleaseStatus[] statuses = releaseSearchByParams.statuses();
        String title = releaseSearchByParams.title();
        String rootReleaseId = releaseSearchByParams.rootReleaseId();
        boolean autoStart = releaseSearchByParams.autoStart();
        ReleasesSqlBuilder base = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withTitle(title).withRootReleaseId(rootReleaseId).withPage(page);
        ReleasesSqlBuilder sqlBuilder = folderId2 == null ? base : (ReleasesSqlBuilder)folderId2.fold((Function1 & Serializable)folderId -> base.withFolder((String)folderId), (Function1 & Serializable)ancestorId -> base.withAncestor((String)ancestorId));
        Object object = ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])statuses)) ? sqlBuilder.withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)statuses)) : BoxedUnit.UNIT;
        Object object2 = autoStart ? sqlBuilder.withAutoStart() : BoxedUnit.UNIT;
        List list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOps)((IterableOps)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlBuilder.build()).flatMap((Function1 & Serializable)x$4 -> this.tryDeserializeRelease((ReleaseRow)x$4, new ResolveOptionsBuilder().withEverything().build()))).map((Function1 & Serializable)release -> this.releaseExtensionsRepository().decorate(release))).map((Function1 & Serializable)release -> this.commentPersistence().decorate((Release)release))).asJava();
        return list;
    }

    @Timed
    public void delete(String id) {
        this.checkIsNotReferencedByDependencies(id);
        this.releasePersistence.findUidByReleaseId(id).foreach((Function1 & Serializable)uid -> {
            this.deleteReleaseReferences(id, uid);
            return BoxedUnit.UNIT;
        });
        this.releasePersistence.deleteById(id);
    }

    private void deleteReleaseReferences(String id, int releaseUid) {
        this.dependencyPersistence().deleteByReleaseUid(Predef$.MODULE$.int2Integer(releaseUid));
        scala.collection.immutable.Seq<Integer> taskCiUids = this.taskPersistence().findTaskCiUidsByReleaseCiUid(Predef$.MODULE$.int2Integer(releaseUid));
        this.dependencyPersistence().deleteByTaskUids(taskCiUids);
        this.commentPersistence().deleteByRelease(Predef$.MODULE$.int2Integer(releaseUid), taskCiUids);
        this.taskPersistence().deleteTasksByReleaseUid(releaseUid);
        this.teamRepository().deleteTeamsFromPlatform(new SecuredCi(id, releaseUid));
        this.releaseExtensionsRepository().deleteAll(id);
        this.deleteConfigurationRefs(Predef$.MODULE$.int2Integer(releaseUid));
        this.interceptDelete(id);
    }

    @Timed
    public void deleteWithUid(String id, int releaseUid) {
        this.deleteReleaseReferences(id, releaseUid);
        this.releasePersistence.deleteById(id);
    }

    @Timed
    public void move(String originalId, String newId) {
        this.releasePersistence.move(originalId, newId);
    }

    public Option<Integer> getUid(String id) {
        return this.releasePersistence.findUidByReleaseId(id);
    }

    @Timed
    public ReleaseStatus getStatus(String id) {
        String status = (String)this.releasePersistence.findReleaseStatus(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return status == null ? null : ReleaseStatus.valueOf((String)status.toUpperCase());
    }

    @Timed
    public scala.collection.immutable.Seq<ReleaseStatus> getStatuses(scala.collection.immutable.Seq<String> ids) {
        return ids.isEmpty() ? (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$) : (scala.collection.immutable.Seq)this.releasePersistence.findReleaseStatuses(ids).map((Function1 & Serializable)status -> ReleaseStatus.valueOf((String)status.toUpperCase()));
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<Object> getRiskScores(scala.collection.immutable.Seq<String> ids) {
        return this.releasePersistence.findReleaseRiskScores(ids);
    }

    @Timed
    public void setRiskScores(String releaseId, int score, int totalScore) {
        this.releasePersistence.updateReleaseRiskScores(releaseId, score, totalScore);
    }

    @Timed
    @IsReadOnly
    public boolean isTemplate(String releaseId) {
        return ReleaseStatus.TEMPLATE.equals(this.getStatus(releaseId));
    }

    @Timed
    @IsReadOnly
    public String getTitle(String id) {
        return (String)this.releasePersistence.findReleaseTitle(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id))).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException("Release [%s] not found", new Object[]{id});
        });
    }

    @Timed
    public Release update(Release release) {
        return this.update(null, release);
    }

    @Timed
    public Release update(Release original, Release updated) {
        Option originalReleaseOpt = Option$.MODULE$.apply((Object)original);
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        originalReleaseOpt.foreach((Function1 & Serializable)rel -> {
            SqlReleaseRepository.$anonfun$update$1(this, updated, rel);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs((CiWithUid)updated);
        return updated;
    }

    @Timed
    public Release replace(Release original, Release updated) {
        if (Ids.isFolderId((String)original.getId())) {
            updated.setTeams(Collections.emptyList());
        }
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        if (original != null) {
            this.replaceTasks(original, updated);
            this.replaceReleaseExtensions(original, updated);
            this.replaceReleaseTeams(original, updated);
        }
        this.updateConfigurationRefs((CiWithUid)updated);
        return updated;
    }

    @Timed
    @IsReadOnly
    public Set<String> getAllTags(int limitNumber) {
        return CollectionConverters$.MODULE$.SetHasAsJava(this.releasePersistence.findAllTags(limitNumber)).asJava();
    }

    /*
     * WARNING - void declaration
     */
    private Release getRelease(String releaseId, ResolveOptions resolveOptions) {
        void var3_3;
        BoxedUnit boxedUnit;
        Release release = (Release)this.repositoryAdapter().read(releaseId, resolveOptions);
        if (release == null) {
            throw new LogFriendlyNotFoundException(new StringBuilder(30).append("Repository entity [").append(releaseId).append("] not found").toString(), new Object[0]);
        }
        if (resolveOptions.hasDecorators()) {
            this.releaseExtensionsRepository().decorate(release);
            boxedUnit = this.commentPersistence().decorate(release);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    private void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        scala.collection.immutable.Seq externalIncomingDependencies = (scala.collection.immutable.Seq)((IterableOps)this.dependencyPersistence().findByPartialTargetIds((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{planItemIdOrItsChildren}))), (Option<scala.collection.immutable.Set<String>>)None$.MODULE$).map((Function1 & Serializable)x$6 -> DependencyRow$.MODULE$.DependencyRowOps((DependencyRow)x$6).fullDependencyId())).filterNot((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.startsWith(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(planItemIdOrItsChildren)))));
        if (externalIncomingDependencies.nonEmpty()) {
            throw new ItemInUseException(new StringBuilder(0).append(new StringBuilder(68).append("Cannot delete [").append(planItemIdOrItsChildren).append("] because it or one of its children is referenced by ").toString()).append(new StringBuilder(28).append("one or more dependencies: [").append(externalIncomingDependencies.mkString(", ")).append("]").toString()).toString(), new Object[0]);
        }
    }

    @Timed
    @IsReadOnly
    public Option<Integer> findSCMDataById(String id) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(49).append("Finding scm data for template or release with id ").append(id).toString());
        return this.releasePersistence.findSCMDataById(id).map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1));
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findOverdueReleaseIds() {
        return this.releasePersistence.findOverdueReleaseIds();
    }

    @Timed
    @IsReadOnly
    public String getReleaseJson(String releaseId) {
        return (String)this.releasePersistence.findByReleaseId(releaseId).map((Function1 & Serializable)x$8 -> x$8.json()).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(30).append("Repository entity [").append(releaseId).append("] not found").toString(), new Object[0]);
        });
    }

    public static final /* synthetic */ boolean $anonfun$create$2(SqlReleaseRepository $this, Integer taskUid$1, Comment comment) {
        return $this.commentPersistence().create(taskUid$1, CommentPersistence$CommentRow$.MODULE$.fromComment(comment));
    }

    public static final /* synthetic */ void $anonfun$create$1(SqlReleaseRepository $this, Release release$1, Task task) {
        Integer taskUid = $this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(release$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)comment -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$create$2($this, taskUid, comment)));
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$update$3(SqlReleaseRepository $this, Integer taskUid$2, Comment c) {
        return $this.commentPersistence().create(taskUid$2, CommentPersistence$CommentRow$.MODULE$.fromComment(c));
    }

    public static final /* synthetic */ void $anonfun$update$2(SqlReleaseRepository $this, Release updated$1, Task task) {
        Integer taskUid = $this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(updated$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$update$3($this, taskUid, c)));
        ((IterableOnceOps)syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).filterNot((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isArchived()))).foreach((Function1 & Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$update$1(SqlReleaseRepository $this, Release updated$1, Release rel) {
        Diff$.MODULE$.apply((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(rel.getAllTasks()).asScala(), (Iterable)CollectionConverters$.MODULE$.ListHasAsScala(updated$1.getAllTasks()).asScala()).newValues().foreach((Function1 & Serializable)task -> {
            SqlReleaseRepository.$anonfun$update$2($this, updated$1, task);
            return BoxedUnit.UNIT;
        });
    }

    public SqlReleaseRepository(ReleasePersistence releasePersistence, TaskPersistence taskPersistence, DependencyPersistence dependencyPersistence, CommentPersistence commentPersistence, TeamRepository teamRepository, ReleaseExtensionsRepository releaseExtensionsRepository, ConfigurationReferencePersistence configurationPersistence, SqlRepositoryAdapter repositoryAdapter, FacetRepositoryDispatcher facetRepositoryDispatcher, SqlBuilder.Dialect sqlDialect) {
        this.releasePersistence = releasePersistence;
        this.taskPersistence = taskPersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.commentPersistence = commentPersistence;
        this.teamRepository = teamRepository;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        this.configurationPersistence = configurationPersistence;
        this.repositoryAdapter = repositoryAdapter;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.sqlDialect = sqlDialect;
        InterceptedRepository.$init$((InterceptedRepository)this);
        Logging.$init$((Logging)this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        SqlReleaseRepositoryHelper.$init$(this);
    }
}

