/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.CiWithUid;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata$;
import com.xebialabs.xlrelease.domain.calendar.Blackout;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.CommentRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.repository.sql.BaseReleaseItemRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.TasksSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow$;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptionsBuilder;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\r\rc\u0001\u0002\u0015*\u0001QB\u0001\"\u0015\u0001\u0003\u0006\u0004%\tA\u0015\u0005\t3\u0002\u0011\t\u0011)A\u0005'\"A!\f\u0001BC\u0002\u0013\u00051\f\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003]\u0011!\u0001\u0007A!b\u0001\n\u0003\t\u0007\u0002C3\u0001\u0005\u0003\u0005\u000b\u0011\u00022\t\u0011\u0019\u0004!Q1A\u0005\u0002\u001dD\u0001b\u001b\u0001\u0003\u0002\u0003\u0006I\u0001\u001b\u0005\tY\u0002\u0011)\u0019!C\u0001[\"A\u0011\u000f\u0001B\u0001B\u0003%a\u000e\u0003\u0005s\u0001\t\u0015\r\u0011\"\u0001t\u0011!Q\bA!A!\u0002\u0013!\b\u0002C>\u0001\u0005\u000b\u0007I\u0011\u0001?\t\u0013\u0005\u0005\u0001A!A!\u0002\u0013i\bBCA\u0002\u0001\t\u0015\r\u0011b\u0001\u0002\u0006!Q\u0011Q\u0007\u0001\u0003\u0002\u0003\u0006I!a\u0002\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:!9\u0011Q\n\u0001\u0005B\u0005=\u0003bBA'\u0001\u0011\u0005\u0013\u0011\u0014\u0005\b\u0003w\u0003A\u0011IA_\u0011\u001d\t\t\u0010\u0001C!\u0003gDqA!\u0001\u0001\t\u0003\u0012\u0019\u0001C\u0004\u0003\f\u0001!\tE!\u0004\t\u000f\t5\u0002\u0001\"\u0011\u00030!9!Q\u0007\u0001\u0005B\t]\u0002b\u0002B$\u0001\u0011\u0005#\u0011\n\u0005\b\u0005\u001f\u0002A\u0011\tB)\u0011\u001d\u00119\u0006\u0001C\u0005\u00053BqAa\u0018\u0001\t\u0003\u0012\t\u0007C\u0004\u0003h\u0001!\tE!\u001b\t\u000f\t\r\u0005\u0001\"\u0011\u0003\u0006\"9!\u0011\u0014\u0001\u0005B\tm\u0005b\u0002BP\u0001\u0011\u0005#\u0011\u0015\u0005\b\u0005S\u0003A\u0011\tBV\u0011\u001d\u0011\t\r\u0001C!\u0005\u0007DqAa7\u0001\t\u0003\u0012\u0019\rC\u0004\u0003b\u0002!\tEa9\t\u000f\t]\b\u0001\"\u0011\u0003z\"91\u0011\u0002\u0001\u0005B\r-!!E*rYR\u000b7o\u001b*fa>\u001c\u0018\u000e^8ss*\u0011!fK\u0001\u0004gFd'B\u0001\u0017.\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003]=\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005A\n\u0014!\u0003=fE&\fG.\u00192t\u0015\u0005\u0011\u0014aA2p[\u000e\u00011c\u0002\u00016w}\u001ae)\u0013\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\u0007\u0003:L(+\u001a4\u0011\u0005qjT\"A\u0016\n\u0005yZ#A\u0004+bg.\u0014V\r]8tSR|'/\u001f\t\u0003\u0001\u0006k\u0011!K\u0005\u0003\u0005&\u0012\u0011DQ1tKJ+G.Z1tK&#X-\u001c*fa>\u001c\u0018\u000e^8ssB\u0011\u0001\tR\u0005\u0003\u000b&\u0012a\u0003R3tKJL\u0017\r\\5{CRLwN\\*vaB|'\u000f\u001e\t\u0003\u0001\u001eK!\u0001S\u0015\u0003=\r{gNZ5hkJ\fG/[8o%\u00164WM]3oG\u0016\u001c8+\u001e9q_J$\bC\u0001&P\u001b\u0005Y%B\u0001'N\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005q\u0015\u0001C4sSjTH.\u001a3\n\u0005A[%a\u0002'pO\u001eLgnZ\u0001\u0013e\u0016dW-Y:f!\u0016\u00148/[:uK:\u001cW-F\u0001T!\t!v+D\u0001V\u0015\t1\u0016&A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,\u0017B\u0001-V\u0005I\u0011V\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0002'I,G.Z1tKB+'o]5ti\u0016t7-\u001a\u0011\u0002+\u0011,\u0007/\u001a8eK:\u001c\u0017\u0010U3sg&\u001cH/\u001a8dKV\tA\f\u0005\u0002U;&\u0011a,\u0016\u0002\u0016\t\u0016\u0004XM\u001c3f]\u000eL\b+\u001a:tSN$XM\\2f\u0003Y!W\r]3oI\u0016t7-\u001f)feNL7\u000f^3oG\u0016\u0004\u0013a\u0004;bg.\u0004VM]:jgR,gnY3\u0016\u0003\t\u0004\"\u0001V2\n\u0005\u0011,&a\u0004+bg.\u0004VM]:jgR,gnY3\u0002!Q\f7o\u001b)feNL7\u000f^3oG\u0016\u0004\u0013!E2p[6,g\u000e\u001e*fa>\u001c\u0018\u000e^8ssV\t\u0001\u000e\u0005\u0002=S&\u0011!n\u000b\u0002\u0012\u0007>lW.\u001a8u%\u0016\u0004xn]5u_JL\u0018AE2p[6,g\u000e\u001e*fa>\u001c\u0018\u000e^8ss\u0002\n\u0011C]3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3s+\u0005q\u0007C\u0001!p\u0013\t\u0001\u0018F\u0001\u000bTc2\u0014V\r]8tSR|'/_!eCB$XM]\u0001\u0013e\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014\b%\u0001\rd_:4\u0017nZ;sCRLwN\u001c)feNL7\u000f^3oG\u0016,\u0012\u0001\u001e\t\u0003kbl\u0011A\u001e\u0006\u0003oV\u000bQbY8oM&<WO]1uS>t\u0017BA=w\u0005\u0005\u001auN\u001c4jOV\u0014\u0018\r^5p]J+g-\u001a:f]\u000e,\u0007+\u001a:tSN$XM\\2f\u0003e\u0019wN\u001c4jOV\u0014\u0018\r^5p]B+'o]5ti\u0016t7-\u001a\u0011\u00023\u0019\f7-\u001a;SKB|7/\u001b;pef$\u0015n\u001d9bi\u000eDWM]\u000b\u0002{B\u0011AH`\u0005\u0003\u007f.\u0012\u0011DR1dKR\u0014V\r]8tSR|'/\u001f#jgB\fGo\u00195fe\u0006Qb-Y2fiJ+\u0007o\\:ji>\u0014\u0018\u0010R5ta\u0006$8\r[3sA\u00059A-[1mK\u000e$XCAA\u0004!\u0011\tI!a\f\u000f\t\u0005-\u0011\u0011\u0006\b\u0005\u0003\u001b\t)C\u0004\u0003\u0002\u0010\u0005\u0005b\u0002BA\t\u0003?qA!a\u0005\u0002\u001e9!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001aM\na\u0001\u0010:p_Rt\u0014\"\u0001\u001a\n\u0005A\n\u0014B\u0001\u00180\u0013\r\t\u0019#L\u0001\u0003I\nL1AKA\u0014\u0015\r\t\u0019#L\u0005\u0005\u0003W\ti#\u0001\u0006Tc2\u0014U/\u001b7eKJT1AKA\u0014\u0013\u0011\t\t$a\r\u0003\u000f\u0011K\u0017\r\\3di*!\u00111FA\u0017\u0003!!\u0017.\u00197fGR\u0004\u0013A\u0002\u001fj]&$h\b\u0006\n\u0002<\u0005u\u0012qHA!\u0003\u0007\n)%a\u0012\u0002J\u0005-\u0003C\u0001!\u0001\u0011\u0015\t\u0016\u00031\u0001T\u0011\u0015Q\u0016\u00031\u0001]\u0011\u0015\u0001\u0017\u00031\u0001c\u0011\u00151\u0017\u00031\u0001i\u0011\u0015a\u0017\u00031\u0001o\u0011\u0015\u0011\u0018\u00031\u0001u\u0011\u0015Y\u0018\u00031\u0001~\u0011\u001d\t\u0019!\u0005a\u0002\u0003\u000f\t\u0001BZ5oI\nK\u0018\nZ\u000b\u0005\u0003#\n9\u0006\u0006\u0003\u0002T\u0005=\u0004\u0003BA+\u0003/b\u0001\u0001B\u0004\u0002ZI\u0011\r!a\u0017\u0003\u0003Q\u000bB!!\u0018\u0002dA\u0019a'a\u0018\n\u0007\u0005\u0005tGA\u0004O_RD\u0017N\\4\u0011\t\u0005\u0015\u00141N\u0007\u0003\u0003OR1!!\u001b.\u0003\u0019!w.\\1j]&!\u0011QNA4\u0005\u0011!\u0016m]6\t\u000f\u0005E$\u00031\u0001\u0002t\u00051A/Y:l\u0013\u0012\u0004B!!\u001e\u0002~9!\u0011qOA=!\r\t)bN\u0005\u0004\u0003w:\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0000\u0005\u0005%AB*ue&twMC\u0002\u0002|]B3AEAC!\u0011\t9)!&\u000e\u0005\u0005%%\u0002BAF\u0003\u001b\u000b!\"\u00198o_R\fG/[8o\u0015\u0011\ty)!%\u0002\u000f5,GO]5dg*\u0019\u00111S\u0019\u0002\u0011\r|G-\u00195bY\u0016LA!a&\u0002\n\n)A+[7fIV!\u00111TAP)\u0019\ti*!)\u0002$B!\u0011QKAP\t\u001d\tIf\u0005b\u0001\u00037Bq!!\u001d\u0014\u0001\u0004\t\u0019\bC\u0004\u0002&N\u0001\r!a*\u0002\u001dI,7o\u001c7wK>\u0003H/[8ogB!\u0011\u0011VA[\u001b\t\tYKC\u0002-\u0003[SA!a,\u00022\u0006!!n]8o\u0015\r\t\u0019,L\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\n\t\u0005]\u00161\u0016\u0002\u000f%\u0016\u001cx\u000e\u001c<f\u001fB$\u0018n\u001c8tQ\r\u0019\u0012QQ\u0001\u0013M&tG\rV1tWN\u0014\u0015m]5d\t\u0006$\u0018\r\u0006\u0003\u0002@\u0006m\u0007CBAa\u0003\u0017\fy-\u0004\u0002\u0002D*!\u0011QYAd\u0003\u0011)H/\u001b7\u000b\u0005\u0005%\u0017\u0001\u00026bm\u0006LA!!4\u0002D\n!A*[:u!\u0011\t\t.a6\u000e\u0005\u0005M'bAAkW\u0005)\u0011/^3ss&!\u0011\u0011\\Aj\u00055!\u0016m]6CCNL7\rR1uC\"9\u0011Q\u001c\u000bA\u0002\u0005}\u0017a\u0002;bg.LEm\u001d\t\u0007\u0003\u0003\fY-a\u001d)\u0007Q\t\u0019\u000f\u0005\u0003\u0002f\u0006-XBAAt\u0015\u0011\tI/!\f\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0003[\f9O\u0001\u0006JgJ+\u0017\rZ(oYfD3\u0001FAC\u0003\u0019)\u00070[:ugR!\u0011Q_A~!\r1\u0014q_\u0005\u0004\u0003s<$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003c*\u0002\u0019AA:Q\r)\u00121\u001d\u0015\u0004+\u0005\u0015\u0015AB;qI\u0006$X\r\u0006\u0003\u0002d\t\u0015\u0001b\u0002B\u0004-\u0001\u0007\u00111M\u0001\u0005i\u0006\u001c8\u000eK\u0002\u0017\u0003\u000b\u000b1\"\u001e9eCR,G+Y:lgR!!q\u0002B\u000b!\r1$\u0011C\u0005\u0004\u0005'9$\u0001B+oSRDqAa\u0006\u0018\u0001\u0004\u0011I\"A\u0003uCN\\7\u000fE\u00037\u00057\t\u0019'C\u0002\u0003\u001e]\u0012!\u0002\u0010:fa\u0016\fG/\u001a3?Q\r9\"\u0011\u0005\t\u0005\u0005G\u00119#\u0004\u0002\u0003&)\u0019\u00111R\u001c\n\t\t%\"Q\u0005\u0002\bm\u0006\u0014\u0018M]4tQ\r9\u0012QQ\u0001\u0015kB$\u0017\r^3UCN\\\u0007K]8qKJ$\u0018.Z:\u0015\t\t=!\u0011\u0007\u0005\b\u0005\u000fA\u0002\u0019AA2Q\rA\u0012QQ\u0001\u001fkB$\u0017\r^3UCN\\\u0017I\u001c3SK2,\u0017m]3GY\u0006<7\u000b^1ukN$b!a\u0019\u0003:\tm\u0002b\u0002B\u00043\u0001\u0007\u00111\r\u0005\b\u0005{I\u0002\u0019\u0001B \u0003\u001d\u0011X\r\\3bg\u0016\u0004B!!\u001a\u0003B%!!1IA4\u0005\u001d\u0011V\r\\3bg\u0016D3!GAC\u0003))\b\u000fZ1uKRK\b/\u001a\u000b\u0005\u0003G\u0012Y\u0005C\u0004\u0003\bi\u0001\r!a\u0019)\u0007i\t))\u0001\u0004eK2,G/\u001a\u000b\u0005\u0005\u001f\u0011\u0019\u0006C\u0004\u0003\bm\u0001\r!a\u0019)\u0007m\t))\u0001\u0006de\u0016\fG/\u001a+bg.$B!a\u0019\u0003\\!9!Q\f\u000fA\u0002\u0005\r\u0014a\u00028foR\u000b7o[\u0001\u0007GJ,\u0017\r^3\u0015\t\u0005\r$1\r\u0005\b\u0005;j\u0002\u0019AA2Q\ri\u0012QQ\u0001\t[>4X\rV1tWRQ\u00111\rB6\u0005_\u0012\u0019H! \t\u000f\t5d\u00041\u0001\u0002d\u0005QA/Y:l)>luN^3\t\u000f\tEd\u00041\u0001\u0002d\u0005IQn\u001c<fIR\u000b7o\u001b\u0005\b\u0005kr\u0002\u0019\u0001B<\u0003Y)\b\u000fZ1uK\u0012|%/[4j]\u000e{g\u000e^1j]\u0016\u0014\b\u0003BA3\u0005sJAAa\u001f\u0002h\tiA+Y:l\u0007>tG/Y5oKJDqAa \u001f\u0001\u0004\u00119(\u0001\fva\u0012\fG/\u001a3UCJ<W\r^\"p]R\f\u0017N\\3sQ\rq\u0012QQ\u0001\u0017M&tG-\u00114gK\u000e$X\r\u001a\"z\u00052\f7m[8viR!\u0011q\u001cBD\u0011\u001d\u0011Ii\ba\u0001\u0005\u0017\u000b\u0001B\u00197bG.|W\u000f\u001e\t\u0005\u0005\u001b\u0013\u0019*\u0004\u0002\u0003\u0010*!!\u0011SA4\u0003!\u0019\u0017\r\\3oI\u0006\u0014\u0018\u0002\u0002BK\u0005\u001f\u0013\u0001B\u00117bG.|W\u000f\u001e\u0015\u0004?\u0005\u0015\u0015A\u00074j]\u0012\u0004VM\u001c3j]\u001e$\u0016m]6t/&$\bNR1dKR\u001cHCAApQ\r\u0001\u0013QQ\u0001\tO\u0016$H+\u001b;mKR!\u00111\u000fBR\u0011\u001d\t\t(\ta\u0001\u0003gB3!IArQ\r\t\u0013QQ\u0001\u000bO\u0016$\u0018\t\u001c7UC\u001e\u001cH\u0003\u0002BW\u0005g\u0003b!!1\u00030\u0006M\u0014\u0002\u0002BY\u0003\u0007\u00141aU3u\u0011\u001d\u0011)L\ta\u0001\u0005o\u000b1\u0002\\5nSRtU/\u001c2feB\u0019aG!/\n\u0007\tmvGA\u0002J]RD3AIArQ\r\u0011\u0013QQ\u0001\u0013M&tGm\u0014<fe\u0012,X\rV1tW&#7\u000f\u0006\u0002\u0003FB1!q\u0019Bi\u0003grAA!3\u0003N:!\u0011Q\u0003Bf\u0013\u0005A\u0014b\u0001Bho\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002Bj\u0005+\u00141aU3r\u0015\r\u0011ym\u000e\u0015\u0004G\u0005\r\bfA\u0012\u0002\u0006\u0006\u0011b-\u001b8e\tV,7k\\8o)\u0006\u001c8.\u00133tQ\r!\u00131\u001d\u0015\u0004I\u0005\u0015\u0015!C4fiN#\u0018\r^;t)\u0011\u0011)O!=\u0011\t\t\u001d(Q^\u0007\u0003\u0005STAAa;\u0002h\u000511\u000f^1ukNLAAa<\u0003j\nQA+Y:l'R\fG/^:\t\u000f\u0005ET\u00051\u0001\u0002t!\u001aQ%a9)\u0007\u0015\n))A\bhKR$\u0016m]6Ti\u0006$Xo]3t)\u0011\u0011Yp!\u0001\u0011\u0011\u0005\u0005'Q`A:\u0005KLAAa@\u0002D\n\u0019Q*\u00199\t\u000f\r\ra\u00051\u0001\u0002t\u0005I!/\u001a7fCN,\u0017\n\u001a\u0015\u0004M\u0005\r\bf\u0001\u0014\u0002\u0006\u00069c-\u001b8e)\u0006\u001c8.\u00133t\u0005f$\u0016m]6UsB,7\u000b^1ukN\fe\u000eZ*uCJ$H)\u0019;f)!\u0011)m!\u0004\u0004*\r5\u0002bBB\bO\u0001\u00071\u0011C\u0001\ti\u0006\u001c8\u000eV=qKB!11CB\u0013\u001b\t\u0019)B\u0003\u0003\u0004\u0018\re\u0011a\u0002:fM2,7\r\u001e\u0006\u0005\u00077\u0019i\"A\u0002ba&TAaa\b\u0004\"\u00051\u0001\u000f\\;hS:T1aa\t0\u0003!!W\r\u001d7ps&$\u0018\u0002BB\u0014\u0007+\u0011A\u0001V=qK\"911F\u0014A\u0002\t\u0015\u0018A\u0003;bg.\u001cF/\u0019;vg\"91qF\u0014A\u0002\rE\u0012!D:uCJ$X\r\u001a\"fM>\u0014X\r\u0005\u0003\u0002B\u000eM\u0012\u0002BB\u001b\u0003\u0007\u0014A\u0001R1uK\"\u001aq%a9)\u0007\u001d\n)\tK\u0002\u0001\u0007{\u0001B!!:\u0004@%!1\u0011IAt\u0005=I5\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007")
public class SqlTaskRepository
implements TaskRepository,
BaseReleaseItemRepository,
DeserializationSupport,
ConfigurationReferencesSupport,
Logging {
    private final ReleasePersistence releasePersistence;
    private final DependencyPersistence dependencyPersistence;
    private final TaskPersistence taskPersistence;
    private final CommentRepository commentRepository;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final ConfigurationReferencePersistence configurationPersistence;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final SqlBuilder.Dialect dialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void updateConfigurationRefs(CiWithUid entity) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, entity);
    }

    @Override
    public void deleteConfigurationRefs(Integer uid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, uid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.deserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Release getRelease(String releaseId, String entityId) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId);
    }

    @Override
    public Release getRelease(String releaseId, String entityId, ResolveOptions resolveOptions) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId, resolveOptions);
    }

    @Override
    public <T> T notNull(T ci, String ciId) {
        return (T)BaseReleaseItemRepository.notNull$(this, ci, ciId);
    }

    @Override
    public void insertDependencyWithGateTaskUid(Integer gateTaskUid, Dependency dependency) {
        BaseReleaseItemRepository.insertDependencyWithGateTaskUid$(this, gateTaskUid, dependency);
    }

    @Override
    public void insertDependency(Dependency dependency) {
        BaseReleaseItemRepository.insertDependency$(this, dependency);
    }

    @Override
    public void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        BaseReleaseItemRepository.checkIsNotReferencedByDependencies$(this, planItemIdOrItsChildren);
    }

    public TaskBasicData findTaskBasicData(String taskId) {
        return TaskRepository.findTaskBasicData$((TaskRepository)this, (String)taskId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTaskRepository sqlTaskRepository = this;
        synchronized (sqlTaskRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public void updateTasks(Task ... tasks) {
        this.updateTasks((scala.collection.immutable.Seq<Task>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])tasks));
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    @Override
    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public CommentRepository commentRepository() {
        return this.commentRepository;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Override
    public ConfigurationReferencePersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    public FacetRepositoryDispatcher facetRepositoryDispatcher() {
        return this.facetRepositoryDispatcher;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    public <T extends Task> T findById(String taskId) {
        return this.findById(taskId, new ResolveOptionsBuilder().withEverything().build());
    }

    @Timed
    public <T extends Task> T findById(String taskId, ResolveOptions resolveOptions) {
        if (!this.exists(taskId)) {
            throw new NotFoundException(new StringBuilder(30).append("Repository entity [").append(taskId).append("] not found").toString(), new Object[0]);
        }
        Release release = this.getRelease(Ids.releaseIdFrom((String)taskId), taskId, resolveOptions);
        return (T)((Task)Option$.MODULE$.apply((Object)release.getTask(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(taskId)))).fold((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(41).append("Repository entity [").append(taskId).append("] not found in release").toString(), new Object[0]);
        }, (Function1 & Serializable)task -> {
            task.getAllTasks().forEach(t -> this.commentRepository().decorate(t));
            return task;
        }));
    }

    @Timed
    @IsReadOnly
    public List<TaskBasicData> findTasksBasicData(List<String> taskIds) {
        List list;
        if (taskIds.isEmpty()) {
            list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().empty()).asJava();
        } else {
            scala.collection.immutable.Seq<TaskRow> tasksData = this.taskPersistence().findByIds((Iterable<String>)CollectionConverters$.MODULE$.ListHasAsScala(taskIds).asScala());
            list = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(taskIds).asScala().map((Function1 & Serializable)taskId -> new Tuple2(taskId, (Object)tasksData.find((Function1 & Serializable)data -> BoxesRunTime.boxToBoolean((boolean)taskId.endsWith(data.taskId())))))).flatMap((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) return None$.MODULE$;
                String id = (String)tuple2._1();
                Option option = (Option)tuple2._2();
                if (!(option instanceof Some)) return None$.MODULE$;
                Some some = (Some)option;
                TaskRow data = (TaskRow)some.value();
                return new Some((Object)TaskRow$.MODULE$.TaskDataOps(data).asTaskData(id));
            })).asJava();
        }
        return list;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(26).append("Checking if exists task [").append(taskId).append("]").toString());
        return this.taskPersistence().exists(taskId);
    }

    @Timed
    public Task update(Task task) {
        Release release = task.getRelease();
        this.releasePersistence().update(release);
        this.updateTaskProperties(task);
        this.updateConfigurationRefs((CiWithUid)release);
        return task;
    }

    @Timed
    public void updateTasks(scala.collection.immutable.Seq<Task> tasks) {
        tasks.groupBy((Function1 & Serializable)x$1 -> x$1.getRelease()).foreach((Function1 & Serializable)x0$1 -> {
            SqlTaskRepository.$anonfun$updateTasks$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void updateTaskProperties(Task task) {
        this.taskPersistence().updateProperties(task);
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)x0$1 -> {
            SqlTaskRepository.$anonfun$updateTaskProperties$1(this, task, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Task updateTaskAndReleaseFlagStatus(Task task, Release release) {
        return this.update(task);
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Task updateType(Task task) {
        void var2_2;
        Task updated = this.update(task);
        this.taskPersistence().updateType(task);
        return var2_2;
    }

    @Timed
    public void delete(Task task) {
        this.checkIsNotReferencedByDependencies(task.getId());
        this.releasePersistence().update(task.getRelease());
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)dependency -> {
            SqlTaskRepository.$anonfun$delete$1(this, dependency);
            return BoxedUnit.UNIT;
        });
        task.getAllTasks().forEach(t -> {
            this.commentRepository().deleteByTask(t);
            this.taskPersistence().delete((Task)t);
        });
        this.updateConfigurationRefs((CiWithUid)task.getRelease());
    }

    private Task createTask(Task newTask2) {
        this.taskPersistence().insert(newTask2, Predef$.MODULE$.Integer2int(newTask2.getRelease().getCiUid()));
        Object object = newTask2 instanceof TaskGroup ? ((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(newTask2.getAllTasks()).asScala().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$createTask$1(newTask2, x$2)))).map((Function1 & Serializable)newTask -> this.createTask((Task)newTask)) : BoxedUnit.UNIT;
        return newTask2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Task create(Task newTask) {
        void var2_2;
        this.releasePersistence().update(newTask.getRelease());
        Task createdTask = this.createTask(newTask);
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(createdTask)).foreach((Function1 & Serializable)dependency -> {
            this.insertDependency(dependency);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs((CiWithUid)createdTask.getRelease());
        this.facetRepositoryDispatcher().liveRepository().createFromTasks(CollectionConverters$.MODULE$.ListHasAsScala(newTask.getAllTasks()).asScala().toSeq(), this.facetRepositoryDispatcher().liveRepository().createFromTasks$default$2());
        return var2_2;
    }

    @Timed
    public Task moveTask(Task taskToMove, Task movedTask, TaskContainer updatedOriginContainer, TaskContainer updatedTargetContainer) {
        TaskContainer taskContainer = updatedOriginContainer;
        TaskContainer taskContainer2 = updatedTargetContainer;
        if (taskContainer == null ? taskContainer2 != null : !taskContainer.equals(taskContainer2)) {
            this.checkIsNotReferencedByDependencies(taskToMove.getId());
            CollectionConverters$.MODULE$.ListHasAsScala(taskToMove.getAllTasks()).asScala().foreach((Function1 & Serializable)taskWithOldId -> {
                SqlTaskRepository.$anonfun$moveTask$1(this, taskToMove, movedTask, taskWithOldId);
                return BoxedUnit.UNIT;
            });
        }
        this.releasePersistence().update(movedTask.getRelease());
        return movedTask;
    }

    @Timed
    public List<String> findAffectedByBlackout(Blackout blackout) {
        Date endDate = BlackoutMetadata$.MODULE$.toStartOfNextMinute(blackout.getEndDate());
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.dialect()).selectReleaseData().withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)ReleaseStatus.ACTIVE_STATUSES)).build();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOps)((IterableOps)((IterableOps)this.releasePersistence().findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable)x$3 -> this.tryDeserializeRelease((ReleaseRow)x$3, new ResolveOptionsBuilder().build()))).flatMap((Function1 & Serializable)rel -> CollectionConverters$.MODULE$.ListHasAsScala(rel.getAllTasks()).asScala())).filter((Function1 & Serializable)task -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$findAffectedByBlackout$3(endDate, task)))).map((Function1 & Serializable)x$4 -> x$4.getId())).asJava();
    }

    @Timed
    public List<String> findPendingTasksWithFacets() {
        Tuple2 sqlWithParams = new TasksSqlBuilder(this.dialect()).selectTaskId().withOneOfTaskStatuses((scala.collection.immutable.Seq<TaskStatus>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TaskStatus[]{TaskStatus.PENDING})))).withAnyFacets().build();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.taskPersistence().findTaskIdsByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).toSet().toList()).asJava();
    }

    @Timed
    @IsReadOnly
    public String getTitle(String taskId) {
        return (String)this.taskPersistence().getTitle(taskId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Task [%s] not found", new Object[]{taskId});
        });
    }

    @Timed
    @IsReadOnly
    public Set<String> getAllTags(int limitNumber) {
        return CollectionConverters$.MODULE$.SetHasAsJava(this.taskPersistence().findAllTags(limitNumber)).asJava();
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findOverdueTaskIds() {
        return this.taskPersistence().findOverdueTaskIds();
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findDueSoonTaskIds() {
        return this.taskPersistence().findDueSoonTaskIds();
    }

    @Timed
    @IsReadOnly
    public TaskStatus getStatus(String taskId) {
        return (TaskStatus)this.taskPersistence().getStatus(taskId).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(33).append("getStatus: could not find task '").append(taskId).append("'").toString(), new Object[0]);
        });
    }

    @Timed
    @IsReadOnly
    public Map<String, TaskStatus> getTaskStatuses(String releaseId) {
        return this.taskPersistence().getTaskStatuses(releaseId);
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findTaskIdsByTaskTypeStatusAndStartDate(Type taskType, TaskStatus taskStatus, Date startedBefore) {
        return this.taskPersistence().findTaskIdsByTaskTypeStatusAndStartDate(taskType, taskStatus, startedBefore);
    }

    public static final /* synthetic */ void $anonfun$updateTasks$2(SqlTaskRepository $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Release release = (Release)tuple2._1();
        scala.collection.immutable.Seq tasks = (scala.collection.immutable.Seq)tuple2._2();
        $this.releasePersistence().update(release);
        tasks.foreach((Function1 & Serializable)task -> {
            $this.updateTaskProperties(task);
            return BoxedUnit.UNIT;
        });
        $this.updateConfigurationRefs((CiWithUid)release);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$updateTaskProperties$1(SqlTaskRepository $this, Task task$1, Dependency x0$1) {
        Dependency dependency = x0$1;
        if (dependency.isArchived()) {
            $this.dependencyPersistence().deleteDependency(dependency);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            try {
                $this.dependencyPersistence().updateDependency(dependency);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (NotFoundException e) {
                $this.logger().error((Function0 & Serializable)() -> new StringBuilder(41).append("Dependency ").append(dependency).append(" not found when updating task ").append(task$1).toString(), (Function0 & Serializable)() -> e);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public static final /* synthetic */ void $anonfun$delete$1(SqlTaskRepository $this, Dependency dependency) {
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    public static final /* synthetic */ boolean $anonfun$createTask$1(Task newTask$1, Task x$2) {
        String string = x$2.getContainer().getId();
        String string2 = newTask$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$moveTask$1(SqlTaskRepository $this, Task taskToMove$1, Task movedTask$1, Task taskWithOldId) {
        String oldId = taskWithOldId.getId();
        String newId = oldId.replace(taskToMove$1.getId(), movedTask$1.getId());
        $this.taskPersistence().move(oldId, newId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$findAffectedByBlackout$3(Date endDate$1, Task task) {
        TaskStatus taskStatus = task.getStatus();
        TaskStatus taskStatus2 = TaskStatus.PENDING;
        if (taskStatus == null) {
            if (taskStatus2 != null) {
                return false;
            }
        } else if (!taskStatus.equals(taskStatus2)) return false;
        if (!task.isPostponedDueToBlackout()) return false;
        Date date = task.getScheduledStartDate();
        Date date2 = endDate$1;
        if (date == null) {
            if (date2 == null) return true;
            return false;
        } else {
            if (!((Object)date).equals(date2)) return false;
            return true;
        }
    }

    public SqlTaskRepository(ReleasePersistence releasePersistence, DependencyPersistence dependencyPersistence, TaskPersistence taskPersistence, CommentRepository commentRepository, SqlRepositoryAdapter repositoryAdapter, ConfigurationReferencePersistence configurationPersistence, FacetRepositoryDispatcher facetRepositoryDispatcher, SqlBuilder.Dialect dialect) {
        this.releasePersistence = releasePersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.taskPersistence = taskPersistence;
        this.commentRepository = commentRepository;
        this.repositoryAdapter = repositoryAdapter;
        this.configurationPersistence = configurationPersistence;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.dialect = dialect;
        TaskRepository.$init$((TaskRepository)this);
        BaseReleaseItemRepository.$init$(this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        Logging.$init$((Logging)this);
    }
}

