/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql.persistence;

import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.SecurableSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.Token$;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow$Root$;
import com.xebialabs.xlrelease.utils.FolderId;
import java.io.Serializable;
import java.util.UUID;
import org.springframework.jdbc.core.RowMapper;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;

public final class FindDescendantsQueryBuilder$
implements SecurableSqlBuilder {
    public static final FindDescendantsQueryBuilder$ MODULE$ = new FindDescendantsQueryBuilder$();
    private static final String selectDescendants;
    private static final String descendantsOf;
    private static final String parentOf;
    private static final String folderIdCondition;
    private static final String folderUidCondition;
    private static final String findAncestorById;
    private static final String findAncestorByUid;
    private static final String grouped;
    private static final String topDownOrder;
    private static final RowMapper<FolderRow> toFolderData;

    static {
        SecurableSqlBuilder.$init$(MODULE$);
        selectDescendants = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(160).append("\n       | SELECT\n       |   d.").append(Schema.VIEW$.MODULE$.FOLDER_ID()).append(",\n       |   d.").append(Schema.VIEW$.MODULE$.FOLDER_PATH()).append(",\n       |   d.").append(Schema.VIEW$.MODULE$.DESCENDANT_UID()).append(",\n       |   d.").append(Schema.VIEW$.MODULE$.SECURITY_UID()).append(",\n       |   d.").append(Schema.VIEW$.MODULE$.TOKEN()).append(",\n       |   d.").append(Schema.VIEW$.MODULE$.NAME()).append(",\n       |   p.").append(Schema.PATHS$.MODULE$.ANCESTOR_UID()).append(",\n       |   d.").append(Schema.VIEW$.MODULE$.DEPTH()).append("\n       | FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" f\n       ").toString()));
        descendantsOf = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(69).append("\n       | JOIN ").append(Schema.VIEW$.MODULE$.TABLE()).append(" d\n       |    ON ( d.").append(Schema.VIEW$.MODULE$.ANCESTOR_UID()).append(" = f.").append(Schema.FOLDERS$.MODULE$.CI_UID()).append(" AND d.").append(Schema.PATHS$.MODULE$.DEPTH()).append(" <= :depth )\n       ").toString()));
        parentOf = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(137).append("\n       | JOIN ").append(Schema.PATHS$.MODULE$.TABLE()).append(" p\n       |    ON  ( p.").append(Schema.PATHS$.MODULE$.DESCENDANT_UID()).append(" = d.").append(Schema.VIEW$.MODULE$.DESCENDANT_UID()).append("\n       |          AND (     p.").append(Schema.PATHS$.MODULE$.DEPTH()).append(" = 1\n       |               OR ( p.").append(Schema.PATHS$.MODULE$.DEPTH()).append(" = 0 AND p.").append(Schema.PATHS$.MODULE$.ANCESTOR_UID()).append(" = ").append(FolderRow$Root$.MODULE$.uid()).append(" ) ) )\n       ").toString()));
        folderIdCondition = new StringBuilder(14).append("f.").append(Schema.FOLDERS$.MODULE$.FOLDER_ID()).append(" = :folderId").toString();
        folderUidCondition = new StringBuilder(11).append("f.").append(Schema.FOLDERS$.MODULE$.CI_UID()).append(" = :ciUid").toString();
        findAncestorById = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(24).append("\n       | WHERE ").append(MODULE$.folderIdCondition()).append("\n       ").toString()));
        findAncestorByUid = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(24).append("\n       | WHERE ").append(MODULE$.folderUidCondition()).append("\n       ").toString()));
        grouped = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(137).append("\n       | GROUP BY\n       |  d.").append(Schema.VIEW$.MODULE$.DESCENDANT_UID()).append(",\n       |  p.").append(Schema.PATHS$.MODULE$.ANCESTOR_UID()).append(",\n       |  d.").append(Schema.VIEW$.MODULE$.SECURITY_UID()).append(",\n       |  d.").append(Schema.VIEW$.MODULE$.TOKEN()).append(",\n       |  d.").append(Schema.VIEW$.MODULE$.FOLDER_PATH()).append(",\n       |  d.").append(Schema.VIEW$.MODULE$.FOLDER_ID()).append(",\n       |  d.").append(Schema.VIEW$.MODULE$.NAME()).append(",\n       |  d.").append(Schema.VIEW$.MODULE$.DEPTH()).append("\n       ").toString()));
        topDownOrder = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(100).append("\n       | ORDER BY\n       |   d.").append(Schema.VIEW$.MODULE$.DEPTH()).append(" ASC,\n       |   d.").append(Schema.VIEW$.MODULE$.NAME()).append(" ASC,\n       |   p.").append(Schema.PATHS$.MODULE$.ANCESTOR_UID()).append(" ASC,\n       |   d.").append(Schema.VIEW$.MODULE$.DESCENDANT_UID()).append(" ASC\n      ").toString()));
        toFolderData = Utils$.MODULE$.rowMapper((Function1 & Serializable)rs -> {
            int uid = rs.getInt(Schema.VIEW$.MODULE$.DESCENDANT_UID());
            return BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)uid), (Object)FolderRow$Root$.MODULE$.uid()) ? FolderRow$Root$.MODULE$ : new FolderRow.FolderEntry(Predef$.MODULE$.int2Integer(uid), (UUID)Token$.MODULE$.fromString(rs.getString(Schema.VIEW$.MODULE$.TOKEN())).get(), Predef$.MODULE$.int2Integer(rs.getInt(Schema.VIEW$.MODULE$.SECURITY_UID())), new FolderId(rs.getString(Schema.VIEW$.MODULE$.FOLDER_PATH())).$div(rs.getString(Schema.VIEW$.MODULE$.FOLDER_ID())), rs.getString(Schema.VIEW$.MODULE$.NAME()), Predef$.MODULE$.int2Integer(rs.getInt(Schema.PATHS$.MODULE$.ANCESTOR_UID())), rs.getInt(Schema.VIEW$.MODULE$.DEPTH()));
        });
    }

    @Override
    public String selectCiIdsWithPermission(Iterable<String> principalNames, Iterable<String> roleIds) {
        return SecurableSqlBuilder.selectCiIdsWithPermission$(this, principalNames, roleIds);
    }

    @Override
    public String selectCiIdsWithPermissions(Iterable<String> permissionNames, Iterable<String> principalNames, Iterable<String> roleIds) {
        return SecurableSqlBuilder.selectCiIdsWithPermissions$(this, permissionNames, principalNames, roleIds);
    }

    @Override
    public String selectCiIdsWithPermission(boolean hasRoles) {
        return SecurableSqlBuilder.selectCiIdsWithPermission$(this, hasRoles);
    }

    private String selectDescendants() {
        return selectDescendants;
    }

    private String descendantsOf() {
        return descendantsOf;
    }

    private String parentOf() {
        return parentOf;
    }

    private String findAncestorWithPermission(String folderCondition, boolean hasRoles) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(215).append("\n       | WHERE\n       |    ").append(folderCondition).append("\n       | AND (\n       |            f.").append(Schema.FOLDERS$.MODULE$.FOLDER_ID()).append(" = d.").append(Schema.VIEW$.MODULE$.FOLDER_ID()).append("\n       |        OR (\n       |              d.").append(Schema.VIEW$.MODULE$.SECURITY_UID()).append(" IN (\n       |                  ").append(this.selectCiIdsWithPermission(hasRoles)).append("\n       |              )\n       |           )\n       |     )\n     ").toString()));
    }

    private String folderIdCondition() {
        return folderIdCondition;
    }

    private String folderUidCondition() {
        return folderUidCondition;
    }

    private String findAncestorByIdAndPermission(boolean hasRoles) {
        return this.findAncestorWithPermission(this.folderIdCondition(), hasRoles);
    }

    private String findAncestorById() {
        return findAncestorById;
    }

    private String findAncestorByUidAndPermission(boolean hasRoles) {
        return this.findAncestorWithPermission(this.folderUidCondition(), hasRoles);
    }

    private String findAncestorByUid() {
        return findAncestorByUid;
    }

    private String grouped() {
        return grouped;
    }

    private String topDownOrder() {
        return topDownOrder;
    }

    public RowMapper<FolderRow> toFolderData() {
        return toFolderData;
    }

    public String findByUid() {
        return StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(this.selectDescendants()), this.descendantsOf())), this.parentOf())), this.findAncestorByUid())), this.grouped())), this.topDownOrder());
    }

    public String findByUidHavingPermission(boolean hasRoles) {
        return StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(this.selectDescendants()), this.descendantsOf())), this.parentOf())), this.findAncestorByUidAndPermission(hasRoles))), this.grouped())), this.topDownOrder());
    }

    public String findById() {
        return StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(this.selectDescendants()), this.descendantsOf())), this.parentOf())), this.findAncestorById())), this.grouped())), this.topDownOrder());
    }

    public String findByIdHavingPermission(boolean hasRoles) {
        return StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(this.selectDescendants()), this.descendantsOf())), this.parentOf())), this.findAncestorByIdAndPermission(hasRoles))), this.grouped())), this.topDownOrder());
    }

    private FindDescendantsQueryBuilder$() {
    }
}

