/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache$;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.internal.ReleaseGlobalAndFolderVariablesDecorator$;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.service.SqlTasksFilterSupport$;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.service.TaskSearchService;
import com.xebialabs.xlrelease.views.ReleaseTasks;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.TaskSearchView;
import com.xebialabs.xlrelease.views.TasksFilters;
import com.xebialabs.xlrelease.views.converters.TasksViewConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\t-a\u0001B\u000b\u0017\u0001}A\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011!\u0019\u0006A!A!\u0002\u0013!\u0006\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0011B0\t\u0011\t\u0004!\u0011!Q\u0001\n\rD\u0001B\u001a\u0001\u0003\u0006\u0004%\ta\u001a\u0005\tY\u0002\u0011\t\u0011)A\u0005Q\"AQ\u000e\u0001BC\u0002\u0013\ra\u000e\u0003\u0005s\u0001\t\u0005\t\u0015!\u0003p\u0011!\u0019\bA!b\u0001\n\u0007!\b\"CA\r\u0001\t\u0005\t\u0015!\u0003v\u0011\u001d\tY\u0002\u0001C\u0001\u0003;A\u0011\"!\u000e\u0001\u0005\u0004%I!a\u000e\t\u0011\u0005\u0015\u0003\u0001)A\u0005\u0003sAq!a\u0012\u0001\t\u0003\nI\u0005C\u0004\u0002~\u0001!I!a \t\u000f\u0005e\u0006\u0001\"\u0003\u0002<\"9\u0011Q\u001d\u0001\u0005\u0002\u0005\u001d(\u0001F*rYR\u000b7o[*fCJ\u001c\u0007nU3sm&\u001cWM\u0003\u0002\u00181\u000591/\u001a:wS\u000e,'BA\r\u001b\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u001c9\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002;\u0005\u00191m\\7\u0004\u0001M!\u0001\u0001\t\u0015-!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0003mC:<'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012aa\u00142kK\u000e$\bCA\u0015+\u001b\u00051\u0012BA\u0016\u0017\u0005E!\u0016m]6TK\u0006\u00148\r[*feZL7-\u001a\t\u0003[Ij\u0011A\f\u0006\u0003_A\nQa\u001d7gi)T\u0011!M\u0001\tOJL'P\u001f7fI&\u00111G\f\u0002\b\u0019><w-\u001b8h\u0003-\u0011x\u000e\\3TKJ4\u0018nY3\u0011\u0005YZT\"A\u001c\u000b\u0005aJ\u0014\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005iR\u0012\u0001\u00033fa2|\u00170\u001b;\n\u0005q:$a\u0003*pY\u0016\u001cVM\u001d<jG\u0016\f\u0011\u0003^1tW\u0006\u001b7-Z:t'\u0016\u0014h/[2f!\tIs(\u0003\u0002A-\t\tB+Y:l\u0003\u000e\u001cWm]:TKJ4\u0018nY3\u0002%Q\f7o[:WS\u0016<8i\u001c8wKJ$XM\u001d\t\u0003\u0007\"k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000b!bY8om\u0016\u0014H/\u001a:t\u0015\t9\u0005$A\u0003wS\u0016<8/\u0003\u0002J\t\n\u0011B+Y:lgZKWm^\"p]Z,'\u000f^3s\u0003A!WmY8sCR|'oU3sm&\u001cW\r\u0005\u0002M#6\tQJ\u0003\u0002O\u001f\u0006A\u0011N\u001c;fe:\fGN\u0003\u0002Q1\u0005\u0019\u0011\r]5\n\u0005Ik%\u0001I%oi\u0016\u0014h.\u00197NKR\fG-\u0019;b\t\u0016\u001cwN]1u_J\u001cVM\u001d<jG\u0016\f!C]3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dKB\u0011Q\u000bX\u0007\u0002-*\u0011q\u000bW\u0001\fa\u0016\u00148/[:uK:\u001cWM\u0003\u0002Z5\u0006\u00191/\u001d7\u000b\u0005mC\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011QL\u0016\u0002\u0013%\u0016dW-Y:f!\u0016\u00148/[:uK:\u001cW-A\buCN\\\u0007+\u001a:tSN$XM\\2f!\t)\u0006-\u0003\u0002b-\nyA+Y:l!\u0016\u00148/[:uK:\u001cW-\u0001\nd_6lWM\u001c;QKJ\u001c\u0018n\u001d;f]\u000e,\u0007CA+e\u0013\t)gK\u0001\nD_6lWM\u001c;QKJ\u001c\u0018n\u001d;f]\u000e,\u0017!\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;feV\t\u0001\u000e\u0005\u0002jU6\t\u0001,\u0003\u0002l1\n!2+\u001d7SKB|7/\u001b;pef\fE-\u00199uKJ\f!C]3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3sA\u0005\u0011\u0002/\u001a:nSN\u001c\u0018n\u001c8F]\u001a|'oY3s+\u0005y\u0007C\u0001\u001cq\u0013\t\txG\u0001\nQKJl\u0017n]:j_:,eNZ8sG\u0016\u0014\u0018a\u00059fe6L7o]5p]\u0016sgm\u001c:dKJ\u0004\u0013AC:rY\u0012K\u0017\r\\3diV\tQ\u000fE\u0002w\u0003'q1a^A\u0007\u001d\rA\u0018\u0011\u0002\b\u0004s\u0006\u0015ab\u0001>\u0002\u00049\u001910!\u0001\u000f\u0005q|X\"A?\u000b\u0005yt\u0012A\u0002\u001fs_>$h(C\u0001\u001e\u0013\tYB$\u0003\u0002\u001a5%\u0019\u0011q\u0001\r\u0002\u0005\u0011\u0014\u0017bA-\u0002\f)\u0019\u0011q\u0001\r\n\t\u0005=\u0011\u0011C\u0001\u000b'Fd')^5mI\u0016\u0014(bA-\u0002\f%!\u0011QCA\f\u0005\u001d!\u0015.\u00197fGRTA!a\u0004\u0002\u0012\u0005Y1/\u001d7ES\u0006dWm\u0019;!\u0003\u0019a\u0014N\\5u}Q1\u0012qDA\u0011\u0003G\t)#a\n\u0002*\u0005-\u0012QFA\u0018\u0003c\t\u0019\u0004\u0005\u0002*\u0001!)AG\u0004a\u0001k!)QH\u0004a\u0001}!)\u0011I\u0004a\u0001\u0005\")!J\u0004a\u0001\u0017\")1K\u0004a\u0001)\")aL\u0004a\u0001?\")!M\u0004a\u0001G\")aM\u0004a\u0001Q\")QN\u0004a\u0002_\")1O\u0004a\u0002k\u0006\u0019R*\u0011-`\u001dVk%)\u0012*`\u001f\u001a{&jT%O'V\u0011\u0011\u0011\b\t\u0005\u0003w\t\t%\u0004\u0002\u0002>)\u0011\u0011qH\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003\u0007\niDA\u0002J]R\fA#T!Y?:+VJQ#S?>3uLS(J\u001dN\u0003\u0013!E4fiR\u000b7o[:CsJ+G.Z1tKR1\u00111JA*\u0003;\u0002B!!\u0014\u0002P5\ta)C\u0002\u0002R\u0019\u0013a\u0002V1tWN+\u0017M]2i-&,w\u000fC\u0004\u0002VE\u0001\r!a\u0016\u0002\u0019Q\f7o[:GS2$XM]:\u0011\t\u00055\u0013\u0011L\u0005\u0004\u000372%\u0001\u0004+bg.\u001ch)\u001b7uKJ\u001c\bbBA0#\u0001\u0007\u0011\u0011M\u0001\u0015Y&l\u0017\u000e\u001e+bg.\u001c\b*\u001b8u\u001fB$\u0018n\u001c8\u0011\u0007\u0005\n\u0019'C\u0002\u0002f\t\u0012q!\u00138uK\u001e,'\u000fK\u0002\u0012\u0003S\u0002B!a\u001b\u0002z5\u0011\u0011Q\u000e\u0006\u0005\u0003_\n\t(\u0001\u0006b]:|G/\u0019;j_:TA!a\u001d\u0002v\u00059Q.\u001a;sS\u000e\u001c(bAA<9\u0005A1m\u001c3bQ\u0006dW-\u0003\u0003\u0002|\u00055$!\u0002+j[\u0016$\u0017\u0001\u0002;j[\u0016,B!!!\u0002\nR!\u00111QAS)\u0011\t))a'\u0011\t\u0005\u001d\u0015\u0011\u0012\u0007\u0001\t\u001d\tYI\u0005b\u0001\u0003\u001b\u0013\u0011!Q\t\u0005\u0003\u001f\u000b)\n\u0005\u0003\u0002<\u0005E\u0015\u0002BAJ\u0003{\u0011qAT8uQ&tw\r\u0005\u0003\u0002<\u0005]\u0015\u0002BAM\u0003{\u00111!\u00118z\u0011!\tiJ\u0005CA\u0002\u0005}\u0015!\u00022m_\u000e\\\u0007CBA\u001e\u0003C\u000b))\u0003\u0003\u0002$\u0006u\"\u0001\u0003\u001fcs:\fW.\u001a \t\u000f\u0005\u001d&\u00031\u0001\u0002*\u0006!A-Z:d!\u0011\tY+a-\u000f\t\u00055\u0016q\u0016\t\u0004y\u0006u\u0012\u0002BAY\u0003{\ta\u0001\u0015:fI\u00164\u0017\u0002BA[\u0003o\u0013aa\u0015;sS:<'\u0002BAY\u0003{\t!c]8si\nK(+\u001a7fCN,G+\u001b;mKR!\u0011QXAh!\u0019\ty,!2\u0002J6\u0011\u0011\u0011\u0019\u0006\u0004\u0003\u0007$\u0013\u0001B;uS2LA!a2\u0002B\n!A*[:u!\u0011\ti%a3\n\u0007\u00055gI\u0001\u0007SK2,\u0017m]3UCN\\7\u000fC\u0004\u0002RN\u0001\r!a5\u0002\u001bI,G.Z1tKN$\u0016m]6t!\u0019\t).a8\u0002J:!\u0011q[An\u001d\ra\u0018\u0011\\\u0005\u0003\u0003\u007fIA!!8\u0002>\u00059\u0001/Y2lC\u001e,\u0017\u0002BAq\u0003G\u00141aU3r\u0015\u0011\ti.!\u0010\u0002\u001bM,\u0017M]2i)\u0006\u001c8.\u00133t)\u0019\tIO!\u0002\u0003\bA1\u0011Q[Ap\u0003W\u0004B!!<\u0002\u0000:!\u0011q^A~\u001d\u0011\t\t0!?\u000f\t\u0005M\u0018q\u001f\b\u0004s\u0006U\u0018BA.\u0019\u0013\tI&,\u0003\u0002X1&\u0019\u0011Q ,\u0002\t\rK\u0017\nZ\u0005\u0005\u0005\u0003\u0011\u0019A\u0001\u0003DS&#'bAA\u007f-\"9\u0011Q\u000b\u000bA\u0002\u0005]\u0003b\u0002B\u0005)\u0001\u0007\u0011\u0011H\u0001\u0006Y&l\u0017\u000e\u001e")
public class SqlTaskSearchService
implements TaskSearchService,
Logging {
    private final RoleService roleService;
    private final TaskAccessService taskAccessService;
    private final TasksViewConverter tasksViewConverter;
    private final InternalMetadataDecoratorService decoratorService;
    private final ReleasePersistence releasePersistence;
    private final TaskPersistence taskPersistence;
    private final CommentPersistence commentPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final PermissionEnforcer permissionEnforcer;
    private final SqlBuilder.Dialect sqlDialect;
    private final int MAX_NUMBER_OF_JOINS;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTaskSearchService sqlTaskSearchService = this;
        synchronized (sqlTaskSearchService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    private int MAX_NUMBER_OF_JOINS() {
        return this.MAX_NUMBER_OF_JOINS;
    }

    @Timed
    public TaskSearchView getTasksByRelease(TasksFilters tasksFilters, Integer limitTasksHintOption) {
        int limit = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)limitTasksHintOption).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 30));
        scala.collection.immutable.Seq taskIds = (scala.collection.immutable.Seq)this.time("finding task ids", (Function0 & Serializable)() -> this.searchTaskIds(tasksFilters, limit));
        scala.collection.immutable.Seq releaseIds = (scala.collection.immutable.Seq)((SeqOps)taskIds.map((Function1 & Serializable)x$1 -> Ids.releaseIdFrom((String)x$1))).distinct();
        this.logger().debug((Function0 & Serializable)() -> "Found " + taskIds.size() + " tasks in " + releaseIds.size() + " releases for user " + Permissions.getAuthenticatedUserName());
        List allowedTaskTypesForAuthenticatedUser = (List)this.time("fetching allowed task types for authenticated user", (Function0 & Serializable)() -> $this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser());
        scala.collection.immutable.Seq releasesTasks = releaseIds.nonEmpty() ? (scala.collection.immutable.Seq)this.time("total time to create releasesTasks", (Function0 & Serializable)() -> {
            DecoratorsCache decoratorsCache = new DecoratorsCache(DecoratorsCache$.MODULE$.$lessinit$greater$default$1());
            Tuple2 queryReleases = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withReleaseIds((scala.collection.immutable.Seq<String>)releaseIds).build();
            scala.collection.immutable.Seq releases = (scala.collection.immutable.Seq)((IterableOps)this.time("de-serializing releases", (Function0 & Serializable)() -> (scala.collection.immutable.Seq)$this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)queryReleases).map((Function1 & Serializable)releaseData -> this.repositoryAdapter().tryDeserialize((ReleaseRow)releaseData)))).flatten(Predef$.MODULE$.$conforms());
            $this.decoratorService.decorate((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)releases).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ReleaseGlobalAndFolderVariablesDecorator$.MODULE$.GLOBAL_AND_FOLDER_VARIABLES(), EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY()}))).asJava(), decoratorsCache);
            Map<String, Object> commentsByTasks = $this.commentPersistence.countByTasks((scala.collection.immutable.Seq<Integer>)((scala.collection.immutable.Seq)releases.map((Function1 & Serializable)x$2 -> x$2.getCiUid())));
            return (scala.collection.immutable.Seq)releases.map((Function1 & Serializable)release -> {
                Buffer orderedTasks = (Buffer)((IterableOps)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().filter((Function1 & Serializable)task -> BoxesRunTime.boxToBoolean((boolean)taskIds.exists((Function1 & Serializable)foundId -> BoxesRunTime.boxToBoolean((boolean)SqlTaskSearchService.$anonfun$getTasksByRelease$13(task, foundId)))))).sortBy((Function1 & Serializable)task -> BoxesRunTime.boxToInteger((int)taskIds.indexWhere((Function1 & Serializable)id -> BoxesRunTime.boxToBoolean((boolean)SqlTaskSearchService.$anonfun$getTasksByRelease$15(task, id)))), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable)task -> {
                    TaskFullView fullView = $this.tasksViewConverter.toFullView(task, allowedTaskTypesForAuthenticatedUser);
                    fullView.setNumberOfComments(BoxesRunTime.unboxToInt((Object)commentsByTasks.getOrElse((Object)Ids.getFolderlessId((String)fullView.getId()), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)));
                    return fullView;
                });
                return new ReleaseTasks(release, CollectionConverters$.MODULE$.BufferHasAsJava(orderedTasks).asJava());
            });
        }) : (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        return new TaskSearchView(this.sortByReleaseTitle((scala.collection.immutable.Seq<ReleaseTasks>)releasesTasks), taskIds.size() >= limit);
    }

    private <A> A time(String desc, Function0<A> block) {
        long startTime = System.currentTimeMillis();
        Object res = block.apply();
        long endTime = System.currentTimeMillis();
        long total = endTime - startTime;
        this.logger().trace((Function0 & Serializable)() -> "TIME: " + desc + " took " + total);
        return (A)res;
    }

    private List<ReleaseTasks> sortByReleaseTitle(scala.collection.immutable.Seq<ReleaseTasks> releasesTasks) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)releasesTasks.sortBy((Function1 & Serializable)releaseTasks -> (String)Option$.MODULE$.apply((Object)releaseTasks.getTitle()).getOrElse((Function0 & Serializable)() -> ""), (Ordering)Ordering.String$.MODULE$)).asJava();
    }

    public scala.collection.immutable.Seq<String> searchTaskIds(TasksFilters tasksFilters, int limit) {
        LinkedHashSet taskIds = (LinkedHashSet)((IterableOps)((IterableOps)SqlTaskSearchService.getPrincipals$1().$plus$plus((IterableOnce)this.getRoleIds$1())).grouped(this.sqlDialect().maxQueryParams() / this.MAX_NUMBER_OF_JOINS()).foldLeft((Object)LinkedHashSet$.MODULE$.empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            LinkedHashSet linkedHashSet;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                LinkedHashSet acc = (LinkedHashSet)tuple2._1();
                Iterable group = (Iterable)tuple2._2();
                if (acc.size() < limit) {
                    scala.collection.immutable.Seq newBatch = this.doSearch$1((scala.collection.immutable.Seq)SqlTaskSearchService.getPrincipalsFromGroup$1().apply((Object)group), (scala.collection.immutable.Seq)SqlTaskSearchService.getRoleIdsFromGroup$1().apply((Object)group), tasksFilters, limit);
                    linkedHashSet = (LinkedHashSet)acc.$plus$plus((IterableOnce)newBatch);
                } else {
                    linkedHashSet = acc;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            LinkedHashSet linkedHashSet2 = linkedHashSet;
            return linkedHashSet2;
        })).take(limit);
        this.logger().debug((Function0 & Serializable)() -> tasksFilters + ": results " + taskIds.size());
        return taskIds.toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$getTasksByRelease$13(Task task$1, String foundId) {
        return task$1.getId().endsWith(foundId);
    }

    public static final /* synthetic */ boolean $anonfun$getTasksByRelease$15(Task task$2, String id) {
        return task$2.getId().startsWith(id);
    }

    private static final Function1 getPrincipalsFromGroup$1() {
        return (Function1 & Serializable)x$3 -> ((IterableOnceOps)x$3.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Either<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Left) {
                    Left left = (Left)A1;
                    String id = (String)left.value();
                    object = id;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Either<String, String> x1) {
                Either<String, String> either = x1;
                boolean bl = either instanceof Left;
                return bl;
            }
        })).toSeq();
    }

    private static final Function1 getRoleIdsFromGroup$1() {
        return (Function1 & Serializable)x$4 -> ((IterableOnceOps)x$4.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Either<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Right) {
                    Right right = (Right)A1;
                    String id = (String)right.value();
                    object = id;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Either<String, String> x1) {
                Either<String, String> either = x1;
                boolean bl = either instanceof Right;
                return bl;
            }
        })).toSeq();
    }

    private final scala.collection.immutable.Seq doSearch$1(scala.collection.immutable.Seq principals, scala.collection.immutable.Seq roleIds, TasksFilters tasksFilters$2, int limit$2) {
        this.logger().info((Function0 & Serializable)() -> tasksFilters$2 + ": Searching with " + principals.length() + " principals and " + roleIds.length() + " roles");
        Tuple2 tasksQuery = SqlTasksFilterSupport$.MODULE$.sqlBuilderByFilters(tasksFilters$2, (Iterable<String>)principals, (Iterable<String>)roleIds, SqlTasksFilterSupport$.MODULE$.sqlBuilderByFilters$default$4(), this.permissionEnforcer(), this.sqlDialect()).limit(limit$2).build();
        return this.taskPersistence.findTaskIdsByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)tasksQuery);
    }

    private static final Iterable getPrincipals$1() {
        return (Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala().map((Function1 & Serializable)value -> package$.MODULE$.Left().apply(value));
    }

    private final Buffer getRoleIds$1() {
        return (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(this.roleService.getRolesFor(Permissions.getAuthentication())).asScala().map((Function1 & Serializable)x$5 -> x$5.getId())).map((Function1 & Serializable)value -> package$.MODULE$.Right().apply(value));
    }

    public SqlTaskSearchService(RoleService roleService, TaskAccessService taskAccessService, TasksViewConverter tasksViewConverter, InternalMetadataDecoratorService decoratorService, ReleasePersistence releasePersistence, TaskPersistence taskPersistence, CommentPersistence commentPersistence, SqlRepositoryAdapter repositoryAdapter, PermissionEnforcer permissionEnforcer, SqlBuilder.Dialect sqlDialect) {
        this.roleService = roleService;
        this.taskAccessService = taskAccessService;
        this.tasksViewConverter = tasksViewConverter;
        this.decoratorService = decoratorService;
        this.releasePersistence = releasePersistence;
        this.taskPersistence = taskPersistence;
        this.commentPersistence = commentPersistence;
        this.repositoryAdapter = repositoryAdapter;
        this.permissionEnforcer = permissionEnforcer;
        this.sqlDialect = sqlDialect;
        Logging.$init$((Logging)this);
        this.MAX_NUMBER_OF_JOINS = 5;
    }
}

