/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql.persistence;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.package;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.TasksSqlBuilder$;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.security.sql.db.SecuritySchema;
import com.xebialabs.xlrelease.utils.DateVariableUtils;
import java.io.Serializable;
import java.util.Date;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Growable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Ew!\u0002\u0011\"\u0011\u0003qc!\u0002\u0019\"\u0011\u0003\t\u0004\"\u0002\u001d\u0002\t\u0003I\u0004\"\u0002\u001e\u0002\t\u0003Y\u0004\"\u0002'\u0002\t\u0003ie\u0001\u0002\u0019\"\u0001AC\u0011\"W\u0003\u0003\u0002\u0003\u0006YAW6\t\u000ba*A\u0011\u00017\t\u000b=,A\u0011\u00019\t\u000bE,A\u0011\u0001:\t\u000f\u00055Q\u0001\"\u0001\u0002\u0010!9\u0011QF\u0003\u0005\u0002\u0005=\u0002bBA\u001c\u000b\u0011\u0005\u0011\u0011\b\u0005\b\u0003\u000b*A\u0011AA$\u0011\u001d\ti%\u0002C\u0001\u0003\u001fBq!!\u001b\u0006\t\u0003\tY\u0007C\u0004\u0002r\u0015!\t!a\u001d\t\u000f\u0005]T\u0001\"\u0001\u0002z!9\u0011qP\u0003\u0005\u0002\u0005\u0005\u0005bBAG\u000b\u0011\u0005\u0011q\u0012\u0005\b\u0003/+A\u0011AAM\u0011\u0019\tI+\u0002C\u0001a\"1\u00111V\u0003\u0005\u0002ADq!!,\u0006\t\u0013\ty\u000bC\u0004\u00028\u0016!I!!/\t\u000f\u0005\u0005W\u0001\"\u0003\u0002:\"9\u00111Y\u0003\u0005\n\u0005e\u0006bBAc\u000b\u0011%\u0011\u0011\u0018\u0005\b\u0003\u000f,A\u0011BA]\u0011\u001d\tI-\u0002C\u0005\u0003sCq!a3\u0006\t\u0013\tI\fC\u0004\u0002N\u0016!\t%a4\u0002\u001fQ\u000b7o[:Tc2\u0014U/\u001b7eKJT!AI\u0012\u0002\u0017A,'o]5ti\u0016t7-\u001a\u0006\u0003I\u0015\n1a]9m\u0015\t1s%\u0001\u0006sKB|7/\u001b;pefT!\u0001K\u0015\u0002\u0013ad'/\u001a7fCN,'B\u0001\u0016,\u0003%AXMY5bY\u0006\u00147OC\u0001-\u0003\r\u0019w.\\\u0002\u0001!\ty\u0013!D\u0001\"\u0005=!\u0016m]6t'Fd')^5mI\u0016\u00148CA\u00013!\t\u0019d'D\u00015\u0015\u0005)\u0014!B:dC2\f\u0017BA\u001c5\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012AL\u0001\u000e]>\u0014X.\u00197ju\u0016$\u0016mZ:\u0015\u0005qR\u0005cA\u001fE\u000f:\u0011aH\u0011\t\u0003\u007fQj\u0011\u0001\u0011\u0006\u0003\u00036\na\u0001\u0010:p_Rt\u0014BA\"5\u0003\u0019\u0001&/\u001a3fM&\u0011QI\u0012\u0002\u0004'\u0016$(BA\"5!\ti\u0004*\u0003\u0002J\r\n11\u000b\u001e:j]\u001eDQaS\u0002A\u0002q\nA\u0001^1hg\u0006aan\u001c:nC2L'0\u001a+bOR\u0011qI\u0014\u0005\u0006\u001f\u0012\u0001\raR\u0001\u0004i\u0006<7CA\u0003R!\r\u0011f\u000bW\u0007\u0002'*\u0011A\u0005\u0016\u0006\u0003+\u001e\n!\u0001\u001a2\n\u0005]\u001b&AC*rY\n+\u0018\u000e\u001c3feB\u0011q&B\u0001\bI&\fG.Z2u!\tY\u0006N\u0004\u0002]M:\u0011Q,\u001a\b\u0003=\u0012t!aX2\u000f\u0005\u0001\u0014gBA b\u0013\u0005a\u0013B\u0001\u0016,\u0013\tA\u0013&\u0003\u0002VO%\u0011A\u0005V\u0005\u0003ON\u000b!bU9m\u0005VLG\u000eZ3s\u0013\tI'NA\u0004ES\u0006dWm\u0019;\u000b\u0005\u001d\u001c\u0016BA-W)\u0005iGC\u0001-o\u0011\u0015Iv\u0001q\u0001[\u00031\u0019X\r\\3diR\u000b7o[%e)\u0005A\u0016\u0001G<ji\"|e.Z(g%\u0016dW-Y:f'R\fG/^:fgR\u0011\u0001l\u001d\u0005\u0006i&\u0001\r!^\u0001\tgR\fG/^:fgB\u0019ao\u001f@\u000f\u0005]LhBA y\u0013\u0005)\u0014B\u0001>5\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001`?\u0003\u0007M+\u0017O\u0003\u0002{iA\u0019q0!\u0003\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\taa\u001d;biV\u001c(bAA\u0004O\u00051Am\\7bS:LA!a\u0003\u0002\u0002\ti!+\u001a7fCN,7\u000b^1ukN\fqb^5uQR\u000b7o\u001b+za\u0016tu\u000e\u001e\u000b\u00041\u0006E\u0001bBA\n\u0015\u0001\u0007\u0011QC\u0001\ti\u0006\u001c8\u000eV=qKB!\u0011qCA\u0015\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005u\u0011a\u0002:fM2,7\r\u001e\u0006\u0005\u0003?\t\t#A\u0002ba&TA!a\t\u0002&\u00051\u0001\u000f\\;hS:T1!a\n*\u0003!!W\r\u001d7ps&$\u0018\u0002BA\u0016\u00033\u0011A\u0001V=qK\u0006iq/\u001b;i)\u0006\u001c8\u000eV=qKN$2\u0001WA\u0019\u0011\u001d\t\u0019d\u0003a\u0001\u0003k\t\u0011\u0002^1tWRK\b/Z:\u0011\tY\\\u0018QC\u0001\u0016o&$\bn\u00148f\u001f\u001a$\u0016m]6Ti\u0006$Xo]3t)\rA\u00161\b\u0005\u0007i2\u0001\r!!\u0010\u0011\tY\\\u0018q\b\t\u0004\u007f\u0006\u0005\u0013\u0002BA\"\u0003\u0003\u0011!\u0002V1tWN#\u0018\r^;t\u0003)9\u0018\u000e\u001e5GS2$XM\u001d\u000b\u00041\u0006%\u0003BBA&\u001b\u0001\u0007q)\u0001\u0004gS2$XM]\u0001\no&$\b\u000eR1uKN$R\u0001WA)\u0003KBq!a\u0015\u000f\u0001\u0004\t)&\u0001\u0003ge>l\u0007\u0003BA,\u0003Cj!!!\u0017\u000b\t\u0005m\u0013QL\u0001\u0005kRLGN\u0003\u0002\u0002`\u0005!!.\u0019<b\u0013\u0011\t\u0019'!\u0017\u0003\t\u0011\u000bG/\u001a\u0005\b\u0003Or\u0001\u0019AA+\u0003\t!x.\u0001\fxSRD7k\u00195fIVdW\rZ*uCJ$H)\u0019;f)\rA\u0016Q\u000e\u0005\b\u0003_z\u0001\u0019AA+\u0003\u0011!\u0017\r^3\u0002\u001b]LG\u000f[!os>3G+Y4t)\rA\u0016Q\u000f\u0005\u0006\u0017B\u0001\r\u0001P\u0001\u000eo&$\bNR8mI\u0016\u0014\u0018\nZ:\u0015\u0007a\u000bY\b\u0003\u0004\u0002~E\u0001\r\u0001P\u0001\nM>dG-\u001a:JIN\f\u0001c^5uQ\u0006\u001b8/[4oK\u0012$v.T3\u0015\u0007a\u000b\u0019\tC\u0004\u0002\u0006J\u0001\r!a\"\u0002\u0015A\u0014\u0018N\\2ja\u0006d7\u000f\u0005\u0003w\u0003\u0013;\u0015bAAF{\nA\u0011\n^3sC\ndW-A\rxSRD\u0017i]:jO:,G\rV8NK>\u0013X*\u001f+fC6\u001cH#\u0002-\u0002\u0012\u0006M\u0005bBAC'\u0001\u0007\u0011q\u0011\u0005\b\u0003+\u001b\u0002\u0019AAD\u0003\u001d\u0011x\u000e\\3JIN\fQc^5uQ\u0006\u001b8/[4oK\u0012$v.\u00118zE>$\u0017\u0010F\u0004Y\u00037\u000bi*a(\t\u000f\u0005\u0015E\u00031\u0001\u0002\b\"9\u0011Q\u0013\u000bA\u0002\u0005\u001d\u0005bBAQ)\u0001\u0007\u00111U\u0001\bSN\fE-\\5o!\r\u0019\u0014QU\u0005\u0004\u0003O#$a\u0002\"p_2,\u0017M\\\u0001\u000eo&$\b.\u00118z\r\u0006\u001cW\r^:\u0002\u001b=\u0014H-\u001a:CsR\u000b7o[%e\u0003\u001d\u0011\u0017N\u001c3j]\u001e$2aRAY\u0011\u001d\t\u0019l\u0006a\u0001\u0003k\u000baA^1mk\u0016\u001c\b\u0003\u0002<\u0002\nJ\n\u0011B[8j]R+\u0017-\\:\u0015\u0005\u0005m\u0006cA\u001a\u0002>&\u0019\u0011q\u0018\u001b\u0003\tUs\u0017\u000e^\u0001\u0011U>Lg\u000eV3b[N$v\u000eV1tWN\fQB[8j]R+\u0017-\u001c*pY\u0016\u001c\u0018A\u00056pS:$V-Y7Qe&t7-\u001b9bYN\f1C[8j]R+\u0017-\u001c)fe6L7o]5p]N\f1B[8j]\u001a{G\u000eZ3sg\u0006Q!n\\5o\r\u0006\u001cW\r^:\u0002\u00179,w/\u00138ti\u0006t7-Z\u000b\u00021\u0002")
public class TasksSqlBuilder
extends SqlBuilder<TasksSqlBuilder> {
    public static String normalizeTag(String tag) {
        return TasksSqlBuilder$.MODULE$.normalizeTag(tag);
    }

    public static Set<String> normalizeTags(Set<String> tags) {
        return TasksSqlBuilder$.MODULE$.normalizeTags(tags);
    }

    public TasksSqlBuilder selectTaskId() {
        return (TasksSqlBuilder)super.select(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT\n         |  DISTINCT tasks." + Schema.TASKS$.MODULE$.TASK_ID() + "\n         |FROM\n         |  " + Schema.TASKS$.MODULE$.TABLE() + " tasks\n         |  JOIN " + Schema.RELEASES$.MODULE$.TABLE() + " releases ON tasks." + Schema.TASKS$.MODULE$.RELEASE_UID() + " = releases." + Schema.RELEASES$.MODULE$.CI_UID() + "\n         ")));
    }

    public TasksSqlBuilder withOneOfReleaseStatuses(Seq<ReleaseStatus> statuses) {
        Object object = statuses.nonEmpty() ? this.conditions().$plus$eq((Object)new package.Sql("releases." + Schema.RELEASES$.MODULE$.STATUS() + " IN (" + this.binding((Iterable<Object>)statuses) + ")", (Iterable)statuses.map((Function1 & Serializable)x$1 -> x$1.value()))) : BoxedUnit.UNIT;
        return this;
    }

    public TasksSqlBuilder withTaskTypeNot(Type taskType) {
        this.conditions().$plus$eq((Object)new package.Sql("tasks." + Schema.TASKS$.MODULE$.TASK_TYPE() + " != ?", (Iterable)new .colon.colon((Object)taskType.toString(), (List)Nil$.MODULE$)));
        return this;
    }

    public TasksSqlBuilder withTaskTypes(Seq<Type> taskTypes) {
        this.conditions().$plus$eq((Object)new package.Sql("tasks." + Schema.TASKS$.MODULE$.TASK_TYPE() + " IN (" + this.binding((Iterable<Object>)taskTypes) + ")", (Iterable)taskTypes.map((Function1 & Serializable)x$2 -> x$2.toString())));
        return this;
    }

    public TasksSqlBuilder withOneOfTaskStatuses(Seq<TaskStatus> statuses) {
        Object object = statuses.nonEmpty() ? this.conditions().$plus$eq((Object)new package.Sql("tasks." + Schema.TASKS$.MODULE$.STATUS() + " IN (" + this.binding((Iterable<Object>)statuses) + ")", (Iterable)statuses.map((Function1 & Serializable)x$3 -> x$3.value()))) : BoxedUnit.UNIT;
        return this;
    }

    public TasksSqlBuilder withFilter(String filter) {
        Object object = filter != null ? this.likeOr((Seq)new .colon.colon((Object)("tasks." + Schema.TASKS$.MODULE$.TITLE()), (List)new .colon.colon((Object)("tasks." + Schema.TASKS$.MODULE$.OWNER()), (List)new .colon.colon((Object)("tasks." + Schema.TASKS$.MODULE$.TEAM()), (List)new .colon.colon((Object)("releases." + Schema.RELEASES$.MODULE$.RELEASE_TITLE()), (List)Nil$.MODULE$)))), filter) : BoxedUnit.UNIT;
        return this;
    }

    public TasksSqlBuilder withDates(Date from, Date to) {
        Object object;
        if (from != null && to != null) {
            object = this.conditions().$plus$eq((Object)new package.Sql("(? <= tasks." + Schema.TASKS$.MODULE$.START_DATE() + " OR ? <= tasks." + Schema.TASKS$.MODULE$.END_DATE() + ") AND tasks." + Schema.TASKS$.MODULE$.START_DATE() + " < ?", (Iterable)new .colon.colon((Object)from, (List)new .colon.colon((Object)from, (List)new .colon.colon((Object)to, (List)Nil$.MODULE$)))));
        } else {
            Object object2 = from != null ? this.conditions().$plus$eq((Object)new package.Sql("(? <= tasks." + Schema.TASKS$.MODULE$.START_DATE() + " OR ? <= tasks." + Schema.TASKS$.MODULE$.END_DATE() + ")", (Iterable)new .colon.colon((Object)from, (List)new .colon.colon((Object)from, (List)Nil$.MODULE$)))) : BoxedUnit.UNIT;
            object = to != null ? this.conditions().$plus$eq((Object)new package.Sql("tasks." + Schema.TASKS$.MODULE$.START_DATE() + " < ?", (Iterable)new .colon.colon((Object)to, (List)Nil$.MODULE$))) : BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withScheduledStartDate(Date date) {
        this.conditions().$plus$eq((Object)new package.Sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |tasks." + Schema.TASKS$.MODULE$.START_DATE() + " = ?\n         |")), (Iterable)new .colon.colon((Object)new Date(Predef$.MODULE$.Long2long(DateVariableUtils.truncateMilliseconds((Long)Predef$.MODULE$.long2Long(date.getTime())))), (List)Nil$.MODULE$)));
        return this;
    }

    public TasksSqlBuilder withAnyOfTags(Set<String> tags) {
        BoxedUnit boxedUnit;
        Set<String> normalizedTags = TasksSqlBuilder$.MODULE$.normalizeTags(tags);
        if (normalizedTags.nonEmpty()) {
            String sql = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |tasks." + Schema.TASKS$.MODULE$.CI_UID() + " IN (\n           |  SELECT DISTINCT task_tags." + Schema.TASK_TAGS$.MODULE$.CI_UID() + "\n           |  FROM " + Schema.TASK_TAGS$.MODULE$.TABLE() + " task_tags\n           |  WHERE task_tags." + Schema.TASK_TAGS$.MODULE$.VALUE() + " IN (" + this.binding((Iterable<Object>)normalizedTags) + ")\n           |)\n           |"));
            boxedUnit = this.conditions().$plus$eq((Object)new package.Sql(sql, normalizedTags));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withFolderIds(Set<String> folderIds) {
        BoxedUnit boxedUnit;
        Set normalizedFolderIds = (Set)folderIds.map((Function1 & Serializable)x$1 -> Ids.getName((String)x$1));
        if (normalizedFolderIds.nonEmpty()) {
            this.joinFolders();
            boxedUnit = this.conditions().$plus$eq((Object)new package.Sql("folders." + Schema.FOLDERS$.MODULE$.FOLDER_ID() + " IN (" + this.binding((Iterable<Object>)normalizedFolderIds) + ")", (Iterable)normalizedFolderIds));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withAssignedToMe(Iterable<String> principals) {
        BoxedUnit boxedUnit;
        if (principals.nonEmpty()) {
            boxedUnit = this.conditions().$plus$eq((Object)new package.Sql("LOWER(tasks." + Schema.TASKS$.MODULE$.OWNER() + ") IN (" + this.binding(principals) + ")", (Iterable)principals.map((Function1 & Serializable)x$4 -> x$4.toLowerCase())));
        } else {
            this.nothingToBeFound_$eq(true);
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withAssignedToMeOrMyTeams(Iterable<String> principals, Iterable<String> roleIds) {
        this.joinTeamsToTasks();
        Seq orConditions = (Seq)Nil$.MODULE$;
        if (principals.nonEmpty()) {
            orConditions = (Seq)orConditions.$plus$plus((IterableOnce)new .colon.colon((Object)new package.Sql("LOWER(tasks." + Schema.TASKS$.MODULE$.OWNER() + ") IN (" + this.binding(principals) + ")", (Iterable)principals.map((Function1 & Serializable)x$5 -> x$5.toLowerCase())), (List)Nil$.MODULE$));
            orConditions = (Seq)orConditions.$plus$plus((IterableOnce)new .colon.colon((Object)new package.Sql("teams." + SecuritySchema.ROLES$.MODULE$.id() + " IN (SELECT " + SecuritySchema.ROLE_PRINCIPALS$.MODULE$.roleId() + " FROM " + SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE() + " assignedToMeOrTeamsPrincipals WHERE " + SecuritySchema.ROLE_PRINCIPALS$.MODULE$.roleId() + " LIKE 'Team%' AND LOWER(assignedToMeOrTeamsPrincipals." + SecuritySchema.ROLE_PRINCIPALS$.MODULE$.principalName() + ") IN (" + this.binding(principals) + "))", (Iterable)principals.map((Function1 & Serializable)x$6 -> x$6.toLowerCase())), (List)Nil$.MODULE$));
        }
        if (roleIds.nonEmpty()) {
            orConditions = (Seq)orConditions.$plus$plus((IterableOnce)new .colon.colon((Object)new package.Sql("teams." + SecuritySchema.ROLES$.MODULE$.id() + " IN (SELECT " + SecuritySchema.ROLE_ROLES$.MODULE$.roleId() + " FROM " + SecuritySchema.ROLE_ROLES$.MODULE$.TABLE() + " assignedToMeOrTeamsRoles WHERE assignedToMeOrTeamsRoles." + SecuritySchema.ROLE_ROLES$.MODULE$.memberRoleId() + " IN (" + this.binding(roleIds) + "))", roleIds), (List)Nil$.MODULE$));
        }
        Growable growable = orConditions.nonEmpty() ? this.conditions().$plus$eq((Object)new package.Sql("(" + ((IterableOnceOps)orConditions.map((Function1 & Serializable)c -> "(" + c.sql() + ")")).mkString(" OR ") + ")", (Iterable)orConditions.flatMap((Function1 & Serializable)x$7 -> x$7.parameters()))) : this.conditions().$plus$eq((Object)new package.Sql("(1 = 0)", (Iterable)Nil$.MODULE$));
        return this;
    }

    public TasksSqlBuilder withAssignedToAnybody(Iterable<String> principals, Iterable<String> roleIds, boolean isAdmin) {
        BoxedUnit boxedUnit;
        if (!isAdmin) {
            Seq orConditions = (Seq)Nil$.MODULE$;
            if (roleIds.nonEmpty()) {
                orConditions = (Seq)orConditions.$plus$plus((IterableOnce)new .colon.colon((Object)new package.Sql("(assignedToTeamRoles.MEMBER_ROLE_ID IN (" + this.binding(roleIds) + "))", roleIds), (List)Nil$.MODULE$));
            }
            if (principals.nonEmpty()) {
                orConditions = (Seq)orConditions.$plus$plus((IterableOnce)new .colon.colon((Object)new package.Sql("(LOWER(assignedToTeamPrincipals.PRINCIPAL_NAME) IN (" + this.binding(principals) + "))", (Iterable)principals.map((Function1 & Serializable)x$8 -> x$8.toLowerCase())), (List)Nil$.MODULE$));
            }
            boxedUnit = orConditions.isEmpty() ? this.conditions().$plus$eq((Object)new package.Sql("(1 = 0)", (Iterable)Nil$.MODULE$)) : this.conditions().$plus$eq((Object)new package.Sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("releases." + Schema.RELEASES$.MODULE$.SECURITY_UID() + " IN (\n             |  SELECT assignedToTeams." + SecuritySchema.ROLES$.MODULE$.ciId() + " FROM " + SecuritySchema.ROLES$.MODULE$.TABLE() + " assignedToTeams\n             |  JOIN " + SecuritySchema.ROLE_PERMISSIONS$.MODULE$.TABLE() + " assignedToTeamPermissions ON assignedToTeams." + SecuritySchema.ROLES$.MODULE$.id() + " = assignedToTeamPermissions." + SecuritySchema.ROLE_PERMISSIONS$.MODULE$.roleId() + "\n             |  LEFT JOIN " + SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE() + " assignedToTeamPrincipals ON assignedToTeams." + SecuritySchema.ROLES$.MODULE$.id() + " = assignedToTeamPrincipals." + SecuritySchema.ROLE_PRINCIPALS$.MODULE$.roleId() + "\n             |  LEFT JOIN " + SecuritySchema.ROLE_ROLES$.MODULE$.TABLE() + " assignedToTeamRoles ON assignedToTeams." + SecuritySchema.ROLES$.MODULE$.id() + " = assignedToTeamRoles." + SecuritySchema.ROLE_ROLES$.MODULE$.roleId() + "\n             |  WHERE assignedToTeamPermissions." + SecuritySchema.ROLE_PERMISSIONS$.MODULE$.permissionName() + " = '" + XLReleasePermissions.VIEW_RELEASE.getPermissionName() + "' AND (" + ((IterableOnceOps)orConditions.map((Function1 & Serializable)x$9 -> x$9.sql())).mkString(" OR ") + "))")), (Iterable)orConditions.flatMap((Function1 & Serializable)x$10 -> x$10.parameters())));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withAnyFacets() {
        this.joinFacets();
        return this;
    }

    public TasksSqlBuilder orderByTaskId() {
        this.orderBy("tasks." + Schema.TASKS$.MODULE$.TASK_ID());
        return this;
    }

    private String binding(Iterable<Object> values) {
        return ((IterableOnceOps)values.toSeq().map((Function1 & Serializable)x$11 -> "?")).mkString(",");
    }

    private void joinTeams() {
        this.addJoin("JOIN " + SecuritySchema.ROLES$.MODULE$.TABLE() + " teams ON releases." + Schema.RELEASES$.MODULE$.SECURITY_UID() + " = teams." + SecuritySchema.ROLES$.MODULE$.ciId());
    }

    private void joinTeamsToTasks() {
        this.addJoin("LEFT JOIN " + SecuritySchema.ROLES$.MODULE$.TABLE() + " teams ON releases." + Schema.RELEASES$.MODULE$.SECURITY_UID() + " = teams." + SecuritySchema.ROLES$.MODULE$.ciId() + " AND tasks." + Schema.TASKS$.MODULE$.TEAM() + " = teams." + SecuritySchema.ROLES$.MODULE$.name());
    }

    private void joinTeamRoles() {
        this.addJoin("LEFT JOIN " + SecuritySchema.ROLE_ROLES$.MODULE$.TABLE() + " teamRoles ON teams." + SecuritySchema.ROLES$.MODULE$.id() + " = teamRoles." + SecuritySchema.ROLE_ROLES$.MODULE$.roleId());
    }

    private void joinTeamPrincipals() {
        this.addJoin("LEFT JOIN " + SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE() + " teamPrincipals ON teams." + SecuritySchema.ROLES$.MODULE$.id() + " = teamPrincipals." + SecuritySchema.ROLE_PRINCIPALS$.MODULE$.roleId());
    }

    private void joinTeamPermissions() {
        this.addJoin("JOIN " + SecuritySchema.ROLE_PERMISSIONS$.MODULE$.TABLE() + " teamPermissions ON teams." + SecuritySchema.ROLES$.MODULE$.id() + " = teamPermissions." + SecuritySchema.ROLE_PERMISSIONS$.MODULE$.roleId());
    }

    private void joinFolders() {
        this.addJoin("JOIN " + Schema.FOLDERS$.MODULE$.TABLE() + " folders ON releases." + Schema.RELEASES$.MODULE$.FOLDER_CI_UID() + " = folders." + Schema.FOLDERS$.MODULE$.CI_UID());
    }

    private void joinFacets() {
        this.addJoin("JOIN " + Schema.FACETS$.MODULE$.TABLE() + " facets ON tasks." + Schema.TASKS$.MODULE$.CI_UID() + " = facets." + Schema.FACETS$.MODULE$.APPLIED_TO_TASK_UID());
    }

    public TasksSqlBuilder newInstance() {
        return new TasksSqlBuilder(super.dialect());
    }

    public TasksSqlBuilder(SqlBuilder.Dialect dialect) {
        super(dialect);
    }
}

