package com.xebialabs.xlrelease.scheduler.sql

import com.xebialabs.xlrelease.repository.sql.persistence.Schema.{TASKS, TASK_JOBS}
import com.xebialabs.xlrelease.scheduler.{JobOverview, JobStatus, JobType}
import org.springframework.jdbc.core.RowMapper

import java.lang
import java.time.{Duration, Instant}
import java.util.Date

trait JobOverviewRowMapper {

  def jobOverviewMapper: RowMapper[JobOverview] = (rs, _) => {
    val submitTime = Option(rs.getTimestamp(TASK_JOBS.SUBMIT_TIME)).map(t => Date.from(t.toInstant)).orNull
    val startTime = Option(rs.getTimestamp(TASK_JOBS.START_TIME)).map(t => Date.from(t.toInstant)).orNull
    val scheduledStartTime = Option(rs.getTimestamp(TASK_JOBS.SCHEDULED_START_TIME)).map(t => Date.from(t.toInstant)).orNull
    val (waitDuration, executionDuration) = calculateDuration(scheduledStartTime, startTime)

    JobOverview(
      rs.getLong(TASK_JOBS.ID),
      rs.getString(TASK_JOBS.NODE),
      JobType.valueOf(rs.getString(TASK_JOBS.JOB_TYPE)),
      JobStatus.valueOf(rs.getString(TASK_JOBS.STATUS)),
      submitTime,
      startTime,
      scheduledStartTime,
      rs.getString(TASK_JOBS.TASK_ID),
      rs.getString(TASKS.TASK_TYPE),
      waitDuration,
      executionDuration,
      rs.getString(TASK_JOBS.RUNNER_ID),
      rs.getString(TASKS.TITLE)
    )
  }

  def calculateDuration(scheduledStartTime: Date, startTime: Date): (Long, Long) = {
    val now: Instant = Instant.now()
    val waitDuration: lang.Long = if (null != scheduledStartTime && scheduledStartTime.toInstant.isBefore(now)) {
      val time: Instant = if (null != startTime) startTime.toInstant else now
      Duration.between(scheduledStartTime.toInstant, time).toSeconds
    } else {
      null
    }
    val executionDuration: lang.Long = if (null != startTime) {
      Duration.between(startTime.toInstant, now).toSeconds
    } else {
      null
    }
    (waitDuration, executionDuration)
  }

}
