package com.xebialabs.xlrelease.scheduler.sql

import com.xebialabs.xlrelease.repository.sql.persistence.Schema.TASK_JOBS
import com.xebialabs.xlrelease.scheduler._
import org.springframework.jdbc.core.RowMapper

trait JobRowMapper {

  def jobMapper: RowMapper[JobRow] = (rs, _) => {
    JobRow(
      rs.getLong(TASK_JOBS.ID),
      rs.getString(TASK_JOBS.NODE),
      JobType.valueOf(rs.getString(TASK_JOBS.JOB_TYPE)),
      JobStatus.valueOf(rs.getString(TASK_JOBS.STATUS)),
      rs.getLong(TASK_JOBS.VERSION),
      Option(rs.getTimestamp(TASK_JOBS.SUBMIT_TIME)).map(_.toInstant).orNull,
      Option(rs.getTimestamp(TASK_JOBS.START_TIME)).map(_.toInstant).orNull,
      Option(rs.getTimestamp(TASK_JOBS.SCHEDULED_START_TIME)).map(_.toInstant).orNull,
      rs.getString(TASK_JOBS.TASK_ID),
      rs.getInt(TASK_JOBS.RELEASE_UID),
      rs.getString(TASK_JOBS.EXECUTION_ID),
      rs.getString(TASK_JOBS.RUNNER_ID)
    )
  }

}
