/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.logs;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence$;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionEntry;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionEntry$;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionRepository;
import com.xebialabs.xlrelease.storage.domain.LogEntry;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.Instant;
import java.util.UUID;
import org.slf4j.Marker;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0005\u001dh\u0001\u0002\r\u001a\u0001\u0011B\u0001\u0002\u0012\u0001\u0003\u0006\u0004%\u0019!\u0012\u0005\t%\u0002\u0011\t\u0011)A\u0005\r\"A1\u000b\u0001BC\u0002\u0013\rA\u000b\u0003\u0005m\u0001\t\u0005\t\u0015!\u0003V\u0011\u0015i\u0007\u0001\"\u0001o\u0011\u0015\u0019\b\u0001\"\u0011u\u0011\u001d\t\u0019\u0004\u0001C!\u0003kAq!a\u001a\u0001\t\u0013\tI\u0007C\u0004\u0002p\u0001!I!!\u001d\t\u000f\u0005U\u0004\u0001\"\u0011\u0002x!9\u0011Q\u0011\u0001\u0005\n\u0005\u001d\u0005bBAQ\u0001\u0011%\u00111\u0015\u0005\b\u0003s\u0003A\u0011IA^\u0011%\tI\r\u0001b\u0001\n\u0013\tY\rC\u0004\u0002N\u0002\u0001\u000b\u0011B?\t\u0013\u0005=\u0007A1A\u0005\n\u0005-\u0007bBAi\u0001\u0001\u0006I! \u0005\n\u0003'\u0004!\u0019!C\u0005\u0003\u0017Dq!!6\u0001A\u0003%Q\u0010C\u0005\u0002X\u0002\u0011\r\u0011\"\u0003\u0002L\"9\u0011\u0011\u001c\u0001!\u0002\u0013i\b\"CAn\u0001\t\u0007I\u0011BAf\u0011\u001d\ti\u000e\u0001Q\u0001\nu\u0014!dU9m)\u0006\u001c8.\u0012=fGV$\u0018n\u001c8SKB|7/\u001b;pefT!AG\u000e\u0002\t1|wm\u001d\u0006\u00039u\t\u0011b]2iK\u0012,H.\u001a:\u000b\u0005yy\u0012!\u0003=me\u0016dW-Y:f\u0015\t\u0001\u0013%A\u0005yK\nL\u0017\r\\1cg*\t!%A\u0002d_6\u001c\u0001a\u0005\u0004\u0001K-z\u0013(\u0011\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0007\u0003:L(+\u001a4\u0011\u00051jS\"A\r\n\u00059J\"a\u0006+bg.,\u00050Z2vi&|gNU3q_NLGo\u001c:z!\t\u0001t'D\u00012\u0015\t\u00114'A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,'B\u0001\u001b6\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003mu\t!B]3q_NLGo\u001c:z\u0013\tA\u0014G\u0001\nQKJ\u001c\u0018n\u001d;f]\u000e,7+\u001e9q_J$\bC\u0001\u001e@\u001b\u0005Y$B\u0001\u001f>\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005q\u0014\u0001C4sSjTH.\u001a3\n\u0005\u0001[$a\u0002'pO\u001eLgn\u001a\t\u0003a\tK!aQ\u0019\u0003\u000bU#\u0018\u000e\\:\u0002\u0019)$'m\u0019+f[Bd\u0017\r^3\u0016\u0003\u0019\u0003\"a\u0012)\u000e\u0003!S!!\u0013&\u0002\t\r|'/\u001a\u0006\u0003\u00172\u000bAA\u001b3cG*\u0011QJT\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tq*A\u0002pe\u001eL!!\u0015%\u0003\u0019)#'m\u0019+f[Bd\u0017\r^3\u0002\u001b)$'m\u0019+f[Bd\u0017\r^3!\u0003\u001d!\u0017.\u00197fGR,\u0012!\u0016\t\u0003-&t!a\u00164\u000f\u0005a#gBA-c\u001d\tQ\u0016M\u0004\u0002\\A:\u0011AlX\u0007\u0002;*\u0011alI\u0001\u0007yI|w\u000e\u001e \n\u0003\tJ!\u0001I\u0011\n\u0005yy\u0012BA2\u001e\u0003\t!'-\u0003\u00025K*\u00111-H\u0005\u0003O\"\f!bU9m\u0005VLG\u000eZ3s\u0015\t!T-\u0003\u0002kW\n9A)[1mK\u000e$(BA4i\u0003!!\u0017.\u00197fGR\u0004\u0013A\u0002\u001fj]&$h\bF\u0001p)\r\u0001\u0018O\u001d\t\u0003Y\u0001AQ\u0001R\u0003A\u0004\u0019CQaU\u0003A\u0004U\u000bAA]3bIR!Qo_A\u0006!\r1c\u000f_\u0005\u0003o\u001e\u0012aa\u00149uS>t\u0007C\u0001\u0017z\u0013\tQ\u0018D\u0001\nUCN\\W\t_3dkRLwN\\#oiJL\b\"\u0002?\u0007\u0001\u0004i\u0018A\u0002;bg.LE\rE\u0002\u007f\u0003\u000bq1a`A\u0001!\tav%C\u0002\u0002\u0004\u001d\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0004\u0003\u0013\u0011aa\u0015;sS:<'bAA\u0002O!1\u0011Q\u0002\u0004A\u0002u\f1\"\u001a=fGV$\u0018n\u001c8JI\"\u001aa!!\u0005\u0011\t\u0005M\u0011\u0011D\u0007\u0003\u0003+Q1!a\u0006i\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\t\u0005m\u0011Q\u0003\u0002\u000b\u0013N\u0014V-\u00193P]2L\bf\u0001\u0004\u0002 A!\u0011\u0011EA\u0018\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012AC1o]>$\u0018\r^5p]*!\u0011\u0011FA\u0016\u0003\u001diW\r\u001e:jGNT1!!\f\"\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BA\u0019\u0003G\u0011Q\u0001V5nK\u0012\fAAZ5oIR!\u0011qGA%!\u0015\tI$a\u0011y\u001d\u0011\tY$a\u0010\u000f\u0007q\u000bi$C\u0001)\u0013\r\t\teJ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)%a\u0012\u0003\u0007M+\u0017OC\u0002\u0002B\u001dBq!a\u0013\b\u0001\u0004\ti%A\u0007gS:$w\n]3sCRLwN\u001c\t\u0005\u0003\u001f\niF\u0004\u0003\u0002R\u0005ec\u0002BA*\u0003/r1!WA+\u0013\taR$\u0003\u0002\u001b7%\u0019\u00111L\r\u0002/Q\u000b7o[#yK\u000e,H/[8o%\u0016\u0004xn]5u_JL\u0018\u0002BA0\u0003C\u0012QBR5oI>\u0003XM]1uS>t'bAA.3!\u001aq!!\u0005)\u0007\u001d\ty\"\u0001\u0004de\u0016\fG/\u001a\u000b\u0004q\u0006-\u0004BBA7\u0011\u0001\u0007\u00010A\u0002s_^\f\u0011\"\u001e9eCR,'k\\<\u0015\u0007a\f\u0019\b\u0003\u0004\u0002n%\u0001\r\u0001_\u0001\u0007kB$\u0017\r^3\u0015\u0007U\fI\bC\u0004\u0002|)\u0001\r!! \u0002\u0013=\u0004XM]1uS>t\u0007\u0003BA(\u0003\u007fJA!!!\u0002b\taR\u000b\u001d3bi\u0016$\u0016m]6Fq\u0016\u001cW\u000f^5p]>\u0003XM]1uS>t\u0007f\u0001\u0006\u0002 \u0005QQ.\u0019=J]N$\u0018M\u001c;\u0015\r\u0005%\u0015\u0011TAO!\u0011\tY)!&\u000e\u0005\u00055%\u0002BAH\u0003#\u000bA\u0001^5nK*\u0011\u00111S\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0018\u00065%aB%ogR\fg\u000e\u001e\u0005\b\u00037[\u0001\u0019AAE\u0003\u0005\t\u0007bBAP\u0017\u0001\u0007\u0011\u0011R\u0001\u0002E\u0006aBn\\4F]R\u0014\u0018\u0010V8UCN\\W\t_3dkRLwN\\#oiJLHc\u0001=\u0002&\"9\u0011q\u0015\u0007A\u0002\u0005%\u0016\u0001\u00037pO\u0016sGO]=\u0011\t\u0005-\u0016QW\u0007\u0003\u0003[SA!a,\u00022\u00061Am\\7bS:T1!a-\u001e\u0003\u001d\u0019Ho\u001c:bO\u0016LA!a.\u0002.\nAAj\\4F]R\u0014\u00180\u0001\u0004eK2,G/\u001a\u000b\u0007\u0003{\u000b\u0019-!2\u0011\u0007\u0019\ny,C\u0002\u0002B\u001e\u0012A!\u00168ji\")A0\u0004a\u0001{\"1\u0011QB\u0007A\u0002uD3!DA\u0010\u0003=\u0019F+\u0014+`\u0013:\u001bVI\u0015+`%>;V#A?\u0002!M#V\nV0J\u001dN+%\u000bV0S\u001f^\u0003\u0013aD*U\u001bR{V\u000b\u0015#B)\u0016{&kT,\u0002!M#V\nV0V!\u0012\u000bE+R0S\u001f^\u0003\u0013aD*U\u001bR{F)\u0012'F)\u0016{&kT,\u0002!M#V\nV0E\u000b2+E+R0S\u001f^\u0003\u0013\u0001G*U\u001bR{f)\u0013(E?R\u000b5kS0F1\u0016\u001bU\u000bV%P\u001d\u0006I2\u000bV'U?\u001aKe\nR0U\u0003N[u,\u0012-F\u0007V#\u0016j\u0014(!\u0003u\u0019F+\u0014+`\r&sEiX!M\u0019~#\u0016iU&`\u000bb+5)\u0016+J\u001f:\u001b\u0016AH*U\u001bR{f)\u0013(E?\u0006cEj\u0018+B'.{V\tW#D+RKuJT*!Q\r\u0001\u0011\u0011\u001d\t\u0005\u0003'\t\u0019/\u0003\u0003\u0002f\u0006U!aD%t)J\fgn]1di&|g.\u00197")
public class SqlTaskExecutionRepository
implements TaskExecutionRepository,
PersistenceSupport,
Logging {
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private final String STMT_INSERT_ROW;
    private final String STMT_UPDATE_ROW;
    private final String STMT_DELETE_ROW;
    private final String STMT_FIND_TASK_EXECUTION;
    private final String STMT_FIND_ALL_TASK_EXECUTIONS;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private NamedParameterJdbcTemplate namedTemplate;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public MapSqlParameterSource paramMap2MapSqlParameterSource(Map<String, Object> params) {
        return PersistenceSupport.paramMap2MapSqlParameterSource$(this, params);
    }

    @Override
    public Integer sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params) {
        return PersistenceSupport.sqlInsert$(this, pkColumn, sqlStatement, params);
    }

    @Override
    public <R> R sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlInsert(String pkColumn, String sqlStatement, MapSqlParameterSource params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public void sqlInsert(String sqlStatement, MapSqlParameterSource params) {
        PersistenceSupport.sqlInsert$(this, sqlStatement, params);
    }

    @Override
    public <R> R sqlExec(String sqlStatement, Map<String, Object> params, PreparedStatementCallback<R> callback) {
        return (R)PersistenceSupport.sqlExec$(this, sqlStatement, params, callback);
    }

    @Override
    public <R> R sqlExecWithContent(String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlExecWithContent$(this, sqlStatement, params, contentParam, mapper);
    }

    @Override
    public <R> R sqlInsertWithContent(String pkColumn, String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsertWithContent$(this, pkColumn, sqlStatement, params, contentParam, mapper);
    }

    @Override
    public <R> R sqlUpdate(String sqlStatement, MapSqlParameterSource params, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlUpdate$(this, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlSet(String sqlStatement, Function1<PreparedStatement, PreparedStatement> setup, Function1<Object, R> callback) {
        return (R)PersistenceSupport.sqlSet$(this, sqlStatement, setup, callback);
    }

    @Override
    public Function1<Object, BoxedUnit> checkCiUpdated(String entityId) {
        return PersistenceSupport.checkCiUpdated$(this, entityId);
    }

    @Override
    public Function1<Object, UUID> checkCiUpdated(Integer uid, Option<UUID> token, UUID freshToken) {
        return PersistenceSupport.checkCiUpdated$(this, uid, token, freshToken);
    }

    @Override
    public Function1<Object, BoxedUnit> checkCiDeleted(Integer uid) {
        return PersistenceSupport.checkCiDeleted$(this, uid);
    }

    @Override
    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, RowMapper<R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, mapper);
    }

    @Override
    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, Function1<ResultSet, R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlQuery(String sqlStatement, Map<String, Object> params, ResultSetExtractor<R> extractor) {
        return (R)PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, extractor);
    }

    @Override
    public Seq<Object> sqlBatch(String sqlStatement, Set<Map<String, Object>> parameters) {
        return PersistenceSupport.sqlBatch$(this, sqlStatement, parameters);
    }

    @Override
    public Seq<Object> sqlBatchWithContent(String sqlStatement, Seq<Tuple2<Map<String, Object>, Tuple2<String, String>>> params) {
        return PersistenceSupport.sqlBatchWithContent$(this, sqlStatement, params);
    }

    @Override
    public String pkName(String pkColumn) {
        return PersistenceSupport.pkName$(this, pkColumn);
    }

    @Override
    public MapSqlParameterSource paramSource(Seq<Tuple2<String, Object>> pairs) {
        return PersistenceSupport.paramSource$(this, pairs);
    }

    @Override
    public byte[] compress(String text) {
        return CompressionSupport.compress$((CompressionSupport)this, text);
    }

    @Override
    public String decompress(InputStream inputStream) {
        return CompressionSupport.decompress$((CompressionSupport)this, inputStream);
    }

    @Override
    public byte[] compress(byte[] byteArray) {
        return CompressionSupport.compress$((CompressionSupport)this, byteArray);
    }

    @Override
    public byte[] decompress(byte[] byteArray) {
        return CompressionSupport.decompress$((CompressionSupport)this, byteArray);
    }

    @Override
    public <A> Option<A> findOptional(Function1<JdbcTemplate, A> body, JdbcTemplate jdbcTemplate) {
        return Utils.findOptional$(this, body, jdbcTemplate);
    }

    @Override
    public <A> Option<A> findOne(Function0<Buffer<A>> body) {
        return Utils.findOne$(this, body);
    }

    @Override
    public <A> Seq<A> findMany(Function0<Buffer<A>> body) {
        return Utils.findMany$(this, body);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTaskExecutionRepository sqlTaskExecutionRepository = this;
        synchronized (sqlTaskExecutionRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private NamedParameterJdbcTemplate namedTemplate$lzycompute() {
        SqlTaskExecutionRepository sqlTaskExecutionRepository = this;
        synchronized (sqlTaskExecutionRepository) {
            if (!this.bitmap$0) {
                this.namedTemplate = PersistenceSupport.namedTemplate$(this);
                this.bitmap$0 = true;
            }
        }
        return this.namedTemplate;
    }

    @Override
    public NamedParameterJdbcTemplate namedTemplate() {
        return !this.bitmap$0 ? this.namedTemplate$lzycompute() : this.namedTemplate;
    }

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    @IsReadOnly
    public Option<TaskExecutionEntry> read(String taskId, String executionId) {
        return this.findOptional((Function1 & Serializable)x$1 -> (TaskExecutionEntry)x$1.queryForObject(this.STMT_FIND_TASK_EXECUTION(), TaskExecutionEntry$.MODULE$.taskExecutionRowMapper(), new Object[]{TaskPersistence$.MODULE$.hash(taskId), executionId}), this.jdbcTemplate());
    }

    @Timed
    @IsReadOnly
    public Seq<TaskExecutionEntry> find(TaskExecutionRepository.FindOperation findOperation) {
        TaskExecutionRepository.FindOperation findOperation2 = findOperation;
        if (!(findOperation2 instanceof TaskExecutionRepository.ByTaskId)) {
            throw new MatchError((Object)findOperation2);
        }
        TaskExecutionRepository.ByTaskId byTaskId = (TaskExecutionRepository.ByTaskId)findOperation2;
        String taskId = byTaskId.taskId();
        Seq seq = this.findMany((Function0 & Serializable)() -> this.sqlQuery(this.STMT_FIND_ALL_TASK_EXECUTIONS(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_EXECUTIONS$.MODULE$.TASK_ID_HASH()), (Object)TaskPersistence$.MODULE$.hash(taskId))})), TaskExecutionEntry$.MODULE$.taskExecutionRowMapper()));
        return seq;
    }

    private TaskExecutionEntry create(TaskExecutionEntry row) {
        this.namedTemplate().update(this.STMT_INSERT_ROW(), (SqlParameterSource)this.paramMap2MapSqlParameterSource((Map<String, Object>)row.asSqlParamMap()));
        return row;
    }

    private TaskExecutionEntry updateRow(TaskExecutionEntry row) {
        this.namedTemplate().update(this.STMT_UPDATE_ROW(), (SqlParameterSource)this.paramMap2MapSqlParameterSource((Map<String, Object>)row.asSqlParamMap()));
        return row;
    }

    @Timed
    public Option<TaskExecutionEntry> update(TaskExecutionRepository.UpdateTaskExecutionOperation operation) {
        None$ none$;
        TaskExecutionRepository.UpdateTaskExecutionOperation updateTaskExecutionOperation = operation;
        if (updateTaskExecutionOperation instanceof TaskExecutionRepository.FinishExecution) {
            None$ none$2;
            TaskExecutionRepository.FinishExecution finishExecution = (TaskExecutionRepository.FinishExecution)updateTaskExecutionOperation;
            String taskId = finishExecution.taskId();
            String executionId = finishExecution.executionId();
            Instant endDate = finishExecution.endDate();
            Option<TaskExecutionEntry> maybeRow = this.read(taskId, executionId);
            Option<TaskExecutionEntry> option = maybeRow;
            if (option instanceof Some) {
                Some some = (Some)option;
                TaskExecutionEntry row = (TaskExecutionEntry)some.value();
                Instant x$1 = endDate;
                String x$2 = row.copy$default$1();
                String x$3 = row.copy$default$2();
                int x$4 = row.copy$default$3();
                int x$5 = row.copy$default$4();
                Instant x$6 = row.copy$default$5();
                none$2 = new Some((Object)this.updateRow(row.copy(x$2, x$3, x$4, x$5, x$6, x$1)));
            } else if (None$.MODULE$.equals(option)) {
                none$2 = None$.MODULE$;
            } else {
                throw new MatchError(option);
            }
            none$ = none$2;
        } else if (updateTaskExecutionOperation instanceof TaskExecutionRepository.UpdateWithLogEntry) {
            TaskExecutionEntry taskExecutionEntry;
            TaskExecutionRepository.UpdateWithLogEntry updateWithLogEntry = (TaskExecutionRepository.UpdateWithLogEntry)updateTaskExecutionOperation;
            LogEntry logEntry = updateWithLogEntry.logEntry();
            TaskExecutionEntry taskExecutionEntry2 = this.logEntryToTaskExecutionEntry(logEntry);
            Option<TaskExecutionEntry> maybeRow = this.read(logEntry.taskId(), logEntry.executionId());
            Option<TaskExecutionEntry> option = maybeRow;
            if (option instanceof Some) {
                Some some = (Some)option;
                TaskExecutionEntry row = (TaskExecutionEntry)some.value();
                int x$7 = Integer.max(taskExecutionEntry2.lastJob(), row.lastJob());
                int x$8 = Integer.max(taskExecutionEntry2.lastChunk(), row.lastChunk());
                Instant x$9 = this.maxInstant(taskExecutionEntry2.lastModifiedDate(), row.lastModifiedDate());
                String x$10 = row.copy$default$1();
                String x$11 = row.copy$default$2();
                Instant x$12 = row.copy$default$6();
                TaskExecutionEntry updated = row.copy(x$10, x$11, x$7, x$8, x$9, x$12);
                taskExecutionEntry = this.updateRow(updated);
            } else if (None$.MODULE$.equals(option)) {
                taskExecutionEntry = this.create(taskExecutionEntry2);
            } else {
                throw new MatchError(option);
            }
            TaskExecutionEntry row = taskExecutionEntry;
            none$ = new Some((Object)row);
        } else {
            throw new MatchError((Object)updateTaskExecutionOperation);
        }
        return none$;
    }

    private Instant maxInstant(Instant a, Instant b) {
        return a.isAfter(b) ? a : b;
    }

    private TaskExecutionEntry logEntryToTaskExecutionEntry(LogEntry logEntry) {
        return new TaskExecutionEntry(TaskPersistence$.MODULE$.hash(logEntry.taskId()), logEntry.executionId(), (int)logEntry.jobId(), (int)logEntry.chunk(), Instant.parse(logEntry.lastEntryTimestamp()), null);
    }

    @Timed
    public void delete(String taskId, String executionId) {
        Map params = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_EXECUTIONS$.MODULE$.TASK_ID_HASH()), (Object)TaskPersistence$.MODULE$.hash(taskId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_EXECUTIONS$.MODULE$.EXECUTION_ID()), (Object)executionId)}));
        this.namedTemplate().update(this.STMT_DELETE_ROW(), (SqlParameterSource)this.paramMap2MapSqlParameterSource((Map<String, Object>)params));
    }

    private String STMT_INSERT_ROW() {
        return this.STMT_INSERT_ROW;
    }

    private String STMT_UPDATE_ROW() {
        return this.STMT_UPDATE_ROW;
    }

    private String STMT_DELETE_ROW() {
        return this.STMT_DELETE_ROW;
    }

    private String STMT_FIND_TASK_EXECUTION() {
        return this.STMT_FIND_TASK_EXECUTION;
    }

    private String STMT_FIND_ALL_TASK_EXECUTIONS() {
        return this.STMT_FIND_ALL_TASK_EXECUTIONS;
    }

    public SqlTaskExecutionRepository(JdbcTemplate jdbcTemplate, SqlBuilder.Dialect dialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        Utils.$init$(this);
        CompressionSupport.$init$(this);
        PersistenceSupport.$init$(this);
        Logging.$init$((Logging)this);
        this.STMT_INSERT_ROW = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(202).append("INSERT INTO ").append(Schema.TASK_EXECUTIONS$.MODULE$.TABLE()).append(" (\n       |  ").append(Schema.TASK_EXECUTIONS$.MODULE$.TASK_ID_HASH()).append(",\n       |  ").append(Schema.TASK_EXECUTIONS$.MODULE$.EXECUTION_ID()).append(",\n       |  ").append(Schema.TASK_EXECUTIONS$.MODULE$.LAST_JOB()).append(",\n       |  ").append(Schema.TASK_EXECUTIONS$.MODULE$.LAST_CHUNK()).append(",\n       |  ").append(Schema.TASK_EXECUTIONS$.MODULE$.LAST_MODIFIED_DATE()).append(",\n       |  ").append(Schema.TASK_EXECUTIONS$.MODULE$.END_DATE()).append("\n       | ) VALUES (\n       |  :").append(Schema.TASK_EXECUTIONS$.MODULE$.TASK_ID_HASH()).append(",\n       |  :").append(Schema.TASK_EXECUTIONS$.MODULE$.EXECUTION_ID()).append(",\n       |  :").append(Schema.TASK_EXECUTIONS$.MODULE$.LAST_JOB()).append(",\n       |  :").append(Schema.TASK_EXECUTIONS$.MODULE$.LAST_CHUNK()).append(",\n       |  :").append(Schema.TASK_EXECUTIONS$.MODULE$.LAST_MODIFIED_DATE()).append(",\n       |  :").append(Schema.TASK_EXECUTIONS$.MODULE$.END_DATE()).append("\n       | )\n       |").toString()));
        this.STMT_UPDATE_ROW = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(165).append("UPDATE ").append(Schema.TASK_EXECUTIONS$.MODULE$.TABLE()).append("\n       |  SET\n       |    ").append(Schema.TASK_EXECUTIONS$.MODULE$.LAST_JOB()).append(" = :").append(Schema.TASK_EXECUTIONS$.MODULE$.LAST_JOB()).append(",\n       |    ").append(Schema.TASK_EXECUTIONS$.MODULE$.LAST_CHUNK()).append(" = :").append(Schema.TASK_EXECUTIONS$.MODULE$.LAST_CHUNK()).append(",\n       |    ").append(Schema.TASK_EXECUTIONS$.MODULE$.LAST_MODIFIED_DATE()).append(" = :").append(Schema.TASK_EXECUTIONS$.MODULE$.LAST_MODIFIED_DATE()).append(",\n       |    ").append(Schema.TASK_EXECUTIONS$.MODULE$.END_DATE()).append(" = :").append(Schema.TASK_EXECUTIONS$.MODULE$.END_DATE()).append("\n       |  WHERE\n       |    ").append(Schema.TASK_EXECUTIONS$.MODULE$.TASK_ID_HASH()).append(" = :").append(Schema.TASK_EXECUTIONS$.MODULE$.TASK_ID_HASH()).append("\n       |  AND\n       |    ").append(Schema.TASK_EXECUTIONS$.MODULE$.EXECUTION_ID()).append(" = :").append(Schema.TASK_EXECUTIONS$.MODULE$.EXECUTION_ID()).append("\n       |").toString()));
        this.STMT_DELETE_ROW = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(85).append("DELETE FROM ").append(Schema.TASK_EXECUTIONS$.MODULE$.TABLE()).append("\n       |  WHERE\n       |    ").append(Schema.TASK_EXECUTIONS$.MODULE$.TASK_ID_HASH()).append(" = :").append(Schema.TASK_EXECUTIONS$.MODULE$.TASK_ID_HASH()).append("\n       |  AND\n       |    ").append(Schema.TASK_EXECUTIONS$.MODULE$.EXECUTION_ID()).append(" = :").append(Schema.TASK_EXECUTIONS$.MODULE$.EXECUTION_ID()).append("\n       |").toString()));
        this.STMT_FIND_TASK_EXECUTION = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(63).append("SELECT * FROM ").append(Schema.TASK_EXECUTIONS$.MODULE$.TABLE()).append("\n       |  WHERE ").append(Schema.TASK_EXECUTIONS$.MODULE$.TASK_ID_HASH()).append(" = ?\n       |  AND ").append(Schema.TASK_EXECUTIONS$.MODULE$.EXECUTION_ID()).append(" = ?\n       |").toString()));
        this.STMT_FIND_ALL_TASK_EXECUTIONS = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(68).append("SELECT * FROM ").append(Schema.TASK_EXECUTIONS$.MODULE$.TABLE()).append("\n       |  WHERE ").append(Schema.TASK_EXECUTIONS$.MODULE$.TASK_ID_HASH()).append(" = :").append(Schema.TASK_EXECUTIONS$.MODULE$.TASK_ID_HASH()).append("\n       |  ORDER BY ").append(Schema.TASK_EXECUTIONS$.MODULE$.LAST_MODIFIED_DATE()).append(" ASC\n       |").toString()));
    }
}

