package com.xebialabs.xlrelease.repository.sql.proxy

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly
import com.xebialabs.xlrelease.domain.{CustomScriptTask, PythonScript}
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.repository.Ids.getFolderlessId
import com.xebialabs.xlrelease.repository.sql.persistence.CiId._
import com.xebialabs.xlrelease.repository.sql.persistence.Schema._
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate

import scala.annotation.varargs
import scala.jdk.CollectionConverters._


class SqlReferenceTypeRepository(jdbcTemplate: JdbcTemplate) extends ReferenceTypeRepository {

  private val namedJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate.getDataSource)

  @IsReadOnly
  override def findTaskType(referencedId: String): Option[Type] = {
    val referencedIdHash = TaskPersistence.hash(referencedId.normalized)
    val taskId = getFolderlessId(referencedId)
    val query = s"SELECT ${TASKS.TASK_TYPE} FROM ${TASKS.TABLE} WHERE ${TASKS.TASK_ID_HASH}=:${TASKS.TASK_ID_HASH} AND ${TASKS.TASK_ID}=:${TASKS.TASK_ID}"
    val taskTypeName: String = namedJdbcTemplate.queryForObject(query, map(TASKS.TASK_ID_HASH -> referencedIdHash, TASKS.TASK_ID -> taskId), classOf[String])
    optionalTypeOf(taskTypeName) match {
      case None => None
      case Some(taskType) if taskType.instanceOf(Type.valueOf(classOf[PythonScript])) => Some(Type.valueOf(classOf[CustomScriptTask]))
      case someTaskType => someTaskType
    }
  }

  private val configuration_query = s"SELECT ${CONFIGURATIONS.CI_TYPE} FROM ${CONFIGURATIONS.TABLE} WHERE ${CONFIGURATIONS.ID}=:${CONFIGURATIONS.ID}"

  @IsReadOnly
  override def findConfigurationType(referencedId: String): Option[Type] = {
    val normalizedId = referencedId.normalized
    val taskTypeName: String = namedJdbcTemplate.queryForObject(configuration_query, map(CONFIGURATIONS.ID -> normalizedId), classOf[String])
    optionalTypeOf(taskTypeName)
  }

  @IsReadOnly
  override def findVariableType(referencedId: String): Option[Type] = {
    val normalizedId = referencedId.normalized
    val taskTypeName = if (Ids.isFolderId(referencedId)) {
      val query = s"SELECT ${FOLDER_VARIABLES.CI_TYPE} FROM ${FOLDER_VARIABLES.TABLE} WHERE ${FOLDER_VARIABLES.ID}=:${FOLDER_VARIABLES.ID}"
      namedJdbcTemplate.queryForObject[String](query, map(FOLDER_VARIABLES.ID -> normalizedId), classOf[String])
    } else {
      namedJdbcTemplate.queryForObject[String](configuration_query, map(CONFIGURATIONS.ID -> normalizedId), classOf[String])
    }
    optionalTypeOf(taskTypeName)
  }

  @IsReadOnly
  override def findTriggerType(referencedId: String): Option[Type] = {
    val normalizedId = referencedId.normalized
    val query = s"SELECT ${TRIGGERS.CI_TYPE} FROM ${TRIGGERS.TABLE} WHERE ${TRIGGERS.ID}=:${TRIGGERS.ID}"
    val taskTypeName: String = namedJdbcTemplate.queryForObject(query, map(TRIGGERS.ID -> normalizedId), classOf[String])
    optionalTypeOf(taskTypeName)
  }

  @varargs
  private def map(pairs: (String, AnyRef)*): java.util.Map[String, AnyRef] = {
    pairs.toMap.asJava
  }

  private def optionalTypeOf(taskTypeName: String): Option[Type] = {
    if (taskTypeName == null) {
      None
    } else {
      val taskType = Type.valueOf(taskTypeName)
      if (taskType.exists()) {
        Some(taskType)
      } else {
        None
      }
    }
  }

}
