package com.xebialabs.xlrelease.spring.config

import com.xebialabs.deployit.security.{PermissionChecker, PermissionEditor, UserService}
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.security.sql.{CachingPermissionEditor, CachingPermissionLister, CachingSqlRoleService, CachingSqlUserService, SqlPermissionChecker, SqlPermissionEditor, SqlPermissionLister, SqlRoleService, SqlUserService, UserCacheEvicter}
import com.xebialabs.xlrelease.service.BroadcastService
import org.springframework.cache.annotation.EnableCaching
import org.springframework.context.annotation.{Bean, Configuration}

import java.util.Optional

@Configuration
@EnableCaching(proxyTargetClass = true)
class SqlSecurityConfiguration(sqlConfiguration: SqlConfiguration, xlrConfig: XlrConfig, broadcastService: BroadcastService) {
  lazy val cachingEnabled = xlrConfig.cache.security.enabled

  @Bean
  def roleService(): SqlRoleService = if (cachingEnabled) {
    new CachingSqlRoleService(sqlConfiguration.xlrRepositoryDatabase(), broadcastService)
  } else {
    new SqlRoleService(sqlConfiguration.xlrRepositoryDatabase())
  }

  @Bean
  def userService(evicter: Optional[UserCacheEvicter]): UserService = {
    if (cachingEnabled) {
      new CachingSqlUserService(sqlConfiguration.xlrRepositoryDatabase(), evicter.get())
    } else {
      new SqlUserService(sqlConfiguration.xlrRepositoryDatabase())
    }
  }

  @Bean
  def permissionLister(): SqlPermissionLister = if (cachingEnabled) {
    new CachingPermissionLister(sqlConfiguration.xlrRepositoryDatabase())
  } else {
    new SqlPermissionLister(sqlConfiguration.xlrRepositoryDatabase())
  }

  @Bean
  def permissionEditor(): PermissionEditor = if (cachingEnabled) {
    new CachingPermissionEditor(sqlConfiguration.xlrRepositoryDatabase(), roleService(), broadcastService)
  } else {
    new SqlPermissionEditor(sqlConfiguration.xlrRepositoryDatabase(), roleService())
  }

  @Bean
  def xlrPermissionChecker(permissionLister: SqlPermissionLister): PermissionChecker = {
    new SqlPermissionChecker(sqlConfiguration.xlrRepositoryDatabase(), permissionLister, cachingEnabled)
  }

}
