package com.xebialabs.xlrelease.repository.sql

import com.codahale.metrics.annotation.Timed
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional
import com.xebialabs.xlrelease.repository.LicenseRepository
import com.xebialabs.xlrelease.repository.sql.persistence.LicensePersistence
import grizzled.slf4j.Logging
import org.springframework.stereotype.Service

@IsTransactional
@Service
class SqlLicenseRepository(licensePersistence: LicensePersistence) extends LicenseRepository with Logging {

  @Timed
  override def find(): Option[String] = {
    licensePersistence.findById(LICENSE_ID)
  }

  @Timed
  override def createOrUpdate(licenseData: String): Unit = {
    if (licensePersistence.exists(LICENSE_ID)) {
      licensePersistence.update(LICENSE_ID, licenseData)
    } else {
      licensePersistence.insert(LICENSE_ID, licenseData)
    }
  }
}
