/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql.persistence;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.SqlRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.UUID;
import org.slf4j.Marker;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0005\rc\u0001B\u0007\u000f\u0001mA\u0001\"\u000e\u0001\u0003\u0006\u0004%\u0019A\u000e\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005o!AA\t\u0001BC\u0002\u0013\rQ\t\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003G\u0011\u0015q\u0006\u0001\"\u0001`\u0011\u0015!\u0007\u0001\"\u0001f\u0011\u0015\t\b\u0001\"\u0001s\u0011\u0015!\b\u0001\"\u0003v\u0011\u00159\b\u0001\"\u0001y\u0011\u001d\t\t\u0003\u0001C\u0005\u0003GA\u0011\"!\u000b\u0001\u0005\u0004%I!a\u000b\t\u0011\u0005M\u0002\u0001)A\u0005\u0003[\u0011Q\u0003V1tW\n\u000b7m[;q!\u0016\u00148/[:uK:\u001cWM\u0003\u0002\u0010!\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\t\t\"#A\u0002tc2T!a\u0005\u000b\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002\u0016-\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003/a\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003e\t1aY8n\u0007\u0001\u0019b\u0001\u0001\u000f#M)j\u0003CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"AB!osJ+g\r\u0005\u0002$I5\t\u0001#\u0003\u0002&!\ti1+\u001d7SKB|7/\u001b;pef\u0004\"a\n\u0015\u000e\u00039I!!\u000b\b\u0003%A+'o]5ti\u0016t7-Z*vaB|'\u000f\u001e\t\u0003O-J!\u0001\f\b\u0003\u000bU#\u0018\u000e\\:\u0011\u00059\u001aT\"A\u0018\u000b\u0005A\n\u0014!B:mMRR'\"\u0001\u001a\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!\u0001N\u0018\u0003\u000f1{wmZ5oO\u0006a!\u000e\u001a2d)\u0016l\u0007\u000f\\1uKV\tq\u0007\u0005\u00029\u00036\t\u0011H\u0003\u0002;w\u0005!1m\u001c:f\u0015\taT(\u0001\u0003kI\n\u001c'B\u0001 @\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001!\u0002\u0007=\u0014x-\u0003\u0002Cs\ta!\n\u001a2d)\u0016l\u0007\u000f\\1uK\u0006i!\u000e\u001a2d)\u0016l\u0007\u000f\\1uK\u0002\nq\u0001Z5bY\u0016\u001cG/F\u0001G!\t9%L\u0004\u0002I/:\u0011\u0011*\u0016\b\u0003\u0015Ns!a\u0013*\u000f\u00051\u000bfBA'Q\u001b\u0005q%BA(\u001b\u0003\u0019a$o\\8u}%\t\u0011$\u0003\u0002\u00181%\u0011QCF\u0005\u0003)R\t!\u0001\u001a2\n\u0005E1&B\u0001+\u0015\u0013\tA\u0016,\u0001\u0006Tc2\u0014U/\u001b7eKJT!!\u0005,\n\u0005mc&a\u0002#jC2,7\r\u001e\u0006\u00031f\u000b\u0001\u0002Z5bY\u0016\u001cG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001$2!\u00192d!\t9\u0003\u0001C\u00036\u000b\u0001\u000fq\u0007C\u0003E\u000b\u0001\u000fa)\u0001\tvaN,'\u000f\u001e+bg.\u0014\u0015mY6vaR\u0011a-\u001b\t\u0003;\u001dL!\u0001\u001b\u0010\u0003\tUs\u0017\u000e\u001e\u0005\u0006U\u001a\u0001\ra[\u0001\u0005i\u0006\u001c8\u000e\u0005\u0002m_6\tQN\u0003\u0002o)\u00051Am\\7bS:L!\u0001]7\u0003\tQ\u000b7o[\u0001\u0015kB$\u0017\r^3UCN\\')Y2lkBT5o\u001c8\u0015\u0005\u0019\u001c\b\"\u00026\b\u0001\u0004Y\u0017\u0001F5og\u0016\u0014H\u000fV1tW\n\u000b7m[;q\u0015N|g\u000e\u0006\u0002gm\")!\u000e\u0003a\u0001W\u0006qa-\u001b8e)\u0006\u001c8NQ1dWV\u0004H#B=\u0002\n\u00055\u0001cA\u000f{y&\u00111P\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007u\f\u0019A\u0004\u0002\u007f\u007fB\u0011QJH\u0005\u0004\u0003\u0003q\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0006\u0005\u001d!AB*ue&twMC\u0002\u0002\u0002yAa!a\u0003\n\u0001\u0004a\u0018A\u0002;bg.LE\rC\u0004\u0002\u0010%\u0001\r!!\u0005\u0002\u0019I,G.Z1tK\u000eKW+\u001b3\u0011\t\u0005M\u0011QD\u0007\u0003\u0003+QA!a\u0006\u0002\u001a\u0005!A.\u00198h\u0015\t\tY\"\u0001\u0003kCZ\f\u0017\u0002BA\u0010\u0003+\u0011q!\u00138uK\u001e,'/\u0001\tgS:$G+Y:l\u0005\u0006\u001c7.\u001e9JIR)\u00110!\n\u0002(!1\u00111\u0002\u0006A\u0002qDq!a\u0004\u000b\u0001\u0004\t\t\"A\u000bcS:\f'/_*ue\u0016\fWNU8x\u001b\u0006\u0004\b/\u001a:\u0016\u0005\u00055\u0002\u0003\u0002\u001d\u00020qL1!!\r:\u0005%\u0011vn^'baB,'/\u0001\fcS:\f'/_*ue\u0016\fWNU8x\u001b\u0006\u0004\b/\u001a:!Q\r\u0001\u0011q\u0007\t\u0005\u0003s\ty$\u0004\u0002\u0002<)\u0019\u0011QH-\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0003\u0003\nYDA\bJgR\u0013\u0018M\\:bGRLwN\\1m\u0001")
public class TaskBackupPersistence
implements SqlRepository,
PersistenceSupport,
Logging {
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private final RowMapper<String> binaryStreamRowMapper;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private NamedParameterJdbcTemplate namedTemplate;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public MapSqlParameterSource paramMap2MapSqlParameterSource(Map<String, Object> params) {
        return PersistenceSupport.paramMap2MapSqlParameterSource$(this, params);
    }

    @Override
    public Integer sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params) {
        return PersistenceSupport.sqlInsert$(this, pkColumn, sqlStatement, params);
    }

    @Override
    public <R> R sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlInsert(String pkColumn, String sqlStatement, MapSqlParameterSource params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public void sqlInsert(String sqlStatement, MapSqlParameterSource params) {
        PersistenceSupport.sqlInsert$(this, sqlStatement, params);
    }

    @Override
    public <R> R sqlExec(String sqlStatement, Map<String, Object> params, PreparedStatementCallback<R> callback) {
        return (R)PersistenceSupport.sqlExec$(this, sqlStatement, params, callback);
    }

    @Override
    public <R> R sqlExecWithContent(String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlExecWithContent$(this, sqlStatement, params, contentParam, mapper);
    }

    @Override
    public <R> R sqlInsertWithContent(String pkColumn, String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsertWithContent$(this, pkColumn, sqlStatement, params, contentParam, mapper);
    }

    @Override
    public <R> R sqlUpdate(String sqlStatement, MapSqlParameterSource params, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlUpdate$(this, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlSet(String sqlStatement, Function1<PreparedStatement, PreparedStatement> setup, Function1<Object, R> callback) {
        return (R)PersistenceSupport.sqlSet$(this, sqlStatement, setup, callback);
    }

    @Override
    public Function1<Object, BoxedUnit> checkCiUpdated(String entityId) {
        return PersistenceSupport.checkCiUpdated$(this, entityId);
    }

    @Override
    public Function1<Object, UUID> checkCiUpdated(Integer uid, Option<UUID> token, UUID freshToken) {
        return PersistenceSupport.checkCiUpdated$(this, uid, token, freshToken);
    }

    @Override
    public Function1<Object, BoxedUnit> checkCiDeleted(Integer uid) {
        return PersistenceSupport.checkCiDeleted$(this, uid);
    }

    @Override
    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, RowMapper<R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, mapper);
    }

    @Override
    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, Function1<ResultSet, R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlQuery(String sqlStatement, Map<String, Object> params, ResultSetExtractor<R> extractor) {
        return (R)PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, extractor);
    }

    @Override
    public Seq<Object> sqlBatch(String sqlStatement, Set<Map<String, Object>> parameters) {
        return PersistenceSupport.sqlBatch$(this, sqlStatement, parameters);
    }

    @Override
    public Seq<Object> sqlBatchWithContent(String sqlStatement, Seq<Tuple2<Map<String, Object>, Tuple2<String, String>>> params) {
        return PersistenceSupport.sqlBatchWithContent$(this, sqlStatement, params);
    }

    @Override
    public String pkName(String pkColumn) {
        return PersistenceSupport.pkName$(this, pkColumn);
    }

    @Override
    public MapSqlParameterSource paramSource(Seq<Tuple2<String, Object>> pairs) {
        return PersistenceSupport.paramSource$(this, pairs);
    }

    @Override
    public byte[] compress(String text) {
        return CompressionSupport.compress$((CompressionSupport)this, text);
    }

    @Override
    public String decompress(InputStream inputStream) {
        return CompressionSupport.decompress$((CompressionSupport)this, inputStream);
    }

    @Override
    public byte[] compress(byte[] byteArray) {
        return CompressionSupport.compress$((CompressionSupport)this, byteArray);
    }

    @Override
    public byte[] decompress(byte[] byteArray) {
        return CompressionSupport.decompress$((CompressionSupport)this, byteArray);
    }

    @Override
    public <A> Option<A> findOptional(Function1<JdbcTemplate, A> body, JdbcTemplate jdbcTemplate) {
        return Utils.findOptional$(this, body, jdbcTemplate);
    }

    @Override
    public <A> Option<A> findOne(Function0<Buffer<A>> body) {
        return Utils.findOne$(this, body);
    }

    @Override
    public <A> Seq<A> findMany(Function0<Buffer<A>> body) {
        return Utils.findMany$(this, body);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TaskBackupPersistence taskBackupPersistence = this;
        synchronized (taskBackupPersistence) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private NamedParameterJdbcTemplate namedTemplate$lzycompute() {
        TaskBackupPersistence taskBackupPersistence = this;
        synchronized (taskBackupPersistence) {
            if (!this.bitmap$0) {
                this.namedTemplate = PersistenceSupport.namedTemplate$(this);
                this.bitmap$0 = true;
            }
        }
        return this.namedTemplate;
    }

    @Override
    public NamedParameterJdbcTemplate namedTemplate() {
        if (!this.bitmap$0) {
            return this.namedTemplate$lzycompute();
        }
        return this.namedTemplate;
    }

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    public void upsertTaskBackup(Task task) {
        Option<String> option = this.findTaskBackupId(task.getId(), task.getReleaseUid());
        if (option instanceof Some) {
            this.updateTaskBackupJson(task);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.insertTaskBackupJson(task);
            return;
        }
        throw new MatchError(option);
    }

    public void updateTaskBackupJson(Task task) {
        String taskId = task.getId();
        this.logger().debug((Function0 & Serializable)() -> "Updating existing task " + taskId + " backup into database");
        this.sqlExecWithContent(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("UPDATE " + Schema.TASK_BACKUPS$.MODULE$.TABLE() + "\n         | SET " + Schema.TASK_BACKUPS$.MODULE$.CONTENT() + " = :content\n         | WHERE\n         | " + Schema.TASK_BACKUPS$.MODULE$.TASK_ID() + " = :taskId AND\n         | " + Schema.TASK_BACKUPS$.MODULE$.CI_UID() + " = :releaseCiUid")), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"releaseCiUid"), (Object)task.getReleaseUid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"taskId"), (Object)Ids.getReleaselessChildId((String)taskId))})), (Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"content"), (Object)CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)task)), (Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {});
    }

    private void insertTaskBackupJson(Task task) {
        String taskId = task.getId();
        this.logger().debug((Function0 & Serializable)() -> "Inserting new task " + taskId + " backup into database, releaseCiUid is " + task.getReleaseUid());
        this.sqlExecWithContent(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("INSERT INTO " + Schema.TASK_BACKUPS$.MODULE$.TABLE() + " (\n         |   " + Schema.TASK_BACKUPS$.MODULE$.TASK_ID() + ",\n         |   " + Schema.TASK_BACKUPS$.MODULE$.CI_UID() + ",\n         |   " + Schema.TASK_BACKUPS$.MODULE$.CONTENT() + ")\n         | VALUES (\n         |   :taskId,\n         |   :releaseCiUid,\n         |   :content)")), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"releaseCiUid"), (Object)task.getReleaseUid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"taskId"), (Object)Ids.getReleaselessChildId((String)taskId))})), (Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"content"), (Object)CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)task)), (Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {});
    }

    public Option<String> findTaskBackup(String taskId, Integer releaseCiUid) {
        String releaseId = Ids.releaseIdFrom((String)taskId);
        return this.findOptional((Function1 & Serializable)x$3 -> (String)x$3.queryForObject(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT " + Schema.TASK_BACKUPS$.MODULE$.CONTENT() + " FROM " + Schema.TASK_BACKUPS$.MODULE$.TABLE() + "\n         | WHERE\n         | " + Schema.TASK_BACKUPS$.MODULE$.TASK_ID() + " = ? AND\n         | " + Schema.TASK_BACKUPS$.MODULE$.CI_UID() + " = ?\n       ")), this.binaryStreamRowMapper(), new Object[]{Ids.getReleaselessChildId((String)taskId), releaseCiUid}), this.jdbcTemplate());
    }

    private Option<String> findTaskBackupId(String taskId, Integer releaseCiUid) {
        String releaseId = Ids.releaseIdFrom((String)taskId);
        return this.findOptional((Function1 & Serializable)x$4 -> (String)x$4.queryForObject(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT " + Schema.TASK_BACKUPS$.MODULE$.TASK_ID() + " FROM " + Schema.TASK_BACKUPS$.MODULE$.TABLE() + "\n         | WHERE\n         | " + Schema.TASK_BACKUPS$.MODULE$.TASK_ID() + " = ? AND\n         | " + Schema.TASK_BACKUPS$.MODULE$.CI_UID() + " = ?\n       ")), String.class, new Object[]{Ids.getReleaselessChildId((String)taskId), releaseCiUid}), this.jdbcTemplate());
    }

    private RowMapper<String> binaryStreamRowMapper() {
        return this.binaryStreamRowMapper;
    }

    public TaskBackupPersistence(JdbcTemplate jdbcTemplate, SqlBuilder.Dialect dialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        Utils.$init$(this);
        CompressionSupport.$init$(this);
        PersistenceSupport.$init$(this);
        Logging.$init$((Logging)this);
        this.binaryStreamRowMapper = (rs, x$5) -> {
            String string;
            try (InputStream inputStream = rs.getBinaryStream(Schema.TASK_BACKUPS$.MODULE$.CONTENT());){
                string = this.decompress(inputStream);
            }
            return string;
        };
    }
}

