package com.xebialabs.xlrelease.spring.config

import com.xebialabs.xlrelease.cache.caffeine.XlrCaffeineCacheManager
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.security.sql.SecurityCacheConfigurationCondition
import org.springframework.cache.CacheManager
import org.springframework.cache.annotation.EnableCaching
import org.springframework.context.annotation.{Bean, Conditional, Configuration}

@Configuration
@Conditional(value = Array(classOf[SecurityCacheConfigurationCondition]))
@EnableCaching(proxyTargetClass = true)
class SecurityCacheConfiguration {

  @Bean
  def securityCacheManager(xlrConfig: XlrConfig): CacheManager = {
    new XlrCaffeineCacheManager("securityCacheManager", "security", xlrConfig.cache)
  }

}

