package com.xebialabs.xlrelease.repository.sql

import com.google.common.base.Preconditions.checkState
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.domain.Release

object WorkflowUtils {
  private lazy val DEFAULT_MAX_TEMPLATE_TASK_COUNT = XlrConfig.getInstance.features.workflows.limits.maxTemplateTasks
  private lazy val DEFAULT_MAX_EXECUTION_TASK_COUNT = XlrConfig.getInstance.features.workflows.limits.maxExecutionTasks

  def checkTaskCount(workflow: Release): Unit = {
    if (workflow.isWorkflow) {
      if (workflow.isTemplate) {
        val message = s"Workflow templates cannot exceed $DEFAULT_MAX_TEMPLATE_TASK_COUNT tasks"
        checkState(workflow.getAllTasks.size() <= DEFAULT_MAX_TEMPLATE_TASK_COUNT, message.asInstanceOf[Object])
      } else {
        val message = s"Workflow executions cannot exceed $DEFAULT_MAX_EXECUTION_TASK_COUNT tasks"
        checkState(workflow.getAllTasks.size() <= DEFAULT_MAX_EXECUTION_TASK_COUNT, message.asInstanceOf[Object])
      }
    }
  }
}
