package com.xebialabs.xlrelease.repository.sql

import com.codahale.metrics.annotation.Timed
import com.xebialabs.xlrelease.api.v1.filter.CategoryFilters
import com.xebialabs.xlrelease.db.sql.transaction.{IsReadOnly, IsTransactional}
import com.xebialabs.xlrelease.domain.Category
import com.xebialabs.xlrelease.repository.CategoryRepository
import com.xebialabs.xlrelease.repository.sql.persistence.CategoryPersistence
import org.springframework.data.domain.{Page, Pageable}

@IsTransactional
class SqlCategoryRepository(val categoryPersistence: CategoryPersistence) extends CategoryRepository {

  @Timed
  override def create(category: Category): Category = {
    categoryPersistence.create(category)
  }

  @Timed
  override def update(category: Category): Category = {
    categoryPersistence.update(category)
  }

  @Timed
  override def delete(id: Int): Unit = {
    categoryPersistence.delete(id)
  }

  @Timed
  @IsReadOnly
  override def findByCiUid(id: Int): Option[Category] = {
    categoryPersistence.findByCiUid(id)
  }

  @Timed
  @IsReadOnly
  override def findByTitle(title: String): Option[Category] = {
    categoryPersistence.findByTitle(title)
  }

  @Timed
  @IsReadOnly
  def findByTitles(titles: Seq[String]): Seq[Category] = {
    categoryPersistence.findByTitles(titles)
  }

  @Timed
  @IsReadOnly
  override def findBy(categoryFilters: CategoryFilters, pageable: Pageable): Page[Category] = {
    categoryPersistence.findBy(categoryFilters, pageable)
  }

  @Timed
  @IsReadOnly
  override def findTitlesByReleaseCiUid(releaseUid: Int): Set[String] = {
    categoryPersistence.findTitlesByReleaseCiUid(releaseUid)
  }
}
