/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.sql.WorkflowUtils$;
import java.io.Serializable;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import scala.Function1;
import scala.Option;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Component
@IsTransactional
@ScalaSignature(bytes="\u0006\u0005Y4AAD\b\u00015!AQ\u0006\u0001B\u0001B\u0003%a\u0006\u0003\u00052\u0001\t\u0005\t\u0015!\u00033\u0011\u0015)\u0004\u0001\"\u00017\u0011\u0015Y\u0004\u0001\"\u0011=\u0011\u0015)\u0005\u0001\"\u0011G\u0011\u0015A\u0005\u0001\"\u0003J\u0011\u0015a\u0005\u0001\"\u0003N\u0011\u0015y\u0005\u0001\"\u0003Q\u0011\u0015\u0011\u0006\u0001\"\u0003T\u0011\u0015)\u0006\u0001\"\u0003W\u0011\u0015A\u0006\u0001\"\u0003Z\u0011\u0015Y\u0006\u0001\"\u0003]\u0011\u0015q\u0006\u0001\"\u0003`\u0005u\u0011V\r\\3bg\u0016\u0004VM]:jgR,gnY3J]R,'oY3qi>\u0014(B\u0001\t\u0012\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003%M\t!B]3q_NLGo\u001c:z\u0015\t!R#A\u0005yYJ,G.Z1tK*\u0011acF\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001G\u0001\u0004G>l7\u0001A\n\u0004\u0001m\u0019\u0003C\u0001\u000f\"\u001b\u0005i\"B\u0001\u0010 \u0003\u0011a\u0017M\\4\u000b\u0003\u0001\nAA[1wC&\u0011!%\b\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007\u0011*s%D\u0001\u0012\u0013\t1\u0013C\u0001\fQKJ\u001c\u0018n\u001d;f]\u000e,\u0017J\u001c;fe\u000e,\u0007\u000f^8s!\tA3&D\u0001*\u0015\tQ3#\u0001\u0004e_6\f\u0017N\\\u0005\u0003Y%\u0012qAU3mK\u0006\u001cX-A\tsK2,\u0017m]3SKB|7/\u001b;pef\u0004\"\u0001J\u0018\n\u0005A\n\"!\u0005*fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0006\u0001bm\u001c7eKJ\u0014V\r]8tSR|'/\u001f\t\u0003IMJ!\u0001N\t\u0003!\u0019{G\u000eZ3s%\u0016\u0004xn]5u_JL\u0018A\u0002\u001fj]&$h\bF\u00028si\u0002\"\u0001\u000f\u0001\u000e\u0003=AQ!L\u0002A\u00029BQ!M\u0002A\u0002I\n\u0001b\u001c8De\u0016\fG/\u001a\u000b\u0003{\r\u0003\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012A!\u00168ji\")A\t\u0002a\u0001O\u0005\u00111-[\u0001\t_:,\u0006\u000fZ1uKR\u0011Qh\u0012\u0005\u0006\t\u0016\u0001\raJ\u0001\u0011_:\u001c%/Z1uK>\u0013X\u000b\u001d3bi\u0016$\"!\u0010&\t\u000b-3\u0001\u0019A\u0014\u0002\u000fI,G.Z1tK\u0006Yb/\u00197jI\u0006$X\rR3gCVdG\u000fV1sO\u0016$hi\u001c7eKJ$\"!\u0010(\t\u000b-;\u0001\u0019A\u0014\u00025Y\fG.\u001b3bi\u0016<vN]6gY><\bK]8qKJ$\u0018.Z:\u0015\u0005u\n\u0006\"B&\t\u0001\u00049\u0013\u0001\u0007<bY&$\u0017\r^3O_R\f%k\\8u/>\u00148N\u001a7poR\u0011Q\b\u0016\u0005\u0006\u0017&\u0001\raJ\u0001\u001fm\u0006d\u0017\u000eZ1uK:{G)Y:iE>\f'\u000f\u001a$pe^{'o\u001b4m_^$\"!P,\t\u000b-S\u0001\u0019A\u0014\u0002IY\fG.\u001b3bi\u0016tu\u000eT8dWR\u000b7o\u001b)sKN,g\u000e\u001e$pe^{'o\u001b4m_^$\"!\u0010.\t\u000b-[\u0001\u0019A\u0014\u0002AY\fG.\u001b3bi\u0016tuNU5tWB\u0013xNZ5mK\u001a{'oV8sW\u001adwn\u001e\u000b\u0003{uCQa\u0013\u0007A\u0002\u001d\n\u0011D^1mS\u0012\fG/Z,pe.4Gn\\<UCN\\7i\\;oiR\u0011Q\b\u0019\u0005\u0006\u00176\u0001\ra\n\u0015\u0003\u0001\t\u0004\"aY5\u000e\u0003\u0011T!!\u001a4\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003!\u001dT!\u0001[\n\u0002\u0005\u0011\u0014\u0017B\u00016e\u0005=I5\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007F\u0001\u0001m!\tiG/D\u0001o\u0015\ty\u0007/\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016T!!\u001d:\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011a]\u0001\u0004_J<\u0017BA;o\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class ReleasePersistenceInterceptor
implements PersistenceInterceptor<Release> {
    private final FolderRepository folderRepository;

    public void onDelete(String x$1) {
        super.onDelete(x$1);
    }

    public void afterCreate(ConfigurationItem x$1) {
        super.afterCreate(x$1);
    }

    public void afterUpdate(ConfigurationItem x$1) {
        super.afterUpdate(x$1);
    }

    public void afterDelete(String x$1) {
        super.afterDelete(x$1);
    }

    public void onCreate(Release ci) {
        this.onCreateOrUpdate(ci);
    }

    public void onUpdate(Release ci) {
        this.onCreateOrUpdate(ci);
    }

    private void onCreateOrUpdate(Release release) {
        this.validateDefaultTargetFolder(release);
        this.validateWorkflowProperties(release);
    }

    private void validateDefaultTargetFolder(Release release) {
        boolean defaultTargetFolderIdIsEmpty;
        boolean doesNotAllowTargetFolderOverride = !release.getAllowTargetFolderOverride();
        String defaultTargetFolderId = release.getDefaultTargetFolderId();
        boolean bl = defaultTargetFolderIdIsEmpty = !StringUtils.hasText((String)defaultTargetFolderId);
        if (release.isTemplate() && doesNotAllowTargetFolderOverride && defaultTargetFolderIdIsEmpty) {
            String msg = "Override of the target folder is not allowed, but default target folder is not provided for release with ID [" + release.getId() + "]";
            throw new Checks.IncorrectArgumentException(msg, new Object[0]);
        }
        if (!defaultTargetFolderIdIsEmpty) {
            Option optionalFolder = this.folderRepository.findById(defaultTargetFolderId, 1);
            if (optionalFolder.isEmpty()) {
                throw new Checks.IncorrectArgumentException("Cannot find folder with id [" + defaultTargetFolderId + "]", new Object[0]);
            }
            return;
        }
    }

    private void validateWorkflowProperties(Release release) {
        this.validateNotARootWorkflow(release);
        this.validateNoDashboardForWorkflow(release);
        this.validateNoLockTaskPresentForWorkflow(release);
        this.validateNoRiskProfileForWorkflow(release);
        this.validateWorkflowTaskCount(release);
    }

    private void validateNotARootWorkflow(Release release) {
        String parentFolder = Ids.getParentId((String)release.getId());
        if (release.isWorkflow()) {
            String string = parentFolder;
            String string2 = Ids.ROOT_FOLDER_ID;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw new Checks.IncorrectArgumentException("Workflows can be created only inside a folder", new Object[0]);
            }
        }
    }

    private void validateNoDashboardForWorkflow(Release release) {
        if (release.isWorkflow()) {
            boolean hasDashboards = CollectionConverters$.MODULE$.ListHasAsScala(release.getExtensions()).asScala().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ReleasePersistenceInterceptor.$anonfun$validateNoDashboardForWorkflow$1(x$1)));
            if (hasDashboards) {
                throw new Checks.IncorrectArgumentException("Dashboards are not supported for workflows", new Object[0]);
            }
            return;
        }
    }

    private void validateNoLockTaskPresentForWorkflow(Release release) {
        if (release.isWorkflow()) {
            boolean hasLockTasks = CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isLocked()));
            if (hasLockTasks) {
                throw new Checks.IncorrectArgumentException("Lock tasks are not supported for workflows", new Object[0]);
            }
            return;
        }
    }

    private void validateNoRiskProfileForWorkflow(Release release) {
        if (release.isWorkflow() && release.getRiskProfile() != null) {
            throw new Checks.IncorrectArgumentException("Risk profile is not supported for workflows", new Object[0]);
        }
    }

    private void validateWorkflowTaskCount(Release release) {
        if (release.isWorkflow()) {
            WorkflowUtils$.MODULE$.checkTaskCount(release);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$validateNoDashboardForWorkflow$1(ReleaseExtension x$1) {
        return x$1 instanceof Dashboard;
    }

    public ReleasePersistenceInterceptor(ReleaseRepository releaseRepository, FolderRepository folderRepository) {
        this.folderRepository = folderRepository;
        releaseRepository.registerPersistenceInterceptor((PersistenceInterceptor)this);
    }
}

